/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.utils;

import java.net.URI;

public abstract class HuskyUtils {
    public static final String SERVER_IN_LOGGER = "#serverInLogger";
    public static final String SERVER_OUT_LOGGER = "#serverOutLogger";
    public static final String AUDIT_CONTEXT = "#auditContext";
    public static final String HTTP_CLIENT_POLICY = "#huskyHttpClientPolicy";
    public static final String HTTPS_LITERAL = "https://";
    public static final String HTTP_LITERAL = "http://";

    public static String createEndpoint(String transactionType, URI destination, boolean auditEnabled) {
        return HuskyUtils.createEndpoint(transactionType, destination.toString(), auditEnabled);
    }

    public static String createEndpoint(String transactionType, String destination, boolean auditEnabled) {
        boolean secure = destination.contains(HTTPS_LITERAL);
        return HuskyUtils.createEndpoint(transactionType, destination.toString(), secure, auditEnabled);
    }

    public static String createEndpoint(String transactionType, URI destination, boolean secure, boolean auditEnabled) {
        return HuskyUtils.createEndpoint(transactionType, destination.toString(), secure, auditEnabled);
    }

    public static String createEndpoint(String transactionType, String destination, boolean secure, boolean auditEnabled) {
        String strippedUri = destination.replace(HTTPS_LITERAL, "").replace(HTTP_LITERAL, "");
        String endpoint = String.format("%s://%s?inInterceptors=%s&inFaultInterceptors=%s&outInterceptors=%s&outFaultInterceptors=%s&secure=%s&audit=%s&auditContext=%s&httpClientPolicy=%s", transactionType, strippedUri, SERVER_IN_LOGGER, SERVER_IN_LOGGER, SERVER_OUT_LOGGER, SERVER_OUT_LOGGER, secure, auditEnabled, AUDIT_CONTEXT, HTTP_CLIENT_POLICY);
        return endpoint;
    }
}

