/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.mpi.impl.pix;

import net.ihe.gazelle.hl7v3.prpain201301UV02.PRPAIN201301UV02MFMIMT700701UV01ControlActProcess;
import net.ihe.gazelle.hl7v3.prpain201301UV02.PRPAIN201301UV02Type;
import org.projecthusky.communication.mpi.V3Message;
import org.projecthusky.communication.mpi.impl.PixPdqQueryControlActProcess;
import org.projecthusky.communication.utils.PixPdqV3Utils;

public class V3PixSourceRecordAdded
extends V3Message {
    private PRPAIN201301UV02Type rootElement;

    public V3PixSourceRecordAdded(String senderApplicationOID, String senderFacilityOID, String receiverApplicationOID, String receiverFacilityOID) {
        super(senderApplicationOID);
        this.getRootElement().setInteractionId(PixPdqV3Utils.createII("2.16.840.1.113883.1.6", "PRPA_IN201301UV02", ""));
        this.setSender(senderApplicationOID, senderFacilityOID);
        this.addReceiver(receiverApplicationOID, receiverFacilityOID);
        this.queryControlActProcess = new PixPdqQueryControlActProcess(new PRPAIN201301UV02MFMIMT700701UV01ControlActProcess());
        this.addControlActProcess();
    }

    @Override
    protected void addControlActProcess() {
        this.getRootElement().setControlActProcess(this.queryControlActProcess.getPRPAIN201301UV02MFMIMT700701UV01ControlActProcess());
    }

    public void addReceiver(String applicationOID, String facilityOID) {
        this.addReceivingApplication(applicationOID);
        this.addReceivingFacility(facilityOID);
        this.getRootElement().getReceiver().add(PixPdqV3Utils.createMCCIMT000100UV01Receiver(applicationOID, facilityOID));
    }

    public PRPAIN201301UV02Type getRootElement() {
        if (this.rootElement == null) {
            this.rootElement = new PRPAIN201301UV02Type();
        }
        return this.rootElement;
    }

    @Override
    protected void setId() {
        this.getRootElement().setId(this.messageId);
    }

    @Override
    protected void setAcceptAckCode() {
        this.getRootElement().setAcceptAckCode(PixPdqV3Utils.createCS(this.acceptAckCode));
    }

    @Override
    protected void setCreationTime() {
        this.getRootElement().setCreationTime(PixPdqV3Utils.createTSCurrentTime());
    }

    @Override
    protected void setProcessingCode() {
        this.getRootElement().setProcessingCode(PixPdqV3Utils.createCS(this.processingCode));
    }

    @Override
    protected void setProcessingModeCode() {
        this.getRootElement().setProcessingModeCode(PixPdqV3Utils.createCS(this.processingModeCode));
    }

    @Override
    public void setScopingOrganization(String organizationOID, String organizationName, String telecomValue) {
        super.setScopingOrganization(organizationOID, organizationName, telecomValue);
        this.queryControlActProcess.setCustodian(organizationOID, organizationName);
        this.addControlActProcess();
    }

    @Override
    public void setSender(String applicationOID, String facilityOID) {
        this.sendingApplication = applicationOID;
        this.sendingFacility = facilityOID;
        this.getRootElement().setSender(PixPdqV3Utils.createMCCIMT000100UV01Sender(applicationOID, facilityOID));
    }

    @Override
    protected void setITSVersion() {
        this.getRootElement().setITSVersion(this.itsVersion);
    }
}

