/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.mpi.impl.pix;

import net.ihe.gazelle.hl7v3.coctmt710007UV.COCTMT710007UVPlace;
import net.ihe.gazelle.hl7v3.datatypes.AD;
import net.ihe.gazelle.hl7v3.datatypes.CD;
import net.ihe.gazelle.hl7v3.datatypes.TEL;
import net.ihe.gazelle.hl7v3.prpain201301UV02.PRPAIN201301UV02MFMIMT700701UV01Subject1;
import net.ihe.gazelle.hl7v3.prpain201301UV02.PRPAIN201301UV02Type;
import net.ihe.gazelle.hl7v3.prpain201302UV02.PRPAIN201302UV02MFMIMT700701UV01Subject1;
import net.ihe.gazelle.hl7v3.prpain201302UV02.PRPAIN201302UV02Type;
import net.ihe.gazelle.hl7v3.prpain201304UV02.PRPAIN201304UV02MFMIMT700701UV01Subject1;
import net.ihe.gazelle.hl7v3.prpain201304UV02.PRPAIN201304UV02Type;
import net.ihe.gazelle.hl7v3.prpamt201301UV02.PRPAMT201301UV02BirthPlace;
import net.ihe.gazelle.hl7v3.prpamt201301UV02.PRPAMT201301UV02Citizen;
import net.ihe.gazelle.hl7v3.prpamt201301UV02.PRPAMT201301UV02Employee;
import net.ihe.gazelle.hl7v3.prpamt201301UV02.PRPAMT201301UV02LanguageCommunication;
import net.ihe.gazelle.hl7v3.prpamt201301UV02.PRPAMT201301UV02Nation;
import net.ihe.gazelle.hl7v3.prpamt201301UV02.PRPAMT201301UV02Person;
import net.ihe.gazelle.hl7v3.prpamt201302UV02.PRPAMT201302UV02BirthPlace;
import net.ihe.gazelle.hl7v3.prpamt201302UV02.PRPAMT201302UV02Citizen;
import net.ihe.gazelle.hl7v3.prpamt201302UV02.PRPAMT201302UV02Employee;
import net.ihe.gazelle.hl7v3.prpamt201302UV02.PRPAMT201302UV02LanguageCommunication;
import net.ihe.gazelle.hl7v3.prpamt201302UV02.PRPAMT201302UV02Nation;
import net.ihe.gazelle.hl7v3.prpamt201302UV02.PRPAMT201302UV02PatientPatientPerson;
import net.ihe.gazelle.hl7v3.prpamt201303UV02.PRPAMT201303UV02BirthPlace;
import net.ihe.gazelle.hl7v3.prpamt201303UV02.PRPAMT201303UV02Citizen;
import net.ihe.gazelle.hl7v3.prpamt201303UV02.PRPAMT201303UV02Employee;
import net.ihe.gazelle.hl7v3.prpamt201303UV02.PRPAMT201303UV02LanguageCommunication;
import net.ihe.gazelle.hl7v3.prpamt201303UV02.PRPAMT201303UV02Nation;
import net.ihe.gazelle.hl7v3.prpamt201303UV02.PRPAMT201303UV02Person;
import net.ihe.gazelle.hl7v3.voc.HomeAddressUse;
import net.ihe.gazelle.hl7v3.voc.WorkPlaceAddressUse;
import org.projecthusky.communication.mpi.impl.pix.V3PixSourceMergePatients;
import org.projecthusky.communication.mpi.impl.pix.V3PixSourceRecordAdded;
import org.projecthusky.communication.mpi.impl.pix.V3PixSourceRecordRevised;
import org.projecthusky.communication.utils.PixPdqV3Utils;

public class V3PixSourceMessageHelper {
    private V3PixSourceMergePatients v3MergePatientsMessage;
    private V3PixSourceRecordAdded v3RecordAddedMessage;
    private V3PixSourceRecordRevised v3RecordRevisedMessage;

    public static TEL createTEL(String telecomValue, String useValue) {
        TEL returnTEL = new TEL();
        returnTEL.setValue(telecomValue);
        if (null != useValue) {
            if ("WP".equals(useValue)) {
                returnTEL.setUse(WorkPlaceAddressUse.WP.value());
            } else if ("HP".equals(useValue)) {
                returnTEL.setUse(HomeAddressUse.HP.value());
            } else if ("H".equals(useValue)) {
                returnTEL.setUse(HomeAddressUse.H.value());
            } else if ("MC".equals(useValue)) {
                returnTEL.setUse("MC");
            }
        }
        return returnTEL;
    }

    public V3PixSourceMessageHelper(boolean addMessage, boolean revisedMessage, boolean mergeMessage, String senderApplicationOid, String senderFacilityOid, String receiverApplicationOid, String receiverFacilityOid) {
        if (addMessage) {
            this.v3RecordAddedMessage = new V3PixSourceRecordAdded(senderApplicationOid, senderFacilityOid, receiverApplicationOid, receiverFacilityOid);
            ((PRPAIN201301UV02MFMIMT700701UV01Subject1)this.v3RecordAddedMessage.getRootElement().getControlActProcess().getSubject().get(0)).setContextConductionInd(Boolean.valueOf(false));
        }
        if (revisedMessage) {
            this.v3RecordRevisedMessage = new V3PixSourceRecordRevised(senderApplicationOid, senderFacilityOid, receiverApplicationOid, receiverFacilityOid);
            ((PRPAIN201302UV02MFMIMT700701UV01Subject1)this.v3RecordRevisedMessage.getRootElement().getControlActProcess().getSubject().get(0)).setContextConductionInd(Boolean.valueOf(false));
        }
        if (mergeMessage) {
            this.v3MergePatientsMessage = new V3PixSourceMergePatients(senderApplicationOid, senderFacilityOid, receiverApplicationOid, receiverFacilityOid);
            ((PRPAIN201304UV02MFMIMT700701UV01Subject1)this.v3MergePatientsMessage.getRootElement().getControlActProcess().getSubject().get(0)).setContextConductionInd(Boolean.valueOf(false));
        }
    }

    public void addEmployeeCode(String employeeOccupationCode) {
        PRPAMT201301UV02Employee employee;
        PRPAMT201301UV02Person patientPerson;
        if (this.v3RecordAddedMessage != null) {
            patientPerson = this.getPatientPerson(this.v3RecordAddedMessage);
            employee = new PRPAMT201301UV02Employee();
            employee.setOccupationCode(PixPdqV3Utils.createCE(employeeOccupationCode));
            patientPerson.getAsEmployee().add(employee);
        }
        if (this.v3RecordRevisedMessage != null) {
            patientPerson = this.getPatientPerson(this.v3RecordRevisedMessage);
            employee = new PRPAMT201302UV02Employee();
            employee.setOccupationCode(PixPdqV3Utils.createCE(employeeOccupationCode));
            patientPerson.getAsEmployee().add(employee);
        }
        if (this.v3MergePatientsMessage != null) {
            patientPerson = this.getPatientPerson(this.v3MergePatientsMessage);
            employee = new PRPAMT201303UV02Employee();
            employee.setOccupationCode(PixPdqV3Utils.createCE(employeeOccupationCode));
            patientPerson.getAsEmployee().add(employee);
        }
    }

    public void addLanguageCommunication(String languageCommunication) {
        PRPAMT201301UV02LanguageCommunication communication;
        PRPAMT201301UV02Person patientPerson;
        if (this.v3RecordAddedMessage != null) {
            patientPerson = this.getPatientPerson(this.v3RecordAddedMessage);
            communication = new PRPAMT201301UV02LanguageCommunication();
            communication.setLanguageCode(PixPdqV3Utils.createCE(languageCommunication));
            patientPerson.getLanguageCommunication().add(communication);
        }
        if (this.v3RecordRevisedMessage != null) {
            patientPerson = this.getPatientPerson(this.v3RecordRevisedMessage);
            communication = new PRPAMT201302UV02LanguageCommunication();
            communication.setLanguageCode(PixPdqV3Utils.createCE(languageCommunication));
            patientPerson.getLanguageCommunication().add(communication);
        }
        if (this.v3MergePatientsMessage != null) {
            patientPerson = this.getPatientPerson(this.v3MergePatientsMessage);
            communication = new PRPAMT201303UV02LanguageCommunication();
            communication.setLanguageCode(PixPdqV3Utils.createCE(languageCommunication));
            patientPerson.getLanguageCommunication().add(communication);
        }
    }

    public void addPatientAddress(AD address) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.addPatientAddress(address);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.addPatientAddress(address);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.addPatientAddress(address);
        }
    }

    public void addPatientConfidentialityCode(String code) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.addPatientConfidentialityCode(code);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.addPatientConfidentialityCode(code);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.addPatientConfidentialityCode(code);
        }
    }

    public void addPatientEthnicGroupCode(String code) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.addPatientEthnicGroupCode(code);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.addPatientEthnicGroupCode(code);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.addPatientEthnicGroupCode(code);
        }
    }

    public void addPatientID(String extension, String root, String namespace) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.addPatientID(extension, root, namespace);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.addPatientID(extension, root, namespace);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.addPatientID(extension, root, namespace);
        }
    }

    public void addPatientName(String familyName, String givenName, String otherName, String prefixName, String suffixName) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.addPatientName(familyName, givenName, otherName, prefixName, suffixName);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.addPatientName(familyName, givenName, otherName, prefixName, suffixName);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.addPatientName(familyName, givenName, otherName, prefixName, suffixName);
        }
    }

    public void addPatientNation(String nationCode) {
        PRPAMT201301UV02Nation citizenNation;
        PRPAMT201301UV02Citizen citizen;
        PRPAMT201301UV02Person patientPerson;
        if (this.v3RecordAddedMessage != null) {
            patientPerson = this.getPatientPerson(this.v3RecordAddedMessage);
            citizen = new PRPAMT201301UV02Citizen();
            citizenNation = new PRPAMT201301UV02Nation();
            citizen.setPoliticalNation(citizenNation);
            citizenNation.setCode((CD)PixPdqV3Utils.createCE(nationCode));
            patientPerson.getAsCitizen().add(citizen);
        }
        if (this.v3RecordRevisedMessage != null) {
            patientPerson = this.getPatientPerson(this.v3RecordRevisedMessage);
            citizen = new PRPAMT201302UV02Citizen();
            citizenNation = new PRPAMT201302UV02Nation();
            citizen.setPoliticalNation((PRPAMT201302UV02Nation)citizenNation);
            citizenNation.setCode((CD)PixPdqV3Utils.createCE(nationCode));
            patientPerson.getAsCitizen().add(citizen);
        }
        if (this.v3MergePatientsMessage != null) {
            patientPerson = this.getPatientPerson(this.v3MergePatientsMessage);
            citizen = new PRPAMT201303UV02Citizen();
            citizenNation = new PRPAMT201303UV02Nation();
            citizen.setPoliticalNation((PRPAMT201303UV02Nation)citizenNation);
            citizenNation.setCode((CD)PixPdqV3Utils.createCE(nationCode));
            patientPerson.getAsCitizen().add(citizen);
        }
    }

    public void addPatientOtherID(String extension, String root) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.addPatientOtherID(extension, root);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.addPatientOtherID(extension, root);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.addPatientOtherID(extension, root);
        }
    }

    public void addPatientRaceCode(String code) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.addPatientRaceCode(code);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.addPatientRaceCode(code);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.addPatientRaceCode(code);
        }
    }

    public void addPatientTelecom(String telecomValue, String useValue) {
        PRPAMT201301UV02Person patientPerson;
        if (this.v3RecordAddedMessage != null) {
            patientPerson = this.getPatientPerson(this.v3RecordAddedMessage);
            patientPerson.getTelecom().add(V3PixSourceMessageHelper.createTEL(telecomValue, useValue));
        }
        if (this.v3RecordRevisedMessage != null) {
            patientPerson = this.getPatientPerson(this.v3RecordRevisedMessage);
            patientPerson.getTelecom().add(V3PixSourceMessageHelper.createTEL(telecomValue, useValue));
        }
        if (this.v3MergePatientsMessage != null) {
            patientPerson = this.getPatientPerson(this.v3MergePatientsMessage);
            patientPerson.getTelecom().add(V3PixSourceMessageHelper.createTEL(telecomValue, useValue));
        }
    }

    private PRPAMT201303UV02Person getPatientPerson(V3PixSourceMergePatients v3MergePatientsMessage) {
        if (v3MergePatientsMessage != null) {
            PRPAIN201304UV02Type rootElement = v3MergePatientsMessage.getRootElement();
            return ((PRPAIN201304UV02MFMIMT700701UV01Subject1)rootElement.getControlActProcess().getSubject().get(0)).getRegistrationEvent().getSubject1().getPatient().getPatientPerson();
        }
        return null;
    }

    private PRPAMT201301UV02Person getPatientPerson(V3PixSourceRecordAdded v3RecordAddedMessage) {
        if (v3RecordAddedMessage != null) {
            PRPAIN201301UV02Type rootElement = v3RecordAddedMessage.getRootElement();
            return ((PRPAIN201301UV02MFMIMT700701UV01Subject1)rootElement.getControlActProcess().getSubject().get(0)).getRegistrationEvent().getSubject1().getPatient().getPatientPerson();
        }
        return null;
    }

    private PRPAMT201302UV02PatientPatientPerson getPatientPerson(V3PixSourceRecordRevised v3RecordRevisedMessage) {
        if (v3RecordRevisedMessage != null) {
            PRPAIN201302UV02Type rootElement = v3RecordRevisedMessage.getRootElement();
            return ((PRPAIN201302UV02MFMIMT700701UV01Subject1)rootElement.getControlActProcess().getSubject().get(0)).getRegistrationEvent().getSubject1().getPatient().getPatientPerson();
        }
        return null;
    }

    public V3PixSourceMergePatients getV3MergePatientsMessage() {
        return this.v3MergePatientsMessage;
    }

    public V3PixSourceRecordAdded getV3RecordAddedMessage() {
        return this.v3RecordAddedMessage;
    }

    public V3PixSourceRecordRevised getV3RecordRevisedMessage() {
        return this.v3RecordRevisedMessage;
    }

    public void setPatientBirthPlace(AD addressBirthPlace) {
        COCTMT710007UVPlace place;
        PRPAMT201301UV02BirthPlace birthplace;
        PRPAMT201301UV02Person patientPerson;
        if (this.v3RecordAddedMessage != null) {
            patientPerson = this.getPatientPerson(this.v3RecordAddedMessage);
            birthplace = new PRPAMT201301UV02BirthPlace();
            place = new COCTMT710007UVPlace();
            place.setAddr(addressBirthPlace);
            birthplace.setBirthplace(place);
            patientPerson.setBirthPlace(birthplace);
        }
        if (this.v3RecordRevisedMessage != null) {
            patientPerson = this.getPatientPerson(this.v3RecordRevisedMessage);
            birthplace = new PRPAMT201302UV02BirthPlace();
            place = new COCTMT710007UVPlace();
            place.setAddr(addressBirthPlace);
            birthplace.setBirthplace(place);
            patientPerson.setBirthPlace((PRPAMT201302UV02BirthPlace)birthplace);
        }
        if (this.v3MergePatientsMessage != null) {
            patientPerson = this.getPatientPerson(this.v3MergePatientsMessage);
            birthplace = new PRPAMT201303UV02BirthPlace();
            place = new COCTMT710007UVPlace();
            place.setAddr(addressBirthPlace);
            birthplace.setBirthplace(place);
            patientPerson.setBirthPlace((PRPAMT201303UV02BirthPlace)birthplace);
        }
    }

    public void setPatientBirthTime(String birthTime) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.setPatientBirthTime(birthTime);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.setPatientBirthTime(birthTime);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.setPatientBirthTime(birthTime);
        }
    }

    public void setPatientDeceased(boolean patientDeceased) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.setPatientDeceased(patientDeceased);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.setPatientDeceased(patientDeceased);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.setPatientDeceased(patientDeceased);
        }
    }

    public void setPatientDeceasedTime(String patientDeceasedTime) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.setPatientDeceasedTime(patientDeceasedTime);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.setPatientDeceasedTime(patientDeceasedTime);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.setPatientDeceasedTime(patientDeceasedTime);
        }
    }

    public void setPatientGender(String gender) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.setPatientGender(gender);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.setPatientGender(gender);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.setPatientGender(gender);
        }
    }

    public void setPatientMaritalStatus(String maritalStatus) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.setPatientMaritalStatus(maritalStatus);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.setPatientMaritalStatus(maritalStatus);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.setPatientMaritalStatus(maritalStatus);
        }
    }

    public void setPatientMothersMaidenName(String family, String given, String other, String suffix, String prefix) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.setPatientMothersMaidenName(family, given, other, suffix, prefix);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.setPatientMothersMaidenName(family, given, other, suffix, prefix);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.setPatientMothersMaidenName(family, given, other, suffix, prefix);
        }
    }

    public void setPatientMultipleBirthIndicator(boolean birthIndicator) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.setMultipleBirthIndicator(birthIndicator);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.setMultipleBirthIndicator(birthIndicator);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.setMultipleBirthIndicator(birthIndicator);
        }
    }

    public void setPatientMultipleBirthOrderNumber(int birthNumber) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.setMultipleBirthOrderNumber(birthNumber);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.setMultipleBirthOrderNumber(birthNumber);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.setMultipleBirthOrderNumber(birthNumber);
        }
    }

    public void setPatientReligiousAffiliation(String religiousAffiliation) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.setPatientReligiousAffiliation(religiousAffiliation);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.setPatientReligiousAffiliation(religiousAffiliation);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.setPatientReligiousAffiliation(religiousAffiliation);
        }
    }

    public void setPatientVeryImportantPerson(String code) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.setPatientVeryImportantPerson(code);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.setPatientVeryImportantPerson(code);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.setPatientVeryImportantPerson(code);
        }
    }

    public void setScopingOrganization(String organizationOID, String organizationName, String telecomValue) {
        if (this.v3RecordAddedMessage != null) {
            this.v3RecordAddedMessage.setScopingOrganization(organizationOID, organizationName, telecomValue);
        }
        if (this.v3RecordRevisedMessage != null) {
            this.v3RecordRevisedMessage.setScopingOrganization(organizationOID, organizationName, telecomValue);
        }
        if (this.v3MergePatientsMessage != null) {
            this.v3MergePatientsMessage.setScopingOrganization(organizationOID, organizationName, telecomValue);
        }
    }
}

