/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.mpi.impl.pix;

import net.ihe.gazelle.hl7v3.mfmimt700701UV01.MFMIMT700701UV01PriorRegisteredRole;
import net.ihe.gazelle.hl7v3.mfmimt700701UV01.MFMIMT700701UV01PriorRegistration;
import net.ihe.gazelle.hl7v3.mfmimt700701UV01.MFMIMT700701UV01ReplacementOf;
import net.ihe.gazelle.hl7v3.mfmimt700701UV01.MFMIMT700701UV01Subject3;
import net.ihe.gazelle.hl7v3.prpain201304UV02.PRPAIN201304UV02MFMIMT700701UV01ControlActProcess;
import net.ihe.gazelle.hl7v3.prpain201304UV02.PRPAIN201304UV02Type;
import net.ihe.gazelle.hl7v3.voc.ActClass;
import net.ihe.gazelle.hl7v3.voc.ActMood;
import net.ihe.gazelle.hl7v3.voc.ParticipationTargetSubject;
import org.projecthusky.communication.mpi.V3Message;
import org.projecthusky.communication.mpi.impl.PixPdqQueryControlActProcess;
import org.projecthusky.communication.utils.PixPdqV3Utils;

public class V3PixSourceMergePatients
extends V3Message {
    private PRPAIN201304UV02Type rootElement;
    private String patientId = "";

    public V3PixSourceMergePatients(String senderApplicationOID, String senderFacilityOID, String receiverApplicationOID, String receiverFacilityOID) {
        super(senderApplicationOID);
        this.getRootElement().setInteractionId(PixPdqV3Utils.createII("2.16.840.1.113883.1.6", "PRPA_IN201304UV02", ""));
        this.setSender(senderApplicationOID, senderFacilityOID);
        this.addReceiver(receiverApplicationOID, receiverFacilityOID);
        this.queryControlActProcess = new PixPdqQueryControlActProcess(new PRPAIN201304UV02MFMIMT700701UV01ControlActProcess());
        this.addControlActProcess();
    }

    public void addReceiver(String applicationOID, String facilityOID) {
        this.addReceivingApplication(applicationOID);
        this.addReceivingFacility(facilityOID);
        this.getRootElement().getReceiver().add(PixPdqV3Utils.createMCCIMT000100UV01Receiver(applicationOID, facilityOID));
    }

    public String getPatientId() {
        return this.patientId;
    }

    public PRPAIN201304UV02Type getRootElement() {
        if (this.rootElement == null) {
            this.rootElement = new PRPAIN201304UV02Type();
        }
        return this.rootElement;
    }

    public void setObsoletePatientID(String extension, String root, String namespace) {
        StringBuilder idString = new StringBuilder();
        idString.append(extension).append("^^^");
        if (namespace != null) {
            idString.append(namespace);
        }
        idString.append("&").append(root).append("&ISO");
        this.patientId = idString.toString();
        MFMIMT700701UV01ReplacementOf replacementOf = new MFMIMT700701UV01ReplacementOf();
        this.queryControlActProcess.getPRPAIN201304UV02MFMIMT700701UV01RegistrationEvent().getReplacementOf().add(replacementOf);
        replacementOf.setTypeCode("RPLC");
        MFMIMT700701UV01PriorRegistration priorRegistration = new MFMIMT700701UV01PriorRegistration();
        replacementOf.setPriorRegistration(priorRegistration);
        priorRegistration.setClassCode(ActClass.REG);
        priorRegistration.setMoodCode(ActMood.EVN);
        priorRegistration.setStatusCode(PixPdqV3Utils.createCS("obsolete"));
        MFMIMT700701UV01Subject3 priorRegistrationSubject = new MFMIMT700701UV01Subject3();
        priorRegistration.setSubject1(priorRegistrationSubject);
        priorRegistrationSubject.setTypeCode(ParticipationTargetSubject.SBJ);
        MFMIMT700701UV01PriorRegisteredRole priorRegisteredRole = new MFMIMT700701UV01PriorRegisteredRole();
        priorRegistrationSubject.setPriorRegisteredRole(priorRegisteredRole);
        priorRegisteredRole.setClassCode("PAT");
        priorRegisteredRole.getId().add(PixPdqV3Utils.createII(root, extension, namespace));
    }

    public void setProcessingCode(String processingCode) {
        this.getRootElement().setProcessingCode(PixPdqV3Utils.createCS(processingCode));
    }

    @Override
    public void setSender(String applicationOID, String facilityOID) {
        super.setSender(applicationOID, facilityOID);
        this.getRootElement().setSender(PixPdqV3Utils.createMCCIMT000100UV01Sender(applicationOID, facilityOID));
    }

    @Override
    protected void addControlActProcess() {
        this.getRootElement().setControlActProcess(this.queryControlActProcess.getPRPAIN201304UV02MFMIMT700701UV01ControlActProcess());
    }

    @Override
    protected void setITSVersion() {
        this.getRootElement().setITSVersion(this.itsVersion);
    }

    @Override
    protected void setProcessingCode() {
        this.setProcessingCode(this.processingCode);
    }

    @Override
    protected void setProcessingModeCode() {
        this.getRootElement().setProcessingModeCode(PixPdqV3Utils.createCS(this.processingModeCode));
    }

    @Override
    protected void setId() {
        this.getRootElement().setId(this.messageId);
    }

    @Override
    protected void setCreationTime() {
        this.getRootElement().setCreationTime(PixPdqV3Utils.createTSCurrentTime());
    }

    @Override
    protected void setAcceptAckCode() {
        this.getRootElement().setAcceptAckCode(PixPdqV3Utils.createCS(this.acceptAckCode));
    }
}

