/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.mpi.impl.pix;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import net.ihe.gazelle.hl7v3.mcciin000002UV01.MCCIIN000002UV01Type;
import net.ihe.gazelle.hl7v3.prpain201301UV02.PRPAIN201301UV02Type;
import net.ihe.gazelle.hl7v3.prpain201302UV02.PRPAIN201302UV02Type;
import net.ihe.gazelle.hl7v3.prpain201304UV02.PRPAIN201304UV02Type;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.hl7v3.PIXV3;
import org.projecthusky.communication.CamelService;
import org.projecthusky.communication.mpi.V3Acknowledgement;
import org.projecthusky.communication.mpi.impl.pix.V3PixSourceMergePatients;
import org.projecthusky.communication.mpi.impl.pix.V3PixSourceRecordAdded;
import org.projecthusky.communication.mpi.impl.pix.V3PixSourceRecordRevised;
import org.projecthusky.communication.utils.HuskyUtils;
import org.projecthusky.xua.core.SecurityHeaderElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V3PixSource
extends CamelService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)V3PixSource.class.getName());
    private URI serverURI;

    public V3PixSource(URI pixServerURI, CamelContext context, AuditContext auditorContext) {
        this.serverURI = pixServerURI;
        this.setAuditContext(auditorContext);
        this.setCamelContext(context);
    }

    public URI getServerURI() {
        return this.serverURI;
    }

    public V3Acknowledgement sendMergePatients(V3PixSourceMergePatients v3query, SecurityHeaderElement assertion, String messageId) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Beginning Send Patient Record Duplicates Resolved (V3)");
        }
        V3Acknowledgement v3response = new V3Acknowledgement(this.sendITI44Query(v3query.getRootElement(), assertion, this.getServerURI(), "urn:hl7-org:v3:PRPA_IN201304UV02", messageId));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Ending Send Patient Record Duplicates Resolved (V3)");
        }
        return v3response;
    }

    public V3Acknowledgement sendRecordAdded(V3PixSourceRecordAdded v3query, SecurityHeaderElement assertion, String messageId) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Beginning Send Patient Record Added (V3)");
        }
        V3Acknowledgement v3response = new V3Acknowledgement(this.sendITI44Query(v3query.getRootElement(), assertion, this.getServerURI(), "urn:hl7-org:v3:PRPA_IN201301UV02", messageId));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Ending Send Patient Record Added (V3)");
        }
        return v3response;
    }

    public V3Acknowledgement sendRecordRevised(V3PixSourceRecordRevised v3query, SecurityHeaderElement assertion, String messageId) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Beginning Send Patient Record Revised (V3)");
        }
        V3Acknowledgement v3response = new V3Acknowledgement(this.sendITI44Query(v3query.getRootElement(), assertion, this.getServerURI(), "urn:hl7-org:v3:PRPA_IN201302UV02", messageId));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Ending Send Patient Record Revised (V3)");
        }
        return v3response;
    }

    private MCCIIN000002UV01Type sendITI44Query(PRPAIN201304UV02Type request, SecurityHeaderElement assertion, URI pdqDest, String action, String messageId) throws Exception {
        Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{PRPAIN201304UV02Type.class}).createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF8");
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal((Object)request, (Writer)stringWriter);
        String xml = this.sendITI44Query(stringWriter.toString(), assertion, pdqDest, action, messageId);
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{MCCIIN000002UV01Type.class}).createUnmarshaller();
        return (MCCIIN000002UV01Type)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }

    private MCCIIN000002UV01Type sendITI44Query(PRPAIN201302UV02Type request, SecurityHeaderElement assertion, URI pdqDest, String action, String messageId) throws Exception {
        Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{PRPAIN201302UV02Type.class}).createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF8");
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal((Object)request, (Writer)stringWriter);
        String xml = this.sendITI44Query(stringWriter.toString(), assertion, pdqDest, action, messageId);
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{MCCIIN000002UV01Type.class}).createUnmarshaller();
        return (MCCIIN000002UV01Type)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }

    private MCCIIN000002UV01Type sendITI44Query(PRPAIN201301UV02Type request, SecurityHeaderElement assertion, URI pdqDest, String action, String messageId) throws Exception {
        Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{PRPAIN201301UV02Type.class}).createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF8");
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal((Object)request, (Writer)stringWriter);
        String xml = this.sendITI44Query(stringWriter.toString(), assertion, pdqDest, action, messageId);
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{MCCIIN000002UV01Type.class}).createUnmarshaller();
        return (MCCIIN000002UV01Type)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }

    private String sendITI44Query(String request, SecurityHeaderElement assertion, URI pdqDest, String action, String messageId) throws Exception {
        String endpoint = HuskyUtils.createEndpoint(PIXV3.Interactions.ITI_44_PIX.getWsTransactionConfiguration().getName(), pdqDest, true, this.getAuditContext().isAuditEnabled());
        LOGGER.info("Sending request to '{}' endpoint", (Object)endpoint);
        HashMap<String, String> outgoingHeaders = new HashMap<String, String>();
        outgoingHeaders.put("Accept", "application/soap+xml");
        outgoingHeaders.put("Content-Type", String.format("application/soap+xml; charset=UTF-8; action=\"%s\"", action));
        Exchange exchange = this.send(endpoint, request, assertion, messageId, outgoingHeaders);
        return (String)exchange.getMessage().getBody(String.class);
    }
}

