/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.mpi.impl.pdq;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.ihe.gazelle.hl7v3.datatypes.TEL;
import net.ihe.gazelle.hl7v3.prpamt201306UV02.PRPAMT201306UV02PatientTelecom;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.projecthusky.communication.mpi.MpiQuery;
import org.projecthusky.communication.mpi.impl.pdq.V3PdqConsumerQuery;
import org.projecthusky.communication.mpi.impl.pdq.V3PdqConsumerResponse;
import org.projecthusky.communication.utils.PixPdqV3Utils;
import org.projecthusky.fhir.structures.gen.FhirCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V3PdqQuery
implements MpiQuery {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean cancelQuery;
    private boolean continueQuery;
    private V3PdqConsumerResponse lastPdqConsumerResponse;
    private int pageCount;
    private final V3PdqConsumerQuery v3PdqConsumerQuery;

    public V3PdqQuery(String senderApplicationOID, String senderFacilityOID, String receiverApplicationOID, String receiverFacilityOID) {
        this.v3PdqConsumerQuery = new V3PdqConsumerQuery(senderApplicationOID, senderFacilityOID, receiverApplicationOID, receiverFacilityOID);
    }

    @Override
    public MpiQuery addDomainToReturn(String organizationOID) {
        if (organizationOID != null) {
            this.v3PdqConsumerQuery.addDomainToReturn(organizationOID);
        }
        return this;
    }

    @Override
    public MpiQuery addMothersMaidenName(boolean useFuzzySearch, HumanName humanDt) {
        this.v3PdqConsumerQuery.addPatientMothersMaidenName(useFuzzySearch, humanDt.getFamily(), humanDt.getGivenAsSingleString(), null, humanDt.getSuffixAsSingleString(), humanDt.getPrefixAsSingleString());
        return this;
    }

    @Override
    public MpiQuery addPatientAddress(Address address) {
        if (address == null) {
            this.log.error("Address not specified");
            return this;
        }
        this.v3PdqConsumerQuery.addPatientAddress(address);
        return this;
    }

    @Override
    public MpiQuery addPatientIdentifier(Identifier identifier) {
        if (identifier != null && identifier.getSystem() != null && identifier.getSystem().length() > 8 && identifier.getSystem().startsWith("urn:oid:")) {
            String oid = FhirCommon.removeUrnOidPrefix((String)identifier.getSystem());
            this.v3PdqConsumerQuery.addPatientID(oid, identifier.getValue(), "");
        } else if (identifier != null) {
            this.v3PdqConsumerQuery.addPatientID(identifier.getSystem(), identifier.getValue(), "");
        }
        return this;
    }

    @Override
    public MpiQuery addPatientName(boolean useFuzzySearch, HumanName humanDt) {
        this.v3PdqConsumerQuery.addPatientName(useFuzzySearch, humanDt.getFamily(), humanDt.getGivenAsSingleString(), null, humanDt.getSuffixAsSingleString(), humanDt.getPrefixAsSingleString());
        return this;
    }

    @Override
    public MpiQuery addPatientTelecom(ContactPoint contactPoint) {
        if (contactPoint == null) {
            this.log.error("ContactPoint not specified");
            return this;
        }
        if (ContactPoint.ContactPointSystem.PHONE.equals(contactPoint.getSystemElement().getValue())) {
            String use = "";
            if (ContactPoint.ContactPointUse.HOME.equals(contactPoint.getUseElement().getValue())) {
                use = "HP";
            } else if (ContactPoint.ContactPointUse.WORK.equals(contactPoint.getUseElement().getValue())) {
                use = "WP";
            }
            this.addPatientTelecom(contactPoint.getValue(), use);
        } else {
            this.log.error("no phone specified as telecom {}", contactPoint.getSystemElement().getValue());
        }
        return this;
    }

    private void addPatientTelecom(String telecom, String type) {
        PRPAMT201306UV02PatientTelecom patientTel = new PRPAMT201306UV02PatientTelecom();
        TEL tel = PixPdqV3Utils.createTEL(telecom, type);
        patientTel.getValue().add(tel);
        patientTel.setSemanticsText(PixPdqV3Utils.createST("Patient.telecom"));
        this.v3PdqConsumerQuery.getParameterList().getPatientTelecom().add(patientTel);
    }

    @Override
    public MpiQuery cancelQuery() {
        this.cancelQuery = true;
        return this;
    }

    @Override
    public MpiQuery continueQuery() {
        this.continueQuery = true;
        return this;
    }

    public boolean doCancelQuery() {
        return this.cancelQuery;
    }

    public boolean doContinueQuery() {
        return this.continueQuery;
    }

    public V3PdqConsumerResponse getLastPdqConsumerResponse() {
        return this.lastPdqConsumerResponse;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public V3PdqConsumerQuery getV3PdqConsumerQuery() {
        return this.v3PdqConsumerQuery;
    }

    public void setLastPdqConsumerResponse(V3PdqConsumerResponse lastPdqConsumerResponse) {
        this.lastPdqConsumerResponse = lastPdqConsumerResponse;
    }

    @Override
    public MpiQuery setPageCount(int pageCount) {
        this.pageCount = pageCount;
        this.v3PdqConsumerQuery.setInitialQuantity(pageCount);
        return this;
    }

    @Override
    public MpiQuery setPatientBirthDate(Date date) {
        if (date == null) {
            this.log.error("date not specified");
            return this;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        this.v3PdqConsumerQuery.setPatientDateOfBirth(sdf.format(date));
        return this;
    }

    @Override
    public MpiQuery setPatientSex(Enumerations.AdministrativeGender administrativeGender) {
        if (administrativeGender == null) {
            this.log.error("adminstrativeGenderEnum not specified");
            return this;
        }
        if (administrativeGender.equals((Object)Enumerations.AdministrativeGender.FEMALE)) {
            this.v3PdqConsumerQuery.setPatientSex("F");
        } else if (administrativeGender.equals((Object)Enumerations.AdministrativeGender.MALE)) {
            this.v3PdqConsumerQuery.setPatientSex("M");
        } else if (administrativeGender.equals((Object)Enumerations.AdministrativeGender.OTHER)) {
            this.v3PdqConsumerQuery.setPatientSex("U");
        }
        return this;
    }
}

