/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.mpi.impl.pdq;

import net.ihe.gazelle.hl7v3.datatypes.II;
import net.ihe.gazelle.hl7v3.mccimt000300UV01.MCCIMT000300UV01Acknowledgement;
import net.ihe.gazelle.hl7v3.mccimt000300UV01.MCCIMT000300UV01TargetMessage;
import net.ihe.gazelle.hl7v3.quqiin000003UV01.QUQIIN000003UV01Type;
import net.ihe.gazelle.hl7v3.quqimt000001UV01.QUQIMT000001UV01ControlActProcess;
import net.ihe.gazelle.hl7v3.quqimt000001UV01.QUQIMT000001UV01QueryContinuation;
import net.ihe.gazelle.hl7v3.voc.ActClassControlAct;
import net.ihe.gazelle.hl7v3.voc.XActMoodIntentEvent;
import org.projecthusky.communication.mpi.V3Message;
import org.projecthusky.communication.mpi.impl.pdq.V3PdqConsumerResponse;
import org.projecthusky.communication.utils.PixPdqV3Utils;

public abstract class V3PdqContinuationBase
extends V3Message {
    protected QUQIIN000003UV01Type rootElement;
    protected QUQIMT000001UV01QueryContinuation queryContinuation = new QUQIMT000001UV01QueryContinuation();

    protected V3PdqContinuationBase(String senderApplicationOID, String senderFacilityOID, String receiverApplicationOID, String receiverFacilityOID, V3PdqConsumerResponse v3pdqresponse) {
        super(senderApplicationOID);
        this.getRootElement().setInteractionId(PixPdqV3Utils.createII("2.16.840.1.113883.1.6", "QUQI_IN000003UV01", ""));
        this.setSender(senderApplicationOID, senderFacilityOID);
        this.addReceiver(receiverApplicationOID, receiverFacilityOID);
        MCCIMT000300UV01Acknowledgement acknowledgement = new MCCIMT000300UV01Acknowledgement();
        this.getRootElement().getAcknowledgement().add(acknowledgement);
        acknowledgement.setTypeCode(PixPdqV3Utils.createCS("AA"));
        MCCIMT000300UV01TargetMessage targetMessage = new MCCIMT000300UV01TargetMessage();
        acknowledgement.setTargetMessage(targetMessage);
        targetMessage.setId(PixPdqV3Utils.copyII(v3pdqresponse.getMessageId()));
        QUQIMT000001UV01ControlActProcess continuationCAP = new QUQIMT000001UV01ControlActProcess();
        this.getRootElement().setControlActProcess(continuationCAP);
        continuationCAP.setClassCode(ActClassControlAct.CACT);
        continuationCAP.setMoodCode(XActMoodIntentEvent.EVN);
        continuationCAP.setCode(PixPdqV3Utils.createCD("PRPA_TE000003UV01", "", "", ""));
        continuationCAP.setQueryContinuation(this.queryContinuation);
        this.queryContinuation.setQueryId(PixPdqV3Utils.copyII(v3pdqresponse.getAckQueryID()));
    }

    public void addReceiver(String applicationOID, String facilityOID) {
        this.addReceivingApplication(applicationOID);
        this.addReceivingFacility(facilityOID);
        this.getRootElement().getReceiver().add(PixPdqV3Utils.createMCCIMT000300UV01Receiver(applicationOID, facilityOID));
    }

    @Override
    protected void setAcceptAckCode() {
        this.getRootElement().setAcceptAckCode(PixPdqV3Utils.createCS(this.acceptAckCode));
    }

    @Override
    public void setSender(String applicationOID, String facilityOID) {
        super.setSender(applicationOID, facilityOID);
        this.getRootElement().setSender(PixPdqV3Utils.createMCCIMT000300UV01Sender(applicationOID, facilityOID));
    }

    public II getId() {
        return this.messageId;
    }

    public QUQIIN000003UV01Type getRootElement() {
        if (this.rootElement == null) {
            this.rootElement = new QUQIIN000003UV01Type();
        }
        return this.rootElement;
    }

    @Override
    protected void setITSVersion() {
        this.getRootElement().setITSVersion(this.itsVersion);
    }

    @Override
    protected void setId() {
        this.getRootElement().setId(this.messageId);
    }

    @Override
    protected void setCreationTime() {
        this.getRootElement().setCreationTime(PixPdqV3Utils.createTSCurrentTime());
    }

    @Override
    protected void setProcessingCode() {
        this.getRootElement().setProcessingCode(PixPdqV3Utils.createCS(this.processingCode));
    }

    public void setProcessingCode(String code) {
        this.getRootElement().setProcessingCode(PixPdqV3Utils.createCS(code));
    }

    @Override
    protected void setProcessingModeCode() {
        this.getRootElement().setProcessingModeCode(PixPdqV3Utils.createCS(this.processingModeCode));
    }
}

