/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.mpi.impl.pdq;

import java.io.Serializable;
import java.util.List;
import net.ihe.gazelle.hl7v3.datatypes.AD;
import net.ihe.gazelle.hl7v3.datatypes.EN;
import net.ihe.gazelle.hl7v3.datatypes.II;
import net.ihe.gazelle.hl7v3.datatypes.PN;
import net.ihe.gazelle.hl7v3.datatypes.ST;
import net.ihe.gazelle.hl7v3.mccimt000300UV01.MCCIMT000300UV01Acknowledgement;
import net.ihe.gazelle.hl7v3.mccimt000300UV01.MCCIMT000300UV01AcknowledgementDetail;
import net.ihe.gazelle.hl7v3.mccimt000300UV01.MCCIMT000300UV01Receiver;
import net.ihe.gazelle.hl7v3.prpain201306UV02.PRPAIN201306UV02MFMIMT700711UV01Subject1;
import net.ihe.gazelle.hl7v3.prpain201306UV02.PRPAIN201306UV02Type;
import net.ihe.gazelle.hl7v3.prpamt201310UV02.PRPAMT201310UV02Patient;
import net.ihe.gazelle.hl7v3.prpamt201310UV02.PRPAMT201310UV02PersonalRelationship;
import org.projecthusky.communication.mpi.V3Response;
import org.projecthusky.communication.utils.PixPdqV3Utils;

public class V3PdqConsumerResponse
extends V3Response {
    private PRPAIN201306UV02Type rootElement = null;
    private String queryAcknowledgement = null;

    public V3PdqConsumerResponse(PRPAIN201306UV02Type pdqConsumerResponseElement) {
        this.rootElement = pdqConsumerResponseElement;
        this.messageId = this.rootElement.getId();
        this.sendingApplication = ((II)this.rootElement.getSender().getDevice().getId().get(0)).getRoot();
        if (null != this.rootElement.getSender().getDevice().getAsAgent() && null != this.rootElement.getSender().getDevice().getAsAgent().getRepresentedOrganization() && !this.rootElement.getSender().getDevice().getAsAgent().getRepresentedOrganization().getId().isEmpty()) {
            this.sendingFacility = ((II)this.rootElement.getSender().getDevice().getAsAgent().getRepresentedOrganization().getId().get(0)).getRoot();
        }
        int numReceivers = this.rootElement.getReceiver().size();
        for (int i = 0; i < numReceivers; ++i) {
            this.receivingApplication.add(((II)((MCCIMT000300UV01Receiver)this.rootElement.getReceiver().get(i)).getDevice().getId().get(0)).getRoot());
            if (null == ((MCCIMT000300UV01Receiver)this.rootElement.getReceiver().get(i)).getDevice().getAsAgent()) continue;
            this.receivingFacility.add(((II)((MCCIMT000300UV01Receiver)this.rootElement.getReceiver().get(i)).getDevice().getAsAgent().getRepresentedOrganization().getId().get(0)).getRoot());
        }
        this.acknowledgementCode = ((MCCIMT000300UV01Acknowledgement)this.rootElement.getAcknowledgement().get(0)).getTypeCode().getCode();
        this.setAcknowledgementDetails();
        if (this.acknowledgementCode.equalsIgnoreCase("AA")) {
            this.queryAcknowledgement = this.rootElement.getControlActProcess().getQueryAck().getQueryResponseCode().getCode();
            this.setErrorText();
        } else {
            this.errorText = "Acknowledgement Code: " + this.acknowledgementCode + " not understood.";
        }
    }

    private void setAcknowledgementDetails() {
        if (!((MCCIMT000300UV01Acknowledgement)this.rootElement.getAcknowledgement().get(0)).getAcknowledgementDetail().isEmpty()) {
            String detailCode = "";
            Object detailText = "";
            if (null != ((MCCIMT000300UV01AcknowledgementDetail)((MCCIMT000300UV01Acknowledgement)this.rootElement.getAcknowledgement().get(0)).getAcknowledgementDetail().get(0)).getCode()) {
                detailCode = ((MCCIMT000300UV01AcknowledgementDetail)((MCCIMT000300UV01Acknowledgement)this.rootElement.getAcknowledgement().get(0)).getAcknowledgementDetail().get(0)).getCode().getCode();
            }
            if (null != ((MCCIMT000300UV01AcknowledgementDetail)((MCCIMT000300UV01Acknowledgement)this.rootElement.getAcknowledgement().get(0)).getAcknowledgementDetail().get(0)).getText()) {
                detailText = ((Serializable)((MCCIMT000300UV01AcknowledgementDetail)((MCCIMT000300UV01Acknowledgement)this.rootElement.getAcknowledgement().get(0)).getAcknowledgementDetail().get(0)).getText().getMixed().get(0)).toString();
            }
            if (((MCCIMT000300UV01AcknowledgementDetail)((MCCIMT000300UV01Acknowledgement)this.rootElement.getAcknowledgement().get(0)).getAcknowledgementDetail().get(0)).getLocation() != null && !((MCCIMT000300UV01AcknowledgementDetail)((MCCIMT000300UV01Acknowledgement)this.rootElement.getAcknowledgement().get(0)).getAcknowledgementDetail().get(0)).getLocation().isEmpty()) {
                detailText = (String)detailText + " Location: " + ((Serializable)((ST)((MCCIMT000300UV01AcknowledgementDetail)((MCCIMT000300UV01Acknowledgement)this.rootElement.getAcknowledgement().get(0)).getAcknowledgementDetail().get(0)).getLocation().get(0)).getMixed().get(0)).toString();
            }
            this.acknowledgementDetailCode = detailCode;
            this.acknowledgementDetailText = detailText;
        }
    }

    private void setErrorText() {
        if (this.queryAcknowledgement.equalsIgnoreCase("AE")) {
            this.errorText = "Query Acknowledgement: AE - Application Error";
        } else if (this.queryAcknowledgement.equalsIgnoreCase("QE")) {
            this.errorText = "Query Acknowledgement: QE - Query Parameter Error";
        } else if (this.queryAcknowledgement.equalsIgnoreCase("NF")) {
            this.hasError = false;
            this.errorText = "No patients found.";
        } else if (this.queryAcknowledgement.equalsIgnoreCase("OK")) {
            this.hasError = false;
        } else {
            this.errorText = "Query Acknowledgement: " + this.queryAcknowledgement + " not understood.";
        }
    }

    public II getAckQueryID() {
        return this.rootElement.getControlActProcess().getQueryAck().getQueryId();
    }

    public int getNumPatientIDs(int patientIndex) {
        return this.getPatientByIndex(patientIndex).getId().size();
    }

    public int getNumRecordsCurrent() {
        int numRecords = 0;
        if (this.rootElement != null && this.rootElement.getControlActProcess().getQueryAck().getResultCurrentQuantity() != null) {
            numRecords = this.rootElement.getControlActProcess().getQueryAck().getResultCurrentQuantity().getValue();
        }
        return numRecords;
    }

    public int getNumRecordsRemaining() {
        int numRecords = 0;
        if (this.rootElement != null && this.rootElement.getControlActProcess().getQueryAck().getResultRemainingQuantity() != null) {
            numRecords = this.rootElement.getControlActProcess().getQueryAck().getResultRemainingQuantity().getValue();
        }
        return numRecords;
    }

    public String[] getPatientAddress(int patientIndex) {
        return this.getPatientAddress(patientIndex, 0);
    }

    public String[] getPatientAddress(int patientIndex, int addrIndex) {
        String[] addressArray = new String[9];
        if (this.getPatientByIndex(patientIndex).getPatientPerson().getAddr().size() > addrIndex) {
            addressArray = PixPdqV3Utils.adToStringArray((AD)this.getPatientByIndex(patientIndex).getPatientPerson().getAddr().get(addrIndex));
        }
        return addressArray;
    }

    public String getPatientBirthOrderNumber(int patientIndex) {
        if (this.getPatientByIndex(patientIndex).getPatientPerson().getMultipleBirthOrderNumber() != null) {
            Integer birthOrder = this.getPatientByIndex(patientIndex).getPatientPerson().getMultipleBirthOrderNumber().getValue();
            return birthOrder.toString();
        }
        return null;
    }

    private PRPAMT201310UV02Patient getPatientByIndex(int patientIndex) {
        return ((PRPAIN201306UV02MFMIMT700711UV01Subject1)this.rootElement.getControlActProcess().getSubject().get(patientIndex)).getRegistrationEvent().getSubject1().getPatient();
    }

    public String getPatientDOB(int patientIndex) {
        String patientDOB = "";
        if (this.getPatientByIndex(patientIndex).getPatientPerson().getBirthTime() != null) {
            patientDOB = this.getPatientByIndex(patientIndex).getPatientPerson().getBirthTime().getValue();
        }
        return patientDOB;
    }

    public String[] getPatientID(int patientIndex) {
        return this.getPatientID(patientIndex, 0);
    }

    public String[] getPatientID(int patientIndex, int idIndex) {
        String[] response = null;
        if (this.getPatientByIndex(patientIndex).getId().size() > idIndex) {
            response = PixPdqV3Utils.iiToStringArray((II)this.getPatientByIndex(patientIndex).getId().get(idIndex));
        }
        return response;
    }

    public String[] getPatientIds() {
        String[] patientIds = new String[this.getNumRecordsCurrent()];
        for (int i = 0; i < this.getNumRecordsCurrent(); ++i) {
            String[] patientId = this.getPatientID(i);
            patientIds[i] = patientId[0] + "^^^&" + patientId[2] + "&" + patientId[1];
        }
        return patientIds;
    }

    public String[] getPatientMothersMaidenName(int patientIndex) {
        return this.getPatientName(patientIndex, 0);
    }

    public String[] getPatientMothersMaidenName(int patientIndex, int nameIndex) {
        List relationship = this.getPatientByIndex(patientIndex).getPatientPerson().getPersonalRelationship();
        if (relationship != null) {
            for (PRPAMT201310UV02PersonalRelationship pr : relationship) {
                if (!pr.getCode().getCode().equalsIgnoreCase("MTH")) continue;
                return PixPdqV3Utils.enToStringArray((EN)pr.getRelationshipHolder1().getName().get(nameIndex));
            }
        }
        return new String[0];
    }

    public String getPatientMultipleBirthIndicator(int patientIndex) {
        if (this.getPatientByIndex(patientIndex).getPatientPerson().getMultipleBirthInd() != null) {
            boolean response = this.getPatientByIndex((int)patientIndex).getPatientPerson().getMultipleBirthInd().value;
            if (response) {
                return "true";
            }
            return "false";
        }
        return null;
    }

    public String[] getPatientName(int patientIndex) {
        return this.getPatientName(patientIndex, 0);
    }

    public String[] getPatientName(int patientIndex, int nameIndex) {
        return PixPdqV3Utils.pnToStringArray((PN)this.getPatientByIndex(patientIndex).getPatientPerson().getName().get(nameIndex));
    }

    public String getPatientPhoneBusiness(int patientIndex) {
        return PixPdqV3Utils.getTelecomByUseCode(this.getPatientByIndex(patientIndex).getPatientPerson().getTelecom(), "WP");
    }

    public String getPatientPhoneHome(int patientIndex) {
        return PixPdqV3Utils.getTelecomByUseCode(this.getPatientByIndex(patientIndex).getPatientPerson().getTelecom(), "HP");
    }

    public String getPatientSex(int patientIndex) {
        return this.getPatientByIndex(patientIndex).getPatientPerson().getAdministrativeGenderCode().getCode();
    }

    public PRPAIN201306UV02Type getPdqResponse() {
        return this.rootElement;
    }

    public String getQueryAcknowledgement() {
        return this.queryAcknowledgement;
    }
}

