/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.mpi.impl.pdq;

import net.ihe.gazelle.hl7v3.datatypes.AD;
import net.ihe.gazelle.hl7v3.datatypes.ANY;
import net.ihe.gazelle.hl7v3.datatypes.EN;
import net.ihe.gazelle.hl7v3.datatypes.II;
import net.ihe.gazelle.hl7v3.datatypes.PN;
import net.ihe.gazelle.hl7v3.datatypes.TEL;
import net.ihe.gazelle.hl7v3.prpain201305UV02.PRPAIN201305UV02QUQIMT021001UV01ControlActProcess;
import net.ihe.gazelle.hl7v3.prpain201305UV02.PRPAIN201305UV02Type;
import net.ihe.gazelle.hl7v3.prpamt201306UV02.PRPAMT201306UV02LivingSubjectAdministrativeGender;
import net.ihe.gazelle.hl7v3.prpamt201306UV02.PRPAMT201306UV02LivingSubjectBirthTime;
import net.ihe.gazelle.hl7v3.prpamt201306UV02.PRPAMT201306UV02LivingSubjectId;
import net.ihe.gazelle.hl7v3.prpamt201306UV02.PRPAMT201306UV02LivingSubjectName;
import net.ihe.gazelle.hl7v3.prpamt201306UV02.PRPAMT201306UV02MatchCriterionList;
import net.ihe.gazelle.hl7v3.prpamt201306UV02.PRPAMT201306UV02MinimumDegreeMatch;
import net.ihe.gazelle.hl7v3.prpamt201306UV02.PRPAMT201306UV02MothersMaidenName;
import net.ihe.gazelle.hl7v3.prpamt201306UV02.PRPAMT201306UV02OtherIDsScopingOrganization;
import net.ihe.gazelle.hl7v3.prpamt201306UV02.PRPAMT201306UV02ParameterList;
import net.ihe.gazelle.hl7v3.prpamt201306UV02.PRPAMT201306UV02PatientAddress;
import net.ihe.gazelle.hl7v3.prpamt201306UV02.PRPAMT201306UV02PatientTelecom;
import net.ihe.gazelle.hl7v3.prpamt201306UV02.PRPAMT201306UV02QueryByParameter;
import net.ihe.gazelle.hl7v3.voc.ActClassControlAct;
import net.ihe.gazelle.hl7v3.voc.EntityNameSearchUse;
import net.ihe.gazelle.hl7v3.voc.XActMoodIntentEvent;
import org.hl7.fhir.r4.model.Address;
import org.projecthusky.communication.mpi.V3Message;
import org.projecthusky.communication.utils.PixPdqV3Utils;

public class V3PdqConsumerQuery
extends V3Message {
    private PRPAIN201305UV02Type rootElement;
    private PRPAIN201305UV02QUQIMT021001UV01ControlActProcess queryControlActProcessPdq = null;
    private PRPAMT201306UV02QueryByParameter queryByParameter = null;
    private PRPAMT201306UV02ParameterList parameterList = null;
    private PRPAMT201306UV02MatchCriterionList matchCriterionList = null;
    private String queryParams = "";

    public V3PdqConsumerQuery(String senderApplicationOID, String senderFacilityOID, String receiverApplicationOID, String receiverFacilityOID) {
        super(senderApplicationOID);
        this.getRootElement().setInteractionId(PixPdqV3Utils.createII("2.16.840.1.113883.1.6", "PRPA_IN201305UV02", ""));
        this.setSender(senderApplicationOID, senderFacilityOID);
        this.addReceiver(receiverApplicationOID, receiverFacilityOID);
        this.createControlActProcess();
        this.getRootElement().setControlActProcess(this.queryControlActProcessPdq);
    }

    private void createControlActProcess() {
        this.queryControlActProcessPdq = new PRPAIN201305UV02QUQIMT021001UV01ControlActProcess();
        this.queryControlActProcessPdq.setClassCode(ActClassControlAct.CACT);
        this.queryControlActProcessPdq.setMoodCode(XActMoodIntentEvent.EVN);
        this.queryControlActProcessPdq.setCode(PixPdqV3Utils.createCD("PRPA_TE201305UV02", "2.16.840.1.113883.1.18", "", ""));
        this.createQueryByParameter();
        this.queryControlActProcessPdq.setQueryByParameter(this.queryByParameter);
    }

    private void createQueryByParameter() {
        this.queryByParameter = new PRPAMT201306UV02QueryByParameter();
        this.queryByParameter.setQueryId(PixPdqV3Utils.createIIwithUniqueExtension("1.2.840.114350.1.13.28.1.18.5.999"));
        this.queryByParameter.setStatusCode(PixPdqV3Utils.createCS("new"));
        this.queryByParameter.setResponseModalityCode(PixPdqV3Utils.createCS("R"));
        this.queryByParameter.setResponsePriorityCode(PixPdqV3Utils.createCS("I"));
        this.parameterList = new PRPAMT201306UV02ParameterList();
        this.queryByParameter.setParameterList(this.parameterList);
    }

    public void addDomainToReturn(String organizationOID) {
        PRPAMT201306UV02OtherIDsScopingOrganization currentScopingOrganization = new PRPAMT201306UV02OtherIDsScopingOrganization();
        currentScopingOrganization.getValue().add(PixPdqV3Utils.createII(organizationOID, "", ""));
        currentScopingOrganization.setSemanticsText(PixPdqV3Utils.createST("OtherIDs.scopingOrganization.id"));
        this.parameterList.getOtherIDsScopingOrganization().add(currentScopingOrganization);
    }

    public void addPatientAddress(Address address) {
        this.queryParams = this.queryParams + "Patient Address: " + String.valueOf(address.getLine()) + " " + address.getCity() + " " + address.getState() + " " + address.getCountry() + " " + address.getPostalCode() + "," + String.valueOf(address.getUse()) + ",";
        AD patientAddressAD = PixPdqV3Utils.createAd(address);
        if (null != patientAddressAD) {
            PRPAMT201306UV02PatientAddress patientAddress = new PRPAMT201306UV02PatientAddress();
            patientAddress.getValue().add(patientAddressAD);
            patientAddress.setSemanticsText(PixPdqV3Utils.createST("Patient.addr"));
            this.parameterList.getPatientAddress().add(patientAddress);
        }
    }

    @Override
    public void addPatientID(String root, String extension, String namespace) {
        this.queryParams = this.queryParams + "Patient ID: " + root + "^" + extension + ",";
        PRPAMT201306UV02LivingSubjectId livingSubjectId = new PRPAMT201306UV02LivingSubjectId();
        livingSubjectId.getValue().add(PixPdqV3Utils.createII(root, extension, namespace));
        livingSubjectId.setSemanticsText(PixPdqV3Utils.createST("LivingSubject.id"));
        this.parameterList.getLivingSubjectId().add(livingSubjectId);
    }

    public void addPatientMothersMaidenName(boolean useFuzzySearch, String family, String given, String other, String suffix, String prefix) {
        PRPAMT201306UV02MothersMaidenName mothersMaidenName = new PRPAMT201306UV02MothersMaidenName();
        PN mothersMaidenNamePN = PixPdqV3Utils.createPN(family, given, other, suffix, prefix);
        if (useFuzzySearch) {
            mothersMaidenNamePN.setUse(EntityNameSearchUse.SRCH.value());
        }
        mothersMaidenName.getValue().add(mothersMaidenNamePN);
        mothersMaidenName.setSemanticsText(PixPdqV3Utils.createST("MothersMaidenName.name"));
        this.parameterList.getMothersMaidenName().add(mothersMaidenName);
    }

    public void addPatientName(boolean useFuzzySearch, String family, String given, String other, String suffix, String prefix) {
        this.queryParams = this.queryParams + "Patient Name: " + prefix + " " + given + " " + other + " " + family + " " + suffix + ",";
        PRPAMT201306UV02LivingSubjectName livingSubjectName = new PRPAMT201306UV02LivingSubjectName();
        EN livingSubjectNameEN = PixPdqV3Utils.createEN(family, given, other, suffix, prefix);
        if (useFuzzySearch) {
            livingSubjectNameEN.setUse(EntityNameSearchUse.SRCH.value());
        }
        livingSubjectName.getValue().add(livingSubjectNameEN);
        livingSubjectName.setSemanticsText(PixPdqV3Utils.createST("LivingSubject.name"));
        this.parameterList.getLivingSubjectName().add(livingSubjectName);
    }

    @Override
    public void addPatientTelecom(String telecom, String type) {
        PRPAMT201306UV02PatientTelecom patientTel = new PRPAMT201306UV02PatientTelecom();
        TEL tel = PixPdqV3Utils.createTEL(telecom, type);
        patientTel.getValue().add(tel);
        this.parameterList.getPatientTelecom().add(patientTel);
    }

    public void addReceiver(String applicationOID, String facilityOID) {
        this.getRootElement().getReceiver().add(PixPdqV3Utils.createMCCIMT000100UV01Receiver(applicationOID, facilityOID));
    }

    public PRPAIN201305UV02QUQIMT021001UV01ControlActProcess getControlActProcess() {
        return this.queryControlActProcessPdq;
    }

    public II getId() {
        return this.getRootElement().getId();
    }

    public PRPAMT201306UV02MatchCriterionList getMatchCriterionList() {
        if (this.matchCriterionList == null) {
            this.matchCriterionList = new PRPAMT201306UV02MatchCriterionList();
            this.queryByParameter.setMatchCriterionList(this.matchCriterionList);
        }
        return this.matchCriterionList;
    }

    public PRPAMT201306UV02ParameterList getParameterList() {
        return this.parameterList;
    }

    public String getQueryParams() {
        return this.queryParams;
    }

    public PRPAIN201305UV02Type getRootElement() {
        if (this.rootElement == null) {
            this.rootElement = new PRPAIN201305UV02Type();
        }
        return this.rootElement;
    }

    @Override
    protected void setAcceptAckCode() {
        this.getRootElement().setAcceptAckCode(PixPdqV3Utils.createCS(this.acceptAckCode));
    }

    @Override
    protected void setCreationTime() {
        this.getRootElement().setCreationTime(PixPdqV3Utils.createTSCurrentTime());
    }

    @Override
    protected void setId() {
        this.getRootElement().setId(this.messageId);
    }

    public void setInitialQuantity(Integer initialQuantity) {
        this.setInitialQuantity(initialQuantity, "RD");
    }

    public void setInitialQuantity(Integer initialQuantity, String units) {
        this.queryByParameter.setInitialQuantity(PixPdqV3Utils.createINT1(initialQuantity));
        this.queryByParameter.setInitialQuantityCode(PixPdqV3Utils.createCE(units));
    }

    @Override
    protected void setITSVersion() {
        this.getRootElement().setITSVersion(this.itsVersion);
    }

    public void setMinimumDegreeMatch() {
        this.setMinimumDegreeMatch(75);
    }

    public void setMinimumDegreeMatch(Integer minimumDegreeInt) {
        PRPAMT201306UV02MinimumDegreeMatch minimumDegreeMatch = new PRPAMT201306UV02MinimumDegreeMatch();
        minimumDegreeMatch.setValue((ANY)PixPdqV3Utils.createINT1(minimumDegreeInt));
        minimumDegreeMatch.setSemanticsText(PixPdqV3Utils.createST("MatchAlgorithm"));
        this.getMatchCriterionList().setMinimumDegreeMatch(minimumDegreeMatch);
    }

    public void setPatientDateOfBirth(String dob) {
        this.queryParams = this.queryParams + "DOB: " + dob + ",";
        PRPAMT201306UV02LivingSubjectBirthTime livingSubjectBirthTime = new PRPAMT201306UV02LivingSubjectBirthTime();
        livingSubjectBirthTime.getValue().add(PixPdqV3Utils.createIVLTS(dob));
        livingSubjectBirthTime.setSemanticsText(PixPdqV3Utils.createST("LivingSubject.birthTime"));
        this.parameterList.getLivingSubjectBirthTime().add(livingSubjectBirthTime);
    }

    public void setPatientSex(String sex) {
        this.queryParams = this.queryParams + "Sex: " + sex + ",";
        PRPAMT201306UV02LivingSubjectAdministrativeGender livingSubjectAdministrativeGender = new PRPAMT201306UV02LivingSubjectAdministrativeGender();
        livingSubjectAdministrativeGender.getValue().add(PixPdqV3Utils.createCE(sex));
        livingSubjectAdministrativeGender.setSemanticsText(PixPdqV3Utils.createST("LivingSubject.administrativeGender"));
        this.parameterList.getLivingSubjectAdministrativeGender().add(livingSubjectAdministrativeGender);
    }

    @Override
    protected void setProcessingCode() {
        this.getRootElement().setProcessingCode(PixPdqV3Utils.createCS(this.processingCode));
    }

    @Override
    protected void setProcessingModeCode() {
        this.getRootElement().setProcessingModeCode(PixPdqV3Utils.createCS(this.processingModeCode));
    }

    public void setQueryId(String root, String extension, String namespace) {
        this.queryByParameter.setQueryId(PixPdqV3Utils.createII(root, extension, namespace));
    }

    @Override
    public void setSender(String applicationOID, String facilityOID) {
        super.setSender(applicationOID, facilityOID);
        this.getRootElement().setSender(PixPdqV3Utils.createMCCIMT000100UV01Sender(applicationOID, facilityOID));
    }
}

