/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.mpi.impl;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.ihe.gazelle.hl7v3.datatypes.II;
import net.ihe.gazelle.hl7v3.prpamt201304UV02.PRPAMT201304UV02OtherIDs;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.hl7.fhir.r4.model.Identifier;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.hl7v3.PIXV3;
import org.openehealth.ipf.commons.ihe.hl7v3.core.metadata.Device;
import org.openehealth.ipf.commons.ihe.hl7v3.core.requests.PixV3QueryRequest;
import org.openehealth.ipf.commons.ihe.hl7v3.core.responses.PixV3QueryResponse;
import org.projecthusky.common.communication.AffinityDomain;
import org.projecthusky.communication.mpi.V3Acknowledgement;
import org.projecthusky.communication.mpi.impl.PixPdqV3QueryBase;
import org.projecthusky.communication.mpi.impl.pix.V3PixSource;
import org.projecthusky.communication.mpi.impl.pix.V3PixSourceMessageHelper;
import org.projecthusky.communication.utils.HuskyUtils;
import org.projecthusky.communication.utils.PixPdqV3Utils;
import org.projecthusky.fhir.structures.gen.FhirCommon;
import org.projecthusky.fhir.structures.gen.FhirPatient;
import org.projecthusky.xua.core.SecurityHeaderElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PixV3Query
extends PixPdqV3QueryBase {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PixV3Query.class.getName());
    private V3PixSource pixSource;

    public PixV3Query() {
    }

    public PixV3Query(AffinityDomain affinityDomain, String homeCommunityOid, CamelContext context, AuditContext auditContext) {
        super(affinityDomain, homeCommunityOid, context);
        this.pixSource = new V3PixSource(this.pixSourceUri, context, auditContext);
        this.setAuditContext(auditContext);
    }

    public PixV3Query(AffinityDomain affinityDomain, String homeCommunityOid, String homeCommunityNamespace, String domainToReturnOid, String domainToReturnNamespace, CamelContext context, AuditContext auditContext) {
        super(affinityDomain, homeCommunityOid, homeCommunityNamespace, domainToReturnOid, domainToReturnNamespace, context);
        this.pixSource = new V3PixSource(this.pixSourceUri, context, auditContext);
        this.setAuditContext(auditContext);
    }

    public List<String> queryPatientId(FhirPatient patient, List<String> queryDomainOids, List<String> queryDomainNamespaces, SecurityHeaderElement assertion, String messageId) {
        List<Object> domainToReturnOids = new LinkedList();
        if (queryDomainOids != null) {
            domainToReturnOids = queryDomainOids;
        } else if (this.domainToReturnOid != null) {
            domainToReturnOids.add(this.domainToReturnOid);
        }
        PixV3QueryRequest v3PixConsumerQueryRequest = new PixV3QueryRequest();
        Device senderDev = new Device();
        II id = new II();
        id.setRoot(this.senderApplicationOid);
        senderDev.getIds().add(id);
        v3PixConsumerQueryRequest.setSender(senderDev);
        Device receiverDev = new Device();
        II idReceiver = new II();
        idReceiver.setRoot(this.receiverApplicationOid);
        receiverDev.getIds().add(idReceiver);
        v3PixConsumerQueryRequest.setReceiver(receiverDev);
        v3PixConsumerQueryRequest.setQueryId(PixPdqV3Utils.createIIwithUniqueExtension(this.senderApplicationOid));
        v3PixConsumerQueryRequest.setMessageId(PixPdqV3Utils.createIIwithUniqueExtension(this.senderApplicationOid));
        String homeCommunityPatientId = this.getHomeCommunityPatientId(patient);
        if (homeCommunityPatientId == null) {
            LOGGER.error("homeCommunityPatientId not provided");
            return domainToReturnOids;
        }
        v3PixConsumerQueryRequest.setQueryPatientId(PixPdqV3Utils.createII(this.homeCommunityOid, homeCommunityPatientId, this.homeCommunityNamespace));
        for (String string : domainToReturnOids) {
            v3PixConsumerQueryRequest.getDataSourceOids().add(string);
        }
        PixV3QueryResponse v3PixConsumerResponse = null;
        try {
            v3PixConsumerResponse = this.sendQuery(v3PixConsumerQueryRequest, assertion, this.pixQueryUri, messageId);
            LinkedList<String> linkedList = new LinkedList<String>();
            for (String string : domainToReturnOids) {
                linkedList.add(this.getPatientDomainId(v3PixConsumerResponse, string));
            }
            return linkedList;
        }
        catch (Exception exception) {
            LOGGER.error("exception queryPatient", (Throwable)exception);
            return domainToReturnOids;
        }
    }

    public boolean addPatient(FhirPatient patient, SecurityHeaderElement assertion, String messageId) {
        if (this.pixSource == null) {
            this.pixSource = new V3PixSource(this.pixSourceUri, this.getCamelContext(), this.getAuditContext());
        }
        LOGGER.debug("creating v3RecordAddedMessage");
        boolean ret = false;
        V3PixSourceMessageHelper v3RecordAddedMessage = new V3PixSourceMessageHelper(true, false, false, this.senderApplicationOid, this.senderFacilityOid, this.receiverApplicationOid, this.receiverFacilityOid);
        LOGGER.debug("add demographic data");
        this.addDemographicData(patient, v3RecordAddedMessage);
        try {
            V3Acknowledgement v3pixack = this.pixSource.sendRecordAdded(v3RecordAddedMessage.getV3RecordAddedMessage(), assertion, messageId);
            ret = this.checkResponse(v3pixack);
        }
        catch (Exception e) {
            LOGGER.error("addPatient failed", (Throwable)e);
        }
        return ret;
    }

    public boolean mergePatient(FhirPatient patient, String obsoleteId, SecurityHeaderElement assertion, String messageId) {
        if (this.pixSource == null) {
            this.pixSource = new V3PixSource(this.pixSourceUri, this.getCamelContext(), this.getAuditContext());
        }
        boolean ret = false;
        V3PixSourceMessageHelper v3pixSourceMsgMerge = new V3PixSourceMessageHelper(false, false, true, this.senderApplicationOid, this.senderFacilityOid, this.receiverApplicationOid, this.receiverFacilityOid);
        this.addDemographicData(patient, v3pixSourceMsgMerge);
        v3pixSourceMsgMerge.getV3MergePatientsMessage().setObsoletePatientID(obsoleteId, this.homeCommunityOid, this.homeCommunityNamespace);
        try {
            V3Acknowledgement v3pixack = this.pixSource.sendMergePatients(v3pixSourceMsgMerge.getV3MergePatientsMessage(), assertion, messageId);
            ret = this.checkResponse(v3pixack);
        }
        catch (Exception e) {
            LOGGER.error("mergePatient failed", (Throwable)e);
        }
        return ret;
    }

    public boolean updatePatient(FhirPatient patient, SecurityHeaderElement assertion, String messageId) {
        if (this.pixSource == null) {
            this.pixSource = new V3PixSource(this.pixSourceUri, this.getCamelContext(), this.getAuditContext());
        }
        V3PixSourceMessageHelper v3RecordRevisedMessage = new V3PixSourceMessageHelper(false, true, false, this.senderApplicationOid, this.senderFacilityOid, this.receiverApplicationOid, this.receiverFacilityOid);
        this.addDemographicData(patient, v3RecordRevisedMessage);
        try {
            V3Acknowledgement v3pixack = this.pixSource.sendRecordRevised(v3RecordRevisedMessage.getV3RecordRevisedMessage(), assertion, messageId);
            return this.checkResponse(v3pixack);
        }
        catch (Exception e) {
            LOGGER.error("updatePatient failed", (Throwable)e);
            return false;
        }
    }

    protected boolean checkResponse(V3Acknowledgement response) {
        if (response.hasError()) {
            LOGGER.error("AcknowledgementCode: {}", (Object)response.getAcknowledgementCode());
            LOGGER.error("Query error text: {}", (Object)response.getErrorText());
            return false;
        }
        return true;
    }

    public String queryPatientId(FhirPatient patient, SecurityHeaderElement assertion, String messageId) {
        List<String> ids = this.queryPatientId(patient, null, null, assertion, messageId);
        if (ids != null && !ids.isEmpty()) {
            return ids.get(0);
        }
        return null;
    }

    protected String getHomeCommunityPatientId(FhirPatient patient) {
        for (Identifier Identifier2 : patient.getIdentifier()) {
            if (!Identifier2.getSystem().startsWith("urn:oid:") || !FhirCommon.removeUrnOidPrefix((String)Identifier2.getSystem()).equals(this.homeCommunityOid)) continue;
            return Identifier2.getValue();
        }
        return null;
    }

    public String getPatientDomainId(PixV3QueryResponse v3PixConsumerResponse, String rootOid) {
        String retVal = null;
        if (!(rootOid == null || v3PixConsumerResponse == null || v3PixConsumerResponse.getPatientIds().isEmpty() && v3PixConsumerResponse.getAsOtherIDs().isEmpty())) {
            for (int i = 0; i < v3PixConsumerResponse.getPatientIds().size(); ++i) {
                II id = (II)v3PixConsumerResponse.getPatientIds().get(i);
                if (id == null || id.getRoot() == null || !id.getRoot().equals(rootOid)) continue;
                retVal = id.getExtension();
            }
            if (retVal == null) {
                retVal = this.getIdFromOthers(v3PixConsumerResponse, rootOid);
            }
        }
        return retVal;
    }

    private String getIdFromOthers(PixV3QueryResponse v3PixConsumerResponse, String rootOid) {
        for (int i = 0; i < v3PixConsumerResponse.getAsOtherIDs().size(); ++i) {
            II id = (II)((PRPAMT201304UV02OtherIDs)v3PixConsumerResponse.getAsOtherIDs().get(i)).getId().get(0);
            if (id == null || id.getRoot() == null || !id.getRoot().equals(rootOid)) continue;
            return id.getExtension();
        }
        return null;
    }

    private PixV3QueryResponse sendQuery(PixV3QueryRequest request, SecurityHeaderElement assertion, URI pdqDest, String messageId) throws Exception {
        String endpoint = HuskyUtils.createEndpoint(PIXV3.Interactions.ITI_45.getWsTransactionConfiguration().getName(), pdqDest, true, this.getAuditContext().isAuditEnabled());
        LOGGER.info("Sending request to '{}' endpoint", (Object)endpoint);
        HashMap<String, String> outgoingHeaders = new HashMap<String, String>();
        outgoingHeaders.put("Accept", "application/soap+xml");
        outgoingHeaders.put("Content-Type", "application/soap+xml; charset=UTF-8; action=\"urn:hl7-org:v3:PRPA_IN201309UV02\"");
        Exchange exchange = this.send(endpoint, request, assertion, messageId, outgoingHeaders);
        return (PixV3QueryResponse)exchange.getMessage().getBody(PixV3QueryResponse.class);
    }
}

