/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.mpi.impl;

import java.io.Serializable;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.ihe.gazelle.hl7v3.coctmt030007UV.COCTMT030007UVPerson;
import net.ihe.gazelle.hl7v3.coctmt150003UV03.COCTMT150003UV03ContactParty;
import net.ihe.gazelle.hl7v3.datatypes.AD;
import net.ihe.gazelle.hl7v3.datatypes.AdxpCity;
import net.ihe.gazelle.hl7v3.datatypes.AdxpCountry;
import net.ihe.gazelle.hl7v3.datatypes.AdxpHouseNumber;
import net.ihe.gazelle.hl7v3.datatypes.AdxpHouseNumberNumeric;
import net.ihe.gazelle.hl7v3.datatypes.AdxpPostalCode;
import net.ihe.gazelle.hl7v3.datatypes.AdxpState;
import net.ihe.gazelle.hl7v3.datatypes.AdxpStreetAddressLine;
import net.ihe.gazelle.hl7v3.datatypes.AdxpStreetName;
import net.ihe.gazelle.hl7v3.datatypes.CE;
import net.ihe.gazelle.hl7v3.datatypes.EN;
import net.ihe.gazelle.hl7v3.datatypes.EnFamily;
import net.ihe.gazelle.hl7v3.datatypes.EnGiven;
import net.ihe.gazelle.hl7v3.datatypes.EnPrefix;
import net.ihe.gazelle.hl7v3.datatypes.EnSuffix;
import net.ihe.gazelle.hl7v3.datatypes.II;
import net.ihe.gazelle.hl7v3.datatypes.ON;
import net.ihe.gazelle.hl7v3.datatypes.PN;
import net.ihe.gazelle.hl7v3.datatypes.TEL;
import net.ihe.gazelle.hl7v3.datatypes.TS;
import net.ihe.gazelle.hl7v3.prpamt201310UV02.PRPAMT201310UV02BirthPlace;
import net.ihe.gazelle.hl7v3.prpamt201310UV02.PRPAMT201310UV02Citizen;
import net.ihe.gazelle.hl7v3.prpamt201310UV02.PRPAMT201310UV02Employee;
import net.ihe.gazelle.hl7v3.prpamt201310UV02.PRPAMT201310UV02LanguageCommunication;
import net.ihe.gazelle.hl7v3.prpamt201310UV02.PRPAMT201310UV02Nation;
import net.ihe.gazelle.hl7v3.prpamt201310UV02.PRPAMT201310UV02OtherIDs;
import net.ihe.gazelle.hl7v3.prpamt201310UV02.PRPAMT201310UV02Patient;
import net.ihe.gazelle.hl7v3.prpamt201310UV02.PRPAMT201310UV02PersonalRelationship;
import net.ihe.gazelle.hl7v3.voc.HomeAddressUse;
import net.ihe.gazelle.hl7v3.voc.WorkPlaceAddressUse;
import org.apache.camel.CamelContext;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.projecthusky.common.communication.AffinityDomain;
import org.projecthusky.common.communication.Destination;
import org.projecthusky.common.enums.TelecomAddressUse;
import org.projecthusky.communication.CamelService;
import org.projecthusky.communication.mpi.impl.pix.V3PixSourceMessageHelper;
import org.projecthusky.communication.utils.PixPdqV3Utils;
import org.projecthusky.fhir.structures.gen.FhirCommon;
import org.projecthusky.fhir.structures.gen.FhirPatient;

public class PixPdqV3QueryBase
extends CamelService {
    protected String domainToReturnNamespace;
    protected String domainToReturnOid;
    protected String homeCommunityNamespace;
    protected String homeCommunityOid;
    protected Set<String> otherOidIds;
    protected URI pdqConsumerUri;
    protected URI pixQueryUri;
    protected URI pixSourceUri;
    protected String receiverApplicationOid;
    protected String receiverFacilityOid;
    protected String senderApplicationOid;
    protected String senderFacilityOid;

    public PixPdqV3QueryBase() {
    }

    public PixPdqV3QueryBase(AffinityDomain affinityDomain, String homeCommunityOid, String homeCommunityNamespace, String domainToReturnOid, String domainToReturnNamespace, CamelContext context) {
        this(affinityDomain, homeCommunityOid, context);
        this.homeCommunityNamespace = homeCommunityNamespace;
        this.domainToReturnOid = domainToReturnOid;
        this.domainToReturnNamespace = domainToReturnNamespace;
        this.otherOidIds = affinityDomain.getOtherIdsOidSet();
        this.setCamelContext(context);
    }

    public PixPdqV3QueryBase(AffinityDomain affinityDomain, String homeCommunityOid, CamelContext context) {
        this.setAffinityDomain(affinityDomain);
        this.homeCommunityOid = homeCommunityOid;
        this.otherOidIds = affinityDomain.getOtherIdsOidSet();
        this.setCamelContext(context);
    }

    public void setAffinityDomain(AffinityDomain affinityDomain) {
        Destination pixQuery = affinityDomain.getPixDestination();
        Destination pdqQuery = affinityDomain.getPdqDestination();
        this.pixQueryUri = pixQuery != null ? pixQuery.getUri() : null;
        this.pixSourceUri = pixQuery != null ? pixQuery.getUri() : null;
        this.pdqConsumerUri = pdqQuery != null ? pdqQuery.getUri() : null;
        this.senderApplicationOid = pixQuery != null ? pixQuery.getSenderApplicationOid() : null;
        this.senderFacilityOid = pixQuery != null ? pixQuery.getSenderFacilityOid() : null;
        this.receiverApplicationOid = pixQuery != null ? pixQuery.getReceiverApplicationOid() : null;
        this.receiverFacilityOid = pixQuery != null ? pixQuery.getReceiverFacilityOid() : null;
    }

    protected void addDemographicData(FhirPatient patient, V3PixSourceMessageHelper v3PixSourceMessage) {
        if (v3PixSourceMessage == null) {
            return;
        }
        this.setScopingOrganization(patient, v3PixSourceMessage);
        this.addPatientIds(patient, v3PixSourceMessage);
        this.addPatientName(patient, v3PixSourceMessage);
        this.setPatientBirthTime(patient, v3PixSourceMessage);
        this.setPatientGender(patient, v3PixSourceMessage);
        this.addPatientAddresses(patient, v3PixSourceMessage);
        this.addPatientTelecoms(patient, v3PixSourceMessage);
        this.addLanguageCommunications(patient, v3PixSourceMessage);
        this.setPatientMaritalStatus(patient, v3PixSourceMessage);
        this.setDeceased(patient, v3PixSourceMessage);
        this.setMultipeBirth(patient, v3PixSourceMessage);
        this.setPatientMothersMaidenName(patient, v3PixSourceMessage);
        this.setBirthPlace(patient, v3PixSourceMessage);
        this.setPatientReligiousAffiliation(patient, v3PixSourceMessage);
        this.setNation(patient, v3PixSourceMessage);
        this.setEmployee(patient, v3PixSourceMessage);
    }

    protected void addDemographicData(PRPAMT201310UV02Patient pdqPatient, FhirPatient patient) {
        if (pdqPatient == null) {
            return;
        }
        this.setScopingOrganization(pdqPatient, patient);
        this.addPatientIds(pdqPatient, patient);
        this.addPatientName(pdqPatient, patient);
        this.setPatientBirthTime(pdqPatient, patient);
        this.setPatientGender(pdqPatient, patient);
        this.addPatientAddresses(pdqPatient, patient);
        this.addPatientTelecoms(pdqPatient, patient);
        this.addLanguageCommunications(pdqPatient, patient);
        this.setPatientMaritalStatus(pdqPatient, patient);
        this.setDeceased(pdqPatient, patient);
        this.setMultipeBirth(pdqPatient, patient);
        this.setPatientMothersMaidenName(pdqPatient, patient);
        this.setBirthPlace(pdqPatient, patient);
        this.setPatientReligiousAffiliation(pdqPatient, patient);
        this.setNation(pdqPatient, patient);
        this.setEmployee(pdqPatient, patient);
    }

    protected void addLanguageCommunications(FhirPatient patient, V3PixSourceMessageHelper v3PixSourceMessage) {
        if (!patient.getCommunication().isEmpty()) {
            for (Patient.PatientCommunicationComponent communication : patient.getCommunication()) {
                v3PixSourceMessage.addLanguageCommunication(communication.getLanguage().getText());
            }
        }
    }

    protected void addLanguageCommunications(PRPAMT201310UV02Patient pdqPatient, FhirPatient patient) {
        if (pdqPatient.getPatientPerson() != null && pdqPatient.getPatientPerson().getLanguageCommunication() != null) {
            for (PRPAMT201310UV02LanguageCommunication languageCommunication : pdqPatient.getPatientPerson().getLanguageCommunication()) {
                if (languageCommunication.getLanguageCode() == null || languageCommunication.getLanguageCode().getCode() == null) continue;
                Patient.PatientCommunicationComponent communication = new Patient.PatientCommunicationComponent();
                CodeableConcept language = new CodeableConcept();
                language.setText(languageCommunication.getLanguageCode().getCode());
                communication.setLanguage(language);
                patient.getCommunication().add(communication);
            }
        }
    }

    protected void addPatientAddresses(FhirPatient patient, V3PixSourceMessageHelper v3PixSourceMessage) {
        if (!patient.getAddress().isEmpty()) {
            for (Address address : patient.getAddress()) {
                v3PixSourceMessage.addPatientAddress(this.getPatientAddress(address));
            }
        }
    }

    protected AD getPatientAddress(Address address) {
        return PixPdqV3Utils.createAd(address);
    }

    protected void addPatientAddresses(PRPAMT201310UV02Patient pdqPatient, FhirPatient patient) {
        if (pdqPatient.getPatientPerson() != null && pdqPatient.getPatientPerson().getAddr() != null) {
            for (AD ad : pdqPatient.getPatientPerson().getAddr()) {
                patient.getAddress().add(this.getAddressFromAD(ad));
            }
        }
    }

    protected void addPatientIds(FhirPatient patient, V3PixSourceMessageHelper v3PixSourceMessage) {
        for (Identifier identifier : patient.getIdentifier()) {
            if (identifier.getSystem().length() <= 8) continue;
            String oid = FhirCommon.removeUrnOidPrefix((String)identifier.getSystem());
            if (this.otherOidIds.contains(oid)) {
                v3PixSourceMessage.addPatientOtherID(identifier.getValue(), oid);
                continue;
            }
            if (this.homeCommunityOid != null && this.homeCommunityOid.equals(oid)) {
                v3PixSourceMessage.addPatientID(identifier.getValue(), this.homeCommunityOid, this.homeCommunityNamespace);
                continue;
            }
            v3PixSourceMessage.addPatientID(identifier.getValue(), oid, "");
        }
    }

    protected void addPatientIds(PRPAMT201310UV02Patient pdqPatient, FhirPatient patient) {
        if (pdqPatient.getId() != null) {
            for (II patientId : pdqPatient.getId()) {
                Identifier identifier = new Identifier();
                identifier.setSystem(FhirCommon.addUrnOid((String)patientId.getRoot()));
                identifier.setValue(patientId.getExtension());
                patient.getIdentifier().add(identifier);
            }
        }
        if (pdqPatient.getPatientPerson() != null && pdqPatient.getPatientPerson().getAsOtherIDs() != null) {
            for (PRPAMT201310UV02OtherIDs asOtherId : pdqPatient.getPatientPerson().getAsOtherIDs()) {
                II patientId;
                if (asOtherId.getId() == null || asOtherId.getId().isEmpty() || (patientId = (II)asOtherId.getId().get(0)) == null) continue;
                Identifier identifier = new Identifier();
                identifier.setSystem(FhirCommon.addUrnOid((String)patientId.getRoot()));
                identifier.setValue(patientId.getExtension());
                patient.getIdentifier().add(identifier);
            }
        }
    }

    protected void addPatientName(FhirPatient patient, V3PixSourceMessageHelper v3PixSourceMessage) {
        String familyName = ((HumanName)patient.getName().get(0)).getFamily();
        String givenName = ((HumanName)patient.getName().get(0)).getGivenAsSingleString();
        String otherName = "";
        String prefixName = ((HumanName)patient.getName().get(0)).getPrefixAsSingleString();
        String suffixName = ((HumanName)patient.getName().get(0)).getSuffixAsSingleString();
        v3PixSourceMessage.addPatientName(familyName, givenName, "", prefixName, suffixName);
    }

    protected void addPatientName(PRPAMT201310UV02Patient pdqPatient, FhirPatient patient) {
        List pns = pdqPatient.getPatientPerson().getName();
        for (int i = 0; i < pns.size(); ++i) {
            PN pn = (PN)pns.get(i);
            patient.getName().add(this.createHumanName((EN)pn));
        }
    }

    private HumanName createHumanName(EN en) {
        HumanName humanNameType = new HumanName();
        if (en.getGiven() != null) {
            for (EnGiven given : en.getGiven()) {
                humanNameType.addGiven(this.getMixedValue(given.getMixed()));
            }
        }
        if (en.getFamily() != null) {
            for (EnFamily family : en.getFamily()) {
                humanNameType.setFamily(this.getMixedValue(family.getMixed()));
            }
        }
        if (en.getPrefix() != null) {
            for (EnPrefix prefix : en.getPrefix()) {
                humanNameType.addPrefix(this.getMixedValue(prefix.getMixed()));
            }
        }
        if (en.getSuffix() != null) {
            for (EnSuffix suffix : en.getSuffix()) {
                humanNameType.addPrefix(this.getMixedValue(suffix.getMixed()));
            }
        }
        return humanNameType;
    }

    protected void addPatientTelecoms(FhirPatient patient, V3PixSourceMessageHelper v3PixSourceMessage) {
        if (patient.getTelecom() != null && !patient.getTelecom().isEmpty()) {
            for (ContactPoint contactPoint : patient.getTelecom()) {
                v3PixSourceMessage.addPatientTelecom(this.getTelecomValue(contactPoint), this.getTelecomAddressUse(contactPoint));
            }
        }
    }

    private String getTelecomValue(ContactPoint contactPoint) {
        String system = "";
        String value = "NULL";
        if (contactPoint.getSystem() != null) {
            system = contactPoint.getSystem().toString().toLowerCase();
        }
        if (contactPoint.getValue() != null) {
            value = contactPoint.getValue();
        }
        if ("phone".equals(system)) {
            return "tel:" + value;
        }
        if ("email".equals(system)) {
            return "mailto:" + value;
        }
        return value;
    }

    private String getTelecomAddressUse(ContactPoint contactPoint) {
        String use = "";
        if (contactPoint.getUse() != null) {
            use = contactPoint.getUse().toString().toLowerCase();
        }
        if ("home".equals(use)) {
            return TelecomAddressUse.PRIVATE.getCodeValue();
        }
        if ("work".equals(use)) {
            return TelecomAddressUse.BUSINESS.getCodeValue();
        }
        return null;
    }

    private ContactPoint.ContactPointUse getContactPointUse(String use) {
        if (use.contains(WorkPlaceAddressUse.WP.value())) {
            return ContactPoint.ContactPointUse.WORK;
        }
        if (use.contains(HomeAddressUse.H.value()) || use.contains(HomeAddressUse.HP.value())) {
            return ContactPoint.ContactPointUse.HOME;
        }
        if (!use.isEmpty() && "MC".equals(use)) {
            return ContactPoint.ContactPointUse.MOBILE;
        }
        return null;
    }

    protected void addPatientTelecoms(PRPAMT201310UV02Patient pdqPatient, FhirPatient patient) {
        if (pdqPatient.getPatientPerson() != null && pdqPatient.getPatientPerson().getTelecom() != null && !pdqPatient.getPatientPerson().getTelecom().isEmpty()) {
            for (TEL tel : pdqPatient.getPatientPerson().getTelecom()) {
                ContactPoint contactPoint = new ContactPoint();
                if (tel.getValue() != null && tel.getValue().startsWith("tel:")) {
                    contactPoint.setValue(tel.getValue().substring(4));
                    contactPoint.setSystem(ContactPoint.ContactPointSystem.PHONE);
                    contactPoint.setUse(this.getContactPointUse(tel.getUse()));
                    patient.getTelecom().add(contactPoint);
                }
                if (tel.getValue() == null || !tel.getValue().startsWith("mailto:")) continue;
                contactPoint.setValue(tel.getValue().substring(7));
                contactPoint.setSystem(ContactPoint.ContactPointSystem.EMAIL);
                contactPoint.setUse(this.getContactPointUse(tel.getUse()));
                patient.getTelecom().add(contactPoint);
            }
        }
    }

    protected void setScopingOrganization(FhirPatient patient, V3PixSourceMessageHelper v3PixSourceMessage) {
        String organizationOid = "";
        String organizationName = "";
        String organizationTelecomValue = "NOTPROVIDED";
        Organization organization = (Organization)patient.getManagingOrganization().getResource();
        if (organization != null) {
            ContactPoint contactPoint;
            Identifier organizationId;
            if (organization.getIdentifier() != null && !organization.getIdentifier().isEmpty() && (organizationId = (Identifier)organization.getIdentifier().get(0)).getSystem().startsWith("urn:oid:")) {
                organizationOid = FhirCommon.removeUrnOidPrefix((String)organizationId.getSystem());
            }
            if (organization.getName() != null) {
                organizationName = organization.getName();
            }
            if (organization.getTelecom() != null && !organization.getTelecom().isEmpty() && (contactPoint = organization.getTelecomFirstRep()) != null) {
                organizationTelecomValue = contactPoint.getValue();
            }
        }
        v3PixSourceMessage.setScopingOrganization(organizationOid, organizationName, organizationTelecomValue);
    }

    protected void setScopingOrganization(PRPAMT201310UV02Patient pdqPatient, FhirPatient patient) {
        if (pdqPatient.getProviderOrganization() != null) {
            List ons;
            Organization organization = new Organization();
            patient.getManagingOrganization().setResource((IBaseResource)organization);
            if (pdqPatient.getProviderOrganization().getId() != null && !pdqPatient.getProviderOrganization().getId().isEmpty()) {
                for (II id : pdqPatient.getProviderOrganization().getId()) {
                    if (id == null || id.getRoot() == null) continue;
                    Identifier identifier = new Identifier();
                    identifier.setValue(FhirCommon.addUrnOid((String)id.getRoot()));
                    organization.getIdentifier().add(identifier);
                }
            }
            if ((ons = pdqPatient.getProviderOrganization().getName()) != null && !ons.isEmpty()) {
                organization.setName(this.getMixedValue(((ON)ons.get(0)).getMixed()));
            }
            organization.getTelecom().addAll(this.getContactPointsFromContactParties(pdqPatient.getProviderOrganization().getContactParty()));
        }
    }

    private List<ContactPoint> getContactPointsFromContactParties(List<COCTMT150003UV03ContactParty> contactParties) {
        TEL tel;
        List tels;
        LinkedList<ContactPoint> telecoms = new LinkedList<ContactPoint>();
        if (contactParties != null && !contactParties.isEmpty() && (tels = contactParties.get(0).getTelecom()) != null && !tels.isEmpty() && (tel = (TEL)tels.get(0)).getValue() != null && tel.getValue().startsWith("tel:")) {
            ContactPoint contactPoint = new ContactPoint();
            contactPoint.setValue(tel.getValue().substring(4));
            contactPoint.setSystem(ContactPoint.ContactPointSystem.PHONE);
            telecoms.add(contactPoint);
        }
        return telecoms;
    }

    protected void setBirthPlace(FhirPatient patient, V3PixSourceMessageHelper v3PixSourceMessage) {
        if (patient.getBirthPlace() != null) {
            AD patientAddress = PixPdqV3Utils.createAd(patient.getBirthPlace());
            v3PixSourceMessage.setPatientBirthPlace(patientAddress);
        }
    }

    protected void setBirthPlace(PRPAMT201310UV02Patient pdqPatient, FhirPatient patient) {
        PRPAMT201310UV02BirthPlace birthplace;
        AD addr;
        if (pdqPatient.getPatientPerson() != null && pdqPatient.getPatientPerson().getBirthPlace() != null && (addr = (birthplace = pdqPatient.getPatientPerson().getBirthPlace()).getAddr()) != null) {
            patient.setBirthPlace(this.getAddressFromAD(addr));
        }
    }

    protected void setDeceased(FhirPatient patient, V3PixSourceMessageHelper v3PixSourceMessage) {
        DateTimeType deceased;
        Type idDeceased = patient.getDeceased();
        if (idDeceased instanceof DateTimeType && (deceased = (DateTimeType)idDeceased).getValue() != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            v3PixSourceMessage.setPatientDeceasedTime(dateFormat.format((Date)deceased.getValue()));
            v3PixSourceMessage.setPatientDeceased(true);
        }
        if (idDeceased instanceof BooleanType && (deceased = (BooleanType)idDeceased).getValue() != null) {
            v3PixSourceMessage.setPatientDeceased((Boolean)deceased.getValue());
        }
    }

    protected void setDeceased(PRPAMT201310UV02Patient pdqPatient, FhirPatient patient) {
        if (pdqPatient.getPatientPerson() != null) {
            if (pdqPatient.getPatientPerson().getDeceasedInd() != null && pdqPatient.getPatientPerson().getDeceasedInd().value != null && pdqPatient.getPatientPerson().getDeceasedInd().value.booleanValue()) {
                BooleanType dt = new BooleanType();
                dt.setValue((Object)pdqPatient.getPatientPerson().getDeceasedInd().value);
                patient.setDeceased((Type)dt);
            }
            if (pdqPatient.getPatientPerson().getDeceasedTime() != null) {
                patient.setDeceased((Type)DateTimeType.parseV3((String)pdqPatient.getPatientPerson().getDeceasedTime().getValue()));
            }
        }
    }

    protected void setEmployee(FhirPatient patient, V3PixSourceMessageHelper v3PixSourceMessage) {
        if (patient.getEmployeeOccupation() != null && !patient.getEmployeeOccupation().isEmpty()) {
            v3PixSourceMessage.addEmployeeCode(patient.getEmployeeOccupation().getText());
        }
    }

    protected void setEmployee(PRPAMT201310UV02Patient pdqPatient, FhirPatient patient) {
        PRPAMT201310UV02Employee employee;
        List employees;
        if (pdqPatient != null && pdqPatient.getPatientPerson() != null && pdqPatient.getPatientPerson().getAsEmployee() != null && !(employees = pdqPatient.getPatientPerson().getAsEmployee()).isEmpty() && (employee = (PRPAMT201310UV02Employee)employees.get(0)).getOccupationCode() != null && employee.getOccupationCode().getCode() != null) {
            CodeableConcept employeeOccupationCode = new CodeableConcept();
            employeeOccupationCode.setText(employee.getOccupationCode().getCode());
            patient.setEmployeeOccupation(employeeOccupationCode);
        }
    }

    protected void setMultipeBirth(FhirPatient patient, V3PixSourceMessageHelper v3PixSourceMessage) {
        IntegerType multipleBirth;
        Type iMultipleBirth = patient.getMultipleBirth();
        if (iMultipleBirth instanceof IntegerType && (multipleBirth = (IntegerType)iMultipleBirth).getValue() != null) {
            v3PixSourceMessage.setPatientMultipleBirthOrderNumber((Integer)multipleBirth.getValue());
            v3PixSourceMessage.setPatientMultipleBirthIndicator(true);
        }
        if (iMultipleBirth instanceof BooleanType && (multipleBirth = (BooleanType)iMultipleBirth).getValue() != null) {
            v3PixSourceMessage.setPatientMultipleBirthIndicator((Boolean)multipleBirth.getValue());
        }
    }

    protected void setMultipeBirth(PRPAMT201310UV02Patient pdqPatient, FhirPatient patient) {
        if (pdqPatient.getPatientPerson() != null) {
            if (pdqPatient.getPatientPerson().getMultipleBirthInd() != null && pdqPatient.getPatientPerson().getMultipleBirthInd().value != null && pdqPatient.getPatientPerson().getMultipleBirthInd().value.booleanValue()) {
                BooleanType dt = new BooleanType();
                dt.setValue((Object)pdqPatient.getPatientPerson().getMultipleBirthInd().value);
                patient.setMultipleBirth((Type)dt);
            }
            if (pdqPatient.getPatientPerson().getMultipleBirthOrderNumber() != null) {
                Integer birthOrderNumber = pdqPatient.getPatientPerson().getMultipleBirthOrderNumber().getValue();
                patient.setMultipleBirth((Type)new IntegerType(birthOrderNumber.intValue()));
            }
        }
    }

    protected void setNation(FhirPatient patient, V3PixSourceMessageHelper v3PixSourceMessage) {
        if (patient.getNation() != null && !patient.getNation().isEmpty()) {
            v3PixSourceMessage.addPatientNation(patient.getNation().getText());
        }
    }

    protected void setNation(PRPAMT201310UV02Patient pdqPatient, FhirPatient patient) {
        PRPAMT201310UV02Nation nation;
        List citizens;
        if (pdqPatient.getPatientPerson() != null && pdqPatient.getPatientPerson().getAsCitizen() != null && !(citizens = pdqPatient.getPatientPerson().getAsCitizen()).isEmpty() && (nation = ((PRPAMT201310UV02Citizen)citizens.get(0)).getPoliticalNation()) != null && nation.getCode() != null && nation.getCode().getCode() != null) {
            CodeableConcept nationCode = new CodeableConcept();
            nationCode.setText(nation.getCode().getCode());
            patient.setNation(nationCode);
        }
    }

    protected void setPatientBirthTime(FhirPatient patient, V3PixSourceMessageHelper v3PixSourceMessage) {
        v3PixSourceMessage.setPatientBirthTime(patient.getBirthDateElement().getValueAsString().replace("-", ""));
    }

    protected void setPatientBirthTime(PRPAMT201310UV02Patient pdqPatient, FhirPatient patient) {
        TS ts;
        String date;
        if (pdqPatient.getPatientPerson() != null && pdqPatient.getPatientPerson().getBirthTime() != null && (date = (ts = pdqPatient.getPatientPerson().getBirthTime()).getValue()) != null && date.length() >= 4) {
            Object dateFhir = date.substring(0, 4);
            if (date.length() >= 6) {
                dateFhir = (String)dateFhir + "-" + date.substring(4, 6);
            }
            if (date.length() >= 8) {
                dateFhir = (String)dateFhir + "-" + date.substring(6, 8);
            }
            patient.getBirthDateElement().setValueAsString((String)dateFhir);
        }
    }

    protected void setPatientGender(FhirPatient patient, V3PixSourceMessageHelper v3PixSourceMessage) {
        if (patient.getGender() != null) {
            String gender = "";
            gender = patient.getGender() == Enumerations.AdministrativeGender.MALE ? "M" : (patient.getGender() == Enumerations.AdministrativeGender.FEMALE ? "F" : "U");
            v3PixSourceMessage.setPatientGender(gender);
        }
    }

    protected void setPatientGender(PRPAMT201310UV02Patient pdqPatient, FhirPatient patient) {
        if (pdqPatient.getPatientPerson() != null && pdqPatient.getPatientPerson().getAdministrativeGenderCode() != null) {
            CE gender = pdqPatient.getPatientPerson().getAdministrativeGenderCode();
            if ("M".equals(gender.getCode())) {
                patient.setGender(Enumerations.AdministrativeGender.MALE);
            } else if ("F".equals(gender.getCode())) {
                patient.setGender(Enumerations.AdministrativeGender.FEMALE);
            } else if ("U".equals(gender.getCode())) {
                patient.setGender(Enumerations.AdministrativeGender.OTHER);
            }
        }
    }

    protected void setPatientMaritalStatus(FhirPatient patient, V3PixSourceMessageHelper v3PixSourceMessage) {
        if (!patient.getMaritalStatus().isEmpty()) {
            v3PixSourceMessage.setPatientMaritalStatus(patient.getMaritalStatus().getCodingFirstRep().getCode());
        }
    }

    protected void setPatientMaritalStatus(PRPAMT201310UV02Patient pdqPatient, FhirPatient patient) {
        CE maritalStatusCode;
        if (pdqPatient.getPatientPerson() != null && pdqPatient.getPatientPerson().getMaritalStatusCode() != null && (maritalStatusCode = pdqPatient.getPatientPerson().getMaritalStatusCode()).getCode() != null) {
            CodeableConcept maritalStatus = new CodeableConcept();
            maritalStatus.setText(maritalStatusCode.getCode());
            patient.setMaritalStatus(maritalStatus);
        }
    }

    protected void setPatientMothersMaidenName(FhirPatient patient, V3PixSourceMessageHelper v3PixSourceMessage) {
        HumanName maidenName = patient.getMothersMaidenName();
        if (maidenName != null && maidenName.getFamily() != null) {
            String familyName = maidenName.getFamily();
            String givenName = maidenName.getGivenAsSingleString();
            String otherName = "";
            String prefixName = maidenName.getPrefixAsSingleString();
            String suffixName = maidenName.getSuffixAsSingleString();
            v3PixSourceMessage.setPatientMothersMaidenName(familyName, givenName, "", suffixName, prefixName);
        }
    }

    protected void setPatientMothersMaidenName(PRPAMT201310UV02Patient pdqPatient, FhirPatient patient) {
        if (pdqPatient.getPatientPerson() != null && pdqPatient.getPatientPerson().getPersonalRelationship() != null) {
            for (PRPAMT201310UV02PersonalRelationship personalRelationship : pdqPatient.getPatientPerson().getPersonalRelationship()) {
                if (personalRelationship.getCode() == null || !"MTH".equals(personalRelationship.getCode().getCode()) || !"2.16.840.1.113883.5.111".equals(personalRelationship.getCode().getCodeSystem())) continue;
                patient.setMothersMaidenName(this.getMothersMaidenName(personalRelationship));
            }
        }
    }

    private HumanName getMothersMaidenName(PRPAMT201310UV02PersonalRelationship personalRelationship) {
        List names;
        COCTMT030007UVPerson motherRelationShipHolder = personalRelationship.getRelationshipHolder1();
        if (motherRelationShipHolder != null && motherRelationShipHolder.getName() != null && (names = motherRelationShipHolder.getName()) != null && !names.isEmpty()) {
            return this.createHumanName((EN)names.get(0));
        }
        return null;
    }

    protected void setPatientReligiousAffiliation(FhirPatient patient, V3PixSourceMessageHelper v3PixSourceMessage) {
        if (patient.getReligiousAffiliation() != null && !patient.getReligiousAffiliation().isEmpty()) {
            v3PixSourceMessage.setPatientReligiousAffiliation(patient.getReligiousAffiliation().getText());
        }
    }

    protected void setPatientReligiousAffiliation(PRPAMT201310UV02Patient pdqPatient, FhirPatient patient) {
        CE religiousAffiliation;
        if (pdqPatient.getPatientPerson() != null && pdqPatient.getPatientPerson().getReligiousAffiliationCode() != null && (religiousAffiliation = pdqPatient.getPatientPerson().getReligiousAffiliationCode()).getCode() != null) {
            CodeableConcept religion = new CodeableConcept();
            religion.setText(religiousAffiliation.getCode());
            patient.setReligiousAffiliation(religion);
        }
    }

    protected Address getAddressFromAD(AD ad) {
        Address address = new Address();
        if (ad.getUse() != null) {
            address.setUse(this.getAddressUse(ad.getUse()));
        }
        if (ad.getStreetAddressLine() != null && !ad.getStreetAddressLine().isEmpty()) {
            for (AdxpStreetAddressLine addressStreetLine : ad.getStreetAddressLine()) {
                address.addLine(this.getMixedValue(addressStreetLine.getMixed()));
            }
        }
        if (ad.getStreetName() != null && !ad.getStreetName().isEmpty() && ad.getStreetName().get(0) != null) {
            Extension streetNameExt = new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName", (IBaseDatatype)new StringType(this.getMixedValue(((AdxpStreetName)ad.getStreetName().get(0)).getMixed())));
            address.addExtension(streetNameExt);
        }
        if (ad.getHouseNumberNumeric() != null && !ad.getHouseNumberNumeric().isEmpty() && ad.getHouseNumberNumeric().get(0) != null) {
            houseNumberExt = new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber", (IBaseDatatype)new StringType(this.getMixedValue(((AdxpHouseNumberNumeric)ad.getHouseNumberNumeric().get(0)).getMixed())));
            address.addExtension(houseNumberExt);
        } else if (ad.getHouseNumber() != null && !ad.getHouseNumber().isEmpty() && ad.getHouseNumber().get(0) != null) {
            houseNumberExt = new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber", (IBaseDatatype)new StringType(this.getMixedValue(((AdxpHouseNumber)ad.getHouseNumber().get(0)).getMixed())));
            address.addExtension(houseNumberExt);
        }
        if (ad.getCity() != null && !ad.getCity().isEmpty()) {
            address.setCity(this.getMixedValue(((AdxpCity)ad.getCity().get(0)).getMixed()));
        }
        if (ad.getState() != null && !ad.getState().isEmpty()) {
            address.setState(this.getMixedValue(((AdxpState)ad.getState().get(0)).getMixed()));
        }
        if (ad.getPostalCode() != null && !ad.getPostalCode().isEmpty()) {
            address.setPostalCode(this.getMixedValue(((AdxpPostalCode)ad.getPostalCode().get(0)).getMixed()));
        }
        if (ad.getCountry() != null && !ad.getCountry().isEmpty()) {
            address.setCountry(this.getMixedValue(((AdxpCountry)ad.getCountry().get(0)).getMixed()));
        }
        return address;
    }

    private Address.AddressUse getAddressUse(String use) {
        if ("H".equals(use)) {
            return Address.AddressUse.HOME;
        }
        if ("WP".equals(use)) {
            return Address.AddressUse.WORK;
        }
        if ("TMP".equals(use)) {
            return Address.AddressUse.TEMP;
        }
        if ("OLD".equals(use)) {
            return Address.AddressUse.OLD;
        }
        return null;
    }

    protected String getMixedValue(List<Serializable> mixed) {
        Serializable serializable;
        String returnValue = "";
        if (!mixed.isEmpty() && (serializable = mixed.get(0)) instanceof String) {
            String mixedStr;
            returnValue = mixedStr = (String)((Object)serializable);
        }
        return returnValue;
    }
}

