/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.mpi.impl;

import java.util.List;
import net.ihe.gazelle.hl7v3.datatypes.CS;
import net.ihe.gazelle.hl7v3.prpamt201301UV02.PRPAMT201301UV02Patient;
import net.ihe.gazelle.hl7v3.prpamt201302UV02.PRPAMT201302UV02Patient;
import net.ihe.gazelle.hl7v3.prpamt201302UV02.PRPAMT201302UV02PatientId;
import net.ihe.gazelle.hl7v3.prpamt201302UV02.PRPAMT201302UV02PatientStatusCode;
import net.ihe.gazelle.hl7v3.prpamt201303UV02.PRPAMT201303UV02Patient;
import org.projecthusky.communication.utils.PixPdqV3Utils;

public class PixPdqSubjectPatient {
    private Object internalObj;
    private String patientId = "";

    public PixPdqSubjectPatient(Object obj) {
        this.internalObj = obj;
        String classCode = "PAT";
        CS activeCode = PixPdqV3Utils.createCS("active");
        if (obj instanceof PRPAMT201301UV02Patient) {
            this.getPRPAMT201301UV02Patient().setClassCode(classCode);
            this.getPRPAMT201301UV02Patient().setStatusCode(activeCode);
        } else if (obj instanceof PRPAMT201302UV02Patient) {
            this.getPRPAMT201302UV02Patient().setClassCode(classCode);
            PRPAMT201302UV02PatientStatusCode statusCode = new PRPAMT201302UV02PatientStatusCode();
            statusCode.setCode("active");
            this.getPRPAMT201302UV02Patient().setStatusCode(statusCode);
        } else if (obj instanceof PRPAMT201303UV02Patient) {
            this.getPRPAMT201303UV02Patient().setClassCode(classCode);
            this.getPRPAMT201303UV02Patient().setStatusCode(activeCode);
        }
    }

    public void addPatientConfidentialityCode(String code) {
        if (this.internalObj instanceof PRPAMT201301UV02Patient) {
            this.getPRPAMT201301UV02Patient().getConfidentialityCode().add(PixPdqV3Utils.createCE(code));
        } else if (this.internalObj instanceof PRPAMT201302UV02Patient) {
            this.getPRPAMT201302UV02Patient().getConfidentialityCode().add(PixPdqV3Utils.createCE(code));
        } else if (this.internalObj instanceof PRPAMT201303UV02Patient) {
            this.getPRPAMT201303UV02Patient().getConfidentialityCode().add(PixPdqV3Utils.createCE(code));
        }
    }

    public void addPatientID(String extension, String root, String namespace) {
        StringBuilder idString = new StringBuilder();
        idString.append(extension).append("^^^");
        if (namespace != null) {
            idString.append(namespace);
        }
        idString.append("&").append(root).append("&ISO");
        this.patientId = idString.toString();
        if (this.internalObj instanceof PRPAMT201301UV02Patient) {
            this.getPRPAMT201301UV02Patient().getId().add(PixPdqV3Utils.createII(root, extension, namespace));
        } else if (this.internalObj instanceof PRPAMT201302UV02Patient) {
            PRPAMT201302UV02PatientId prpamPatientId = new PRPAMT201302UV02PatientId();
            if (null != root && !root.isEmpty()) {
                prpamPatientId.setRoot(root);
            }
            if (null != extension && !extension.isEmpty()) {
                prpamPatientId.setExtension(extension);
            }
            if (null != namespace && !namespace.isEmpty()) {
                prpamPatientId.setAssigningAuthorityName(namespace);
            }
            this.getPRPAMT201302UV02Patient().getId().add(prpamPatientId);
        } else if (this.internalObj instanceof PRPAMT201303UV02Patient) {
            this.getPRPAMT201303UV02Patient().getId().add(PixPdqV3Utils.createII(root, extension, namespace));
        }
    }

    public void setPatientVeryImportantPerson(String code) {
        if (this.internalObj instanceof PRPAMT201301UV02Patient) {
            this.getPRPAMT201301UV02Patient().setVeryImportantPersonCode(PixPdqV3Utils.createCE(code));
        } else if (this.internalObj instanceof PRPAMT201302UV02Patient) {
            this.getPRPAMT201302UV02Patient().setVeryImportantPersonCode(PixPdqV3Utils.createCE(code));
        } else if (this.internalObj instanceof PRPAMT201303UV02Patient) {
            this.getPRPAMT201303UV02Patient().setVeryImportantPersonCode(PixPdqV3Utils.createCE(code));
        }
    }

    @Deprecated
    public void setProviderOrganization(String organizationOID, String organizationName, String telecomValue) {
        this.setProviderOrganization(List.of(organizationOID), organizationName, telecomValue);
    }

    public void setProviderOrganization(List<String> organizationOIDs, String organizationName, String telecomValue) {
        if (this.internalObj instanceof PRPAMT201301UV02Patient) {
            this.getPRPAMT201301UV02Patient().setProviderOrganization(PixPdqV3Utils.createCOCTMT150003UV03Organization(organizationOIDs, organizationName, telecomValue));
        } else if (this.internalObj instanceof PRPAMT201302UV02Patient) {
            this.getPRPAMT201302UV02Patient().setProviderOrganization(PixPdqV3Utils.createCOCTMT150003UV03Organization(organizationOIDs, organizationName, telecomValue));
        } else if (this.internalObj instanceof PRPAMT201303UV02Patient) {
            this.getPRPAMT201303UV02Patient().setProviderOrganization(PixPdqV3Utils.createCOCTMT150003UV03Organization(organizationOIDs, organizationName, telecomValue));
        }
    }

    public String getPatientId() {
        return this.patientId;
    }

    public PRPAMT201301UV02Patient getPRPAMT201301UV02Patient() {
        return (PRPAMT201301UV02Patient)this.internalObj;
    }

    public PRPAMT201302UV02Patient getPRPAMT201302UV02Patient() {
        return (PRPAMT201302UV02Patient)this.internalObj;
    }

    public PRPAMT201303UV02Patient getPRPAMT201303UV02Patient() {
        return (PRPAMT201303UV02Patient)this.internalObj;
    }
}

