/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.mpi.impl;

import net.ihe.gazelle.hl7v3.coctmt030007UV.COCTMT030007UVPerson;
import net.ihe.gazelle.hl7v3.datatypes.AD;
import net.ihe.gazelle.hl7v3.datatypes.CE;
import net.ihe.gazelle.hl7v3.datatypes.PN;
import net.ihe.gazelle.hl7v3.prpamt201301UV02.PRPAMT201301UV02OtherIDs;
import net.ihe.gazelle.hl7v3.prpamt201301UV02.PRPAMT201301UV02Person;
import net.ihe.gazelle.hl7v3.prpamt201301UV02.PRPAMT201301UV02PersonalRelationship;
import net.ihe.gazelle.hl7v3.prpamt201302UV02.PRPAMT201302UV02OtherIDs;
import net.ihe.gazelle.hl7v3.prpamt201302UV02.PRPAMT201302UV02OtherIDsId;
import net.ihe.gazelle.hl7v3.prpamt201302UV02.PRPAMT201302UV02PatientPatientPerson;
import net.ihe.gazelle.hl7v3.prpamt201302UV02.PRPAMT201302UV02PersonalRelationship;
import net.ihe.gazelle.hl7v3.prpamt201303UV02.PRPAMT201303UV02OtherIDs;
import net.ihe.gazelle.hl7v3.prpamt201303UV02.PRPAMT201303UV02Person;
import net.ihe.gazelle.hl7v3.prpamt201303UV02.PRPAMT201303UV02PersonalRelationship;
import net.ihe.gazelle.hl7v3.voc.EntityClass;
import net.ihe.gazelle.hl7v3.voc.EntityDeterminer;
import net.ihe.gazelle.hl7v3.voc.XDeterminerInstanceKind;
import org.projecthusky.communication.utils.PixPdqV3Utils;

public class PixPdqPerson {
    private static final String OID_GENDER = "2.16.840.1.113883.5.1";
    private Object internalObj;

    public PixPdqPerson(Object obj) {
        this.internalObj = obj;
        if (obj instanceof PRPAMT201303UV02Person) {
            this.getPRPAMT201303UV02Person().setClassCode(EntityClass.PSN);
            this.getPRPAMT201303UV02Person().setDeterminerCode(EntityDeterminer.INSTANCE);
        } else if (obj instanceof PRPAMT201302UV02PatientPatientPerson) {
            this.getPRPAMT201302UV02PatientPatientPerson().setClassCode(EntityClass.PSN);
            this.getPRPAMT201302UV02PatientPatientPerson().setDeterminerCode(EntityDeterminer.INSTANCE);
        } else if (obj instanceof PRPAMT201301UV02Person) {
            this.getPRPAMT201301UV02Person().setClassCode(EntityClass.PSN);
            this.getPRPAMT201301UV02Person().setDeterminerCode(EntityDeterminer.INSTANCE);
        }
    }

    public void addPatientAddress(AD patientAddress) {
        if (patientAddress == null) {
            return;
        }
        if (this.internalObj instanceof PRPAMT201303UV02Person) {
            this.getPRPAMT201303UV02Person().getAddr().add(patientAddress);
        } else if (this.internalObj instanceof PRPAMT201302UV02PatientPatientPerson) {
            this.getPRPAMT201302UV02PatientPatientPerson().getAddr().add(patientAddress);
        } else if (this.internalObj instanceof PRPAMT201301UV02Person) {
            this.getPRPAMT201301UV02Person().getAddr().add(patientAddress);
        }
    }

    public void addPatientEthnicGroupCode(String code) {
        if (this.internalObj instanceof PRPAMT201303UV02Person) {
            this.getPRPAMT201303UV02Person().getEthnicGroupCode().add(PixPdqV3Utils.createCE(code));
        } else if (this.internalObj instanceof PRPAMT201302UV02PatientPatientPerson) {
            this.getPRPAMT201302UV02PatientPatientPerson().getEthnicGroupCode().add(PixPdqV3Utils.createCE(code));
        } else if (this.internalObj instanceof PRPAMT201301UV02Person) {
            this.getPRPAMT201301UV02Person().getEthnicGroupCode().add(PixPdqV3Utils.createCE(code));
        }
    }

    public void addPatientName(String familyName, String givenName, String other, String prefixName, String suffixName) {
        PN patientName = PixPdqV3Utils.createPN(familyName, givenName, other, suffixName, prefixName);
        if (this.internalObj instanceof PRPAMT201303UV02Person) {
            this.getPRPAMT201303UV02Person().getName().add(patientName);
        } else if (this.internalObj instanceof PRPAMT201302UV02PatientPatientPerson) {
            this.getPRPAMT201302UV02PatientPatientPerson().getName().add(patientName);
        } else if (this.internalObj instanceof PRPAMT201301UV02Person) {
            this.getPRPAMT201301UV02Person().getName().add(patientName);
        }
    }

    public void addPatientOtherID(String extension, String root) {
        if (this.internalObj instanceof PRPAMT201303UV02Person) {
            PRPAMT201303UV02OtherIDs asOtherID = new PRPAMT201303UV02OtherIDs();
            asOtherID.setClassCode("PAT");
            asOtherID.getId().add(PixPdqV3Utils.createII(root, extension, ""));
            asOtherID.setScopingOrganization(PixPdqV3Utils.createCOCTMT150002UV01Organization(root));
            this.getPRPAMT201303UV02Person().getAsOtherIDs().add(asOtherID);
        } else if (this.internalObj instanceof PRPAMT201302UV02PatientPatientPerson) {
            PRPAMT201302UV02OtherIDs asOtherID = new PRPAMT201302UV02OtherIDs();
            asOtherID.setClassCode("PAT");
            PRPAMT201302UV02OtherIDsId otherId = new PRPAMT201302UV02OtherIDsId();
            if (null != root && !root.isEmpty()) {
                otherId.setRoot(root);
            }
            if (null != extension && !extension.isEmpty()) {
                otherId.setExtension(extension);
            }
            asOtherID.getId().add(otherId);
            asOtherID.setScopingOrganization(PixPdqV3Utils.createCOCTMT150002UV01Organization(root));
            this.getPRPAMT201302UV02PatientPatientPerson().getAsOtherIDs().add(asOtherID);
        } else if (this.internalObj instanceof PRPAMT201301UV02Person) {
            PRPAMT201301UV02OtherIDs asOtherID = new PRPAMT201301UV02OtherIDs();
            asOtherID.setClassCode("PAT");
            asOtherID.getId().add(PixPdqV3Utils.createII(root, extension, ""));
            asOtherID.setScopingOrganization(PixPdqV3Utils.createCOCTMT150002UV01Organization(root));
            this.getPRPAMT201301UV02Person().getAsOtherIDs().add(asOtherID);
        }
    }

    public void addPatientRaceCode(String code) {
        if (this.internalObj instanceof PRPAMT201303UV02Person) {
            this.getPRPAMT201303UV02Person().getRaceCode().add(PixPdqV3Utils.createCE(code));
        } else if (this.internalObj instanceof PRPAMT201302UV02PatientPatientPerson) {
            this.getPRPAMT201302UV02PatientPatientPerson().getRaceCode().add(PixPdqV3Utils.createCE(code));
        } else if (this.internalObj instanceof PRPAMT201301UV02Person) {
            this.getPRPAMT201301UV02Person().getRaceCode().add(PixPdqV3Utils.createCE(code));
        }
    }

    public void addPatientTelecom(String telecomValue, String useValue) {
        if (this.internalObj instanceof PRPAMT201303UV02Person) {
            this.getPRPAMT201303UV02Person().getTelecom().add(PixPdqV3Utils.createTEL(telecomValue, useValue));
        } else if (this.internalObj instanceof PRPAMT201302UV02PatientPatientPerson) {
            this.getPRPAMT201302UV02PatientPatientPerson().getTelecom().add(PixPdqV3Utils.createTEL(telecomValue, useValue));
        } else if (this.internalObj instanceof PRPAMT201301UV02Person) {
            this.getPRPAMT201301UV02Person().getTelecom().add(PixPdqV3Utils.createTEL(telecomValue, useValue));
        }
    }

    public void setMultipleBirthIndicator(boolean birthIndicator) {
        if (this.internalObj instanceof PRPAMT201303UV02Person) {
            this.getPRPAMT201303UV02Person().setMultipleBirthInd(PixPdqV3Utils.createBL(birthIndicator));
        } else if (this.internalObj instanceof PRPAMT201302UV02PatientPatientPerson) {
            this.getPRPAMT201302UV02PatientPatientPerson().setMultipleBirthInd(PixPdqV3Utils.createBL(birthIndicator));
        } else if (this.internalObj instanceof PRPAMT201301UV02Person) {
            this.getPRPAMT201301UV02Person().setMultipleBirthInd(PixPdqV3Utils.createBL(birthIndicator));
        }
    }

    public void setMultipleBirthOrderNumber(int birthNumber) {
        if (this.internalObj instanceof PRPAMT201303UV02Person) {
            this.getPRPAMT201303UV02Person().setMultipleBirthOrderNumber(PixPdqV3Utils.createINT1(birthNumber));
        } else if (this.internalObj instanceof PRPAMT201302UV02PatientPatientPerson) {
            this.getPRPAMT201302UV02PatientPatientPerson().setMultipleBirthOrderNumber(PixPdqV3Utils.createINT1(birthNumber));
        } else if (this.internalObj instanceof PRPAMT201301UV02Person) {
            this.getPRPAMT201301UV02Person().setMultipleBirthOrderNumber(PixPdqV3Utils.createINT1(birthNumber));
        }
    }

    public void setPatientBirthTime(String birthTime) {
        if (this.internalObj instanceof PRPAMT201303UV02Person) {
            this.getPRPAMT201303UV02Person().setBirthTime(PixPdqV3Utils.createTS(birthTime));
        } else if (this.internalObj instanceof PRPAMT201302UV02PatientPatientPerson) {
            this.getPRPAMT201302UV02PatientPatientPerson().setBirthTime(PixPdqV3Utils.createTS(birthTime));
        } else if (this.internalObj instanceof PRPAMT201301UV02Person) {
            this.getPRPAMT201301UV02Person().setBirthTime(PixPdqV3Utils.createTS(birthTime));
        }
    }

    public void setPatientDeceased(boolean patientDeceased) {
        if (this.internalObj instanceof PRPAMT201303UV02Person) {
            this.getPRPAMT201303UV02Person().setDeceasedInd(PixPdqV3Utils.createBL(patientDeceased));
        } else if (this.internalObj instanceof PRPAMT201302UV02PatientPatientPerson) {
            this.getPRPAMT201302UV02PatientPatientPerson().setDeceasedInd(PixPdqV3Utils.createBL(patientDeceased));
        } else if (this.internalObj instanceof PRPAMT201301UV02Person) {
            this.getPRPAMT201301UV02Person().setDeceasedInd(PixPdqV3Utils.createBL(patientDeceased));
        }
    }

    public void setPatientDeceasedTime(String patientDeceasedTime) {
        if (this.internalObj instanceof PRPAMT201303UV02Person) {
            this.getPRPAMT201303UV02Person().setDeceasedTime(PixPdqV3Utils.createTS(patientDeceasedTime));
        } else if (this.internalObj instanceof PRPAMT201302UV02PatientPatientPerson) {
            this.getPRPAMT201302UV02PatientPatientPerson().setDeceasedTime(PixPdqV3Utils.createTS(patientDeceasedTime));
        } else if (this.internalObj instanceof PRPAMT201301UV02Person) {
            this.getPRPAMT201301UV02Person().setDeceasedTime(PixPdqV3Utils.createTS(patientDeceasedTime));
        }
    }

    public void setPatientGender(String gender) {
        if (this.internalObj instanceof PRPAMT201303UV02Person) {
            this.getPRPAMT201303UV02Person().setAdministrativeGenderCode(PixPdqV3Utils.createCE(gender, OID_GENDER, "", ""));
        } else if (this.internalObj instanceof PRPAMT201302UV02PatientPatientPerson) {
            this.getPRPAMT201302UV02PatientPatientPerson().setAdministrativeGenderCode(PixPdqV3Utils.createCE(gender, OID_GENDER, "", ""));
        } else if (this.internalObj instanceof PRPAMT201301UV02Person) {
            this.getPRPAMT201301UV02Person().setAdministrativeGenderCode(PixPdqV3Utils.createCE(gender, OID_GENDER, "", ""));
        }
    }

    public void setPatientMaritalStatus(String maritalStatus) {
        if (this.internalObj instanceof PRPAMT201303UV02Person) {
            this.getPRPAMT201303UV02Person().setMaritalStatusCode(PixPdqV3Utils.createCE(maritalStatus));
        } else if (this.internalObj instanceof PRPAMT201302UV02PatientPatientPerson) {
            this.getPRPAMT201302UV02PatientPatientPerson().setMaritalStatusCode(PixPdqV3Utils.createCE(maritalStatus));
        } else if (this.internalObj instanceof PRPAMT201301UV02Person) {
            this.getPRPAMT201301UV02Person().setMaritalStatusCode(PixPdqV3Utils.createCE(maritalStatus));
        }
    }

    public void setPatientMothersMaidenName(String family, String given, String other, String suffix, String prefix) {
        String classCode = "PRS";
        CE mthCe = PixPdqV3Utils.createCE("MTH", "2.16.840.1.113883.5.111", "PersonalRelationshipRoleType", "Mother");
        COCTMT030007UVPerson motherRelHolder = this.getMotherRelationshipHolder(family, given, other, suffix, prefix);
        if (this.internalObj instanceof PRPAMT201303UV02Person) {
            PRPAMT201303UV02PersonalRelationship motherRelationship = new PRPAMT201303UV02PersonalRelationship();
            motherRelationship.setClassCode(classCode);
            motherRelationship.setCode(mthCe);
            motherRelationship.setRelationshipHolder1(motherRelHolder);
            this.getPRPAMT201303UV02Person().getPersonalRelationship().add(motherRelationship);
        } else if (this.internalObj instanceof PRPAMT201302UV02PatientPatientPerson) {
            PRPAMT201302UV02PersonalRelationship motherRelationship = new PRPAMT201302UV02PersonalRelationship();
            motherRelationship.setClassCode(classCode);
            motherRelationship.setCode(mthCe);
            motherRelationship.setRelationshipHolder1(motherRelHolder);
            this.getPRPAMT201302UV02PatientPatientPerson().getPersonalRelationship().add(motherRelationship);
        } else if (this.internalObj instanceof PRPAMT201301UV02Person) {
            PRPAMT201301UV02PersonalRelationship motherRelationship = new PRPAMT201301UV02PersonalRelationship();
            motherRelationship.setClassCode(classCode);
            motherRelationship.setCode(mthCe);
            motherRelationship.setRelationshipHolder1(motherRelHolder);
            this.getPRPAMT201301UV02Person().getPersonalRelationship().add(motherRelationship);
        }
    }

    public void setPatientReligiousAffiliation(String religiousAffiliation) {
        if (this.internalObj instanceof PRPAMT201303UV02Person) {
            this.getPRPAMT201303UV02Person().setReligiousAffiliationCode(PixPdqV3Utils.createCE(religiousAffiliation));
        } else if (this.internalObj instanceof PRPAMT201302UV02PatientPatientPerson) {
            this.getPRPAMT201302UV02PatientPatientPerson().setReligiousAffiliationCode(PixPdqV3Utils.createCE(religiousAffiliation));
        } else if (this.internalObj instanceof PRPAMT201301UV02Person) {
            this.getPRPAMT201301UV02Person().setReligiousAffiliationCode(PixPdqV3Utils.createCE(religiousAffiliation));
        }
    }

    public COCTMT030007UVPerson getMotherRelationshipHolder(String family, String given, String other, String suffix, String prefix) {
        COCTMT030007UVPerson motherRelationshipHolder = new COCTMT030007UVPerson();
        motherRelationshipHolder.setClassCode(EntityClass.PSN);
        motherRelationshipHolder.setDeterminerCode(XDeterminerInstanceKind.INSTANCE);
        motherRelationshipHolder.getName().add(PixPdqV3Utils.createPN(family, given, other, suffix, prefix));
        return motherRelationshipHolder;
    }

    public PRPAMT201303UV02Person getPRPAMT201303UV02Person() {
        return (PRPAMT201303UV02Person)this.internalObj;
    }

    public PRPAMT201302UV02PatientPatientPerson getPRPAMT201302UV02PatientPatientPerson() {
        return (PRPAMT201302UV02PatientPatientPerson)this.internalObj;
    }

    public PRPAMT201301UV02Person getPRPAMT201301UV02Person() {
        return (PRPAMT201301UV02Person)this.internalObj;
    }
}

