/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.mpi.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.ihe.gazelle.hl7v3.datatypes.INT;
import net.ihe.gazelle.hl7v3.prpain201306UV02.PRPAIN201306UV02MFMIMT700711UV01Subject1;
import net.ihe.gazelle.hl7v3.prpain201306UV02.PRPAIN201306UV02Type;
import net.ihe.gazelle.hl7v3.prpamt201310UV02.PRPAMT201310UV02Patient;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.hl7v3.PDQV3;
import org.projecthusky.common.communication.AffinityDomain;
import org.projecthusky.common.utils.xml.XmlMarshaller;
import org.projecthusky.common.utils.xml.XmlUnmarshaller;
import org.projecthusky.communication.mpi.impl.PixPdqV3QueryBase;
import org.projecthusky.communication.mpi.impl.pdq.V3PdqConsumerQuery;
import org.projecthusky.communication.mpi.impl.pdq.V3PdqConsumerResponse;
import org.projecthusky.communication.mpi.impl.pdq.V3PdqContinuationBase;
import org.projecthusky.communication.mpi.impl.pdq.V3PdqContinuationCancel;
import org.projecthusky.communication.mpi.impl.pdq.V3PdqContinuationQuery;
import org.projecthusky.communication.mpi.impl.pdq.V3PdqQuery;
import org.projecthusky.communication.mpi.impl.pdq.V3PdqQueryResponse;
import org.projecthusky.communication.utils.HuskyUtils;
import org.projecthusky.fhir.structures.gen.FhirPatient;
import org.projecthusky.xua.core.SecurityHeaderElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PdqV3Query
extends PixPdqV3QueryBase {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PdqV3Query.class.getName());

    public PdqV3Query() {
    }

    public PdqV3Query(AffinityDomain affinityDomain, String homeCommunityOid, CamelContext context, AuditContext auditContext) {
        super(affinityDomain, homeCommunityOid, context);
        this.setAuditContext(auditContext);
    }

    public PdqV3Query(AffinityDomain affinityDomain, String homeCommunityOid, String homeCommunityNameSpace, CamelContext context, AuditContext auditContext) {
        super(affinityDomain, homeCommunityOid, homeCommunityNameSpace, null, null, context);
        this.setAuditContext(auditContext);
    }

    public V3PdqQueryResponse queryPatients(V3PdqQuery mpiQuery, SecurityHeaderElement assertion, String messageId) {
        V3PdqQueryResponse queryResponse = new V3PdqQueryResponse();
        try {
            if (!mpiQuery.doCancelQuery()) {
                PRPAIN201306UV02Type lastPdqConsumerResponse = null;
                if (!mpiQuery.doContinueQuery()) {
                    lastPdqConsumerResponse = this.sendITI47Query(mpiQuery.getV3PdqConsumerQuery(), assertion, this.pdqConsumerUri, messageId);
                } else {
                    V3PdqContinuationQuery continuationQuery = new V3PdqContinuationQuery(mpiQuery.getV3PdqConsumerQuery().getSendingApplication(), mpiQuery.getV3PdqConsumerQuery().getSendingFacility(), mpiQuery.getV3PdqConsumerQuery().getReceivingApplication(0), mpiQuery.getV3PdqConsumerQuery().getReceivingFacility(0), mpiQuery.getLastPdqConsumerResponse(), mpiQuery.getPageCount());
                    continuationQuery.setProcessingCode("T");
                    lastPdqConsumerResponse = this.sendITI47ContinuationQuery(continuationQuery, assertion, this.pdqConsumerUri, messageId);
                }
                V3PdqConsumerResponse response = new V3PdqConsumerResponse(lastPdqConsumerResponse);
                queryResponse.setPatients(this.getPatientsFromPdqQuery(response));
                queryResponse.setSuccess(!response.hasError());
                queryResponse.setCurrentNumbers(response.getNumRecordsCurrent());
                queryResponse.setRemainingNumbers(response.getNumRecordsRemaining());
                if (response.getAcknowledgementDetailCode() != null) {
                    queryResponse.setInfoCodes(List.of(response.getAcknowledgementDetailCode()));
                }
                if (response.getAcknowledgementDetailText() != null) {
                    queryResponse.setInfoTexts(List.of(response.getAcknowledgementDetailText()));
                }
                queryResponse.setErrorText(response.getErrorText());
                INT totalNumbers = response.getPdqResponse().getControlActProcess().getQueryAck().getResultTotalQuantity();
                if (totalNumbers != null) {
                    queryResponse.setTotalNumbers(totalNumbers.getValue());
                }
                mpiQuery.setLastPdqConsumerResponse(response);
            } else {
                V3PdqConsumerResponse lastPdqConsumerResponse = mpiQuery.getLastPdqConsumerResponse();
                V3PdqContinuationCancel continuationCancel = new V3PdqContinuationCancel(mpiQuery.getV3PdqConsumerQuery().getSendingApplication(), mpiQuery.getV3PdqConsumerQuery().getSendingFacility(), mpiQuery.getV3PdqConsumerQuery().getReceivingApplication(0), mpiQuery.getV3PdqConsumerQuery().getReceivingFacility(0), lastPdqConsumerResponse);
                PRPAIN201306UV02Type response = this.sendITI47ContinuationQuery(continuationCancel, assertion, this.pdqConsumerUri, messageId);
                lastPdqConsumerResponse = new V3PdqConsumerResponse(response);
                queryResponse.setSuccess(!lastPdqConsumerResponse.hasError());
            }
        }
        catch (Exception e) {
            LOGGER.error("queryPatient failed", (Throwable)e);
            queryResponse.setSuccess(false);
            return queryResponse;
        }
        return queryResponse;
    }

    public List<FhirPatient> getPatientsFromPdqQuery(V3PdqConsumerResponse response) {
        boolean success = false;
        if (response != null) {
            boolean bl = success = !response.hasError();
            if (success) {
                ArrayList<FhirPatient> listFhirPatients = new ArrayList<FhirPatient>(response.getNumRecordsCurrent());
                for (int i = 0; i < response.getNumRecordsCurrent(); ++i) {
                    FhirPatient fhirPatient = new FhirPatient();
                    this.addDemographicData(this.getPatientByIndex(response, i), fhirPatient);
                    listFhirPatients.add(fhirPatient);
                }
                return listFhirPatients;
            }
        }
        return new LinkedList<FhirPatient>();
    }

    protected PRPAMT201310UV02Patient getPatientByIndex(V3PdqConsumerResponse v3PdqConsumerResponse, int patientIndex) {
        return ((PRPAIN201306UV02MFMIMT700711UV01Subject1)v3PdqConsumerResponse.getPdqResponse().getControlActProcess().getSubject().get(patientIndex)).getRegistrationEvent().getSubject1().getPatient();
    }

    private PRPAIN201306UV02Type sendITI47Query(V3PdqConsumerQuery request, SecurityHeaderElement assertion, URI pdqDest, String messageId) throws Exception {
        String endpoint = HuskyUtils.createEndpoint(PDQV3.Interactions.ITI_47.getWsTransactionConfiguration().getName(), pdqDest, true, this.getAuditContext().isAuditEnabled());
        LOGGER.info("Sending request to '{}' endpoint", (Object)endpoint);
        String message = XmlMarshaller.marshall((Object)request.getRootElement());
        HashMap<String, String> outgoingHeaders = new HashMap<String, String>();
        outgoingHeaders.put("Accept", "application/soap+xml");
        outgoingHeaders.put("Content-Type", "application/soap+xml; charset=UTF-8; action=\"urn:hl7-org:v3:PRPA_IN201305UV02\"");
        Exchange exchange = this.send(endpoint, message, assertion, messageId, outgoingHeaders);
        String xml = (String)exchange.getMessage().getBody(String.class);
        return (PRPAIN201306UV02Type)XmlUnmarshaller.unmarshallStringAsType((String)xml, PRPAIN201306UV02Type.class);
    }

    private PRPAIN201306UV02Type sendITI47ContinuationQuery(V3PdqContinuationBase request, SecurityHeaderElement assertion, URI pdqDest, String messageId) throws Exception {
        Object endpoint = HuskyUtils.createEndpoint(PDQV3.Interactions.ITI_47.getWsTransactionConfiguration().getName(), pdqDest, true, this.getAuditContext().isAuditEnabled());
        endpoint = (String)endpoint + "&defaultContinuationThreshold=50&supportContinuation=true";
        LOGGER.info("Sending request to '{}' endpoint", endpoint);
        String message = XmlMarshaller.marshall((Object)request.getRootElement());
        HashMap<String, String> outgoingHeaders = new HashMap<String, String>();
        outgoingHeaders.put("Accept", "application/soap+xml");
        outgoingHeaders.put("Content-Type", "application/soap+xml; charset=UTF-8; action=\"urn:hl7-org:v3:QUQI_IN000003UV01\"");
        Exchange exchange = this.send((String)endpoint, message, assertion, messageId, outgoingHeaders);
        String xml = (String)exchange.getMessage().getBody(String.class);
        return (PRPAIN201306UV02Type)XmlUnmarshaller.unmarshallStringAsType((String)xml, PRPAIN201306UV02Type.class);
    }
}

