/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.mpi;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.ihe.gazelle.hl7v3.datatypes.II;

public abstract class V3Response {
    protected String acknowledgementCode = null;
    protected String acknowledgementDetailCode = null;
    protected String acknowledgementDetailText = null;
    protected String errorText = "";
    protected List<String> infoText = new LinkedList<String>();
    protected List<String> infoCodes = new LinkedList<String>();
    protected boolean hasError = false;
    protected String sendingApplication = null;
    protected String sendingFacility = null;
    protected ArrayList<String> receivingApplication = new ArrayList(0);
    protected ArrayList<String> receivingFacility = new ArrayList(0);
    protected II messageId;

    protected V3Response() {
    }

    public String getAcknowledgementCode() {
        return this.acknowledgementCode;
    }

    public String getAcknowledgementDetailCode() {
        return this.acknowledgementDetailCode;
    }

    public String getAcknowledgementDetailText() {
        return this.acknowledgementDetailText;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public List<String> getInfoText() {
        return this.infoText;
    }

    public List<String> getInfoCodes() {
        return this.infoCodes;
    }

    public II getMessageId() {
        return this.messageId;
    }

    public boolean hasError() {
        return this.hasError;
    }

    protected void setAcknowledgementCode(String ackCode) {
        this.acknowledgementCode = ackCode;
        this.hasError = true;
        if (this.acknowledgementCode.equalsIgnoreCase("AA")) {
            this.hasError = false;
        } else if (this.acknowledgementCode.equalsIgnoreCase("CA")) {
            this.hasError = false;
        } else {
            this.errorText = this.acknowledgementCode.equalsIgnoreCase("AE") ? "Acknowledgement: AE (Application Acknowledgement Error)" : (this.acknowledgementCode.equalsIgnoreCase("AR") ? "Acknowledgement: AR (Application Acknowledgement Reject)" : (this.acknowledgementCode.equalsIgnoreCase("CE") ? "Acknowledgement: CE (Accept Acknowledgement Commit Error)" : (this.acknowledgementCode.equalsIgnoreCase("CR") ? "Acknowledgement: CR (Accept Acknowledgement Commit Reject)" : "Acknowledgement: " + this.acknowledgementCode + " (Unknown Application Acknowledgement)")));
        }
    }

    protected void setAcknowledgementDetail(String ackDetailCode, String ackDetailText, List<String> infoCodes, List<String> infoTexts) {
        this.acknowledgementDetailCode = ackDetailCode;
        this.acknowledgementDetailText = ackDetailText;
        if (null != ackDetailCode) {
            this.errorText = this.errorText + " - Code: " + ackDetailCode;
        }
        if (null != ackDetailText) {
            this.errorText = this.errorText + " (" + ackDetailText + ")";
        }
        if (infoCodes != null) {
            this.infoCodes = infoCodes;
        }
        if (infoTexts != null) {
            this.infoText = infoTexts;
        }
    }
}

