/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.mpi;

import java.util.ArrayList;
import net.ihe.gazelle.hl7v3.datatypes.AD;
import net.ihe.gazelle.hl7v3.datatypes.II;
import org.projecthusky.communication.mpi.impl.PixPdqQueryControlActProcess;
import org.projecthusky.communication.utils.PixPdqV3Utils;

public abstract class V3Message {
    protected String itsVersion = "XML_1.0";
    protected String processingCode = "P";
    protected String processingModeCode = "T";
    protected String acceptAckCode = "AL";
    protected String sendingApplication = null;
    protected String sendingFacility = null;
    private ArrayList<String> receivingApplication = new ArrayList(0);
    private ArrayList<String> receivingFacility = new ArrayList(0);
    protected II messageId;
    protected PixPdqQueryControlActProcess queryControlActProcess;

    protected V3Message(String senderApplicationOID) {
        this.messageId = PixPdqV3Utils.createII(senderApplicationOID, "", "");
        this.setITSVersion();
        this.setId();
        this.setCreationTime();
        this.setProcessingCode();
        this.setProcessingModeCode();
        this.setAcceptAckCode();
    }

    protected V3Message() {
    }

    public void addReceivingApplication(String applicationOID) {
        this.receivingApplication.add(applicationOID);
    }

    public void addReceivingFacility(String facilityOID) {
        this.receivingFacility.add(facilityOID);
    }

    public String getReceivingApplication(int i) {
        String returnValue = null;
        if (this.receivingApplication.size() > i) {
            returnValue = this.receivingApplication.get(i);
        }
        return returnValue;
    }

    public String getReceivingFacility(int i) {
        String returnValue = null;
        if (this.receivingFacility.size() > i) {
            returnValue = this.receivingFacility.get(i);
        }
        return returnValue;
    }

    public String getSendingApplication() {
        return this.sendingApplication;
    }

    public String getSendingFacility() {
        return this.sendingFacility;
    }

    public II getMessageId() {
        return this.messageId;
    }

    public void setMessageId(II messageId) {
        this.messageId = messageId;
    }

    public void setSender(String applicationOID, String facilityOID) {
        this.sendingApplication = applicationOID;
        this.sendingFacility = facilityOID;
    }

    protected abstract void setITSVersion();

    protected abstract void setId();

    protected abstract void setCreationTime();

    protected abstract void setProcessingCode();

    protected abstract void setProcessingModeCode();

    protected abstract void setAcceptAckCode();

    protected void addControlActProcess() {
    }

    public void addPatientAddress(AD patientAddress) {
        if (patientAddress == null) {
            return;
        }
        this.queryControlActProcess.addPatientAddress(patientAddress);
        this.addControlActProcess();
    }

    public void addPatientEthnicGroupCode(String code) {
        this.queryControlActProcess.addPatientEthnicGroupCode(code);
        this.addControlActProcess();
    }

    public void addPatientName(String familyName, String givenName, String other, String prefixName, String suffixName) {
        this.queryControlActProcess.addPatientName(familyName, givenName, other, prefixName, suffixName);
        this.addControlActProcess();
    }

    public void addPatientOtherID(String extension, String root) {
        this.queryControlActProcess.addPatientOtherID(extension, root);
        this.addControlActProcess();
    }

    public void addPatientRaceCode(String code) {
        this.queryControlActProcess.addPatientRaceCode(code);
        this.addControlActProcess();
    }

    public void addPatientTelecom(String telecomValue, String useValue) {
        this.queryControlActProcess.addPatientTelecom(telecomValue, useValue);
        this.addControlActProcess();
    }

    public void setMultipleBirthIndicator(boolean birthIndicator) {
        this.queryControlActProcess.setMultipleBirthIndicator(birthIndicator);
        this.addControlActProcess();
    }

    public void setMultipleBirthOrderNumber(int birthNumber) {
        this.queryControlActProcess.setMultipleBirthOrderNumber(birthNumber);
        this.addControlActProcess();
    }

    public void setPatientBirthTime(String birthTime) {
        this.queryControlActProcess.setPatientBirthTime(birthTime);
        this.addControlActProcess();
    }

    public void setPatientDeceased(boolean patientDeceased) {
        this.queryControlActProcess.setPatientDeceased(patientDeceased);
        this.addControlActProcess();
    }

    public void setPatientDeceasedTime(String patientDeceasedTime) {
        this.queryControlActProcess.setPatientDeceasedTime(patientDeceasedTime);
        this.addControlActProcess();
    }

    public void setPatientGender(String gender) {
        this.queryControlActProcess.setPatientGender(gender);
        this.addControlActProcess();
    }

    public void setPatientMaritalStatus(String maritalStatus) {
        this.queryControlActProcess.setPatientMaritalStatus(maritalStatus);
        this.addControlActProcess();
    }

    public void setPatientMothersMaidenName(String family, String given, String other, String suffix, String prefix) {
        this.queryControlActProcess.setPatientMothersMaidenName(family, given, other, suffix, prefix);
        this.addControlActProcess();
    }

    public void setPatientReligiousAffiliation(String religiousAffiliation) {
        this.queryControlActProcess.setPatientReligiousAffiliation(religiousAffiliation);
        this.addControlActProcess();
    }

    public void addPatientConfidentialityCode(String code) {
        this.queryControlActProcess.addPatientConfidentialityCode(code);
        this.addControlActProcess();
    }

    public void addPatientID(String extension, String root, String namespace) {
        this.queryControlActProcess.addPatientID(extension, root, namespace);
        this.addControlActProcess();
    }

    public void setPatientVeryImportantPerson(String code) {
        this.queryControlActProcess.setPatientVeryImportantPerson(code);
        this.addControlActProcess();
    }

    public void setProviderOrganization(String organizationOID, String organizationName, String telecomValue) {
        this.queryControlActProcess.setProviderOrganization(organizationOID, organizationName, telecomValue);
        this.addControlActProcess();
    }

    public void setScopingOrganization(String organizationOID, String organizationName, String telecomValue) {
        this.queryControlActProcess.setScopingOrganization(organizationOID, organizationName, telecomValue);
        this.addControlActProcess();
    }
}

