/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.atna;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.AuditMetadataProvider;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocol;
import org.openehealth.ipf.commons.audit.protocol.RFC5425Protocol;
import org.openehealth.ipf.commons.audit.protocol.TLSSyslogSenderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpSyslogSender
extends RFC5425Protocol
implements AuditTransmissionProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(TcpSyslogSender.class);
    private static final int MIN_SO_TIMEOUT = 1;
    private static final Boolean DEFAULT_SOCKET_KEEPALIVE = Boolean.TRUE;
    private final AtomicReference<Socket> socket = new AtomicReference();
    private final SocketFactory socketFactory;
    private final TLSSyslogSenderImpl.SocketTestPolicy socketTestPolicy;

    public TcpSyslogSender() {
        this(TLSSyslogSenderImpl.SocketTestPolicy.TEST_BEFORE_WRITE);
    }

    public TcpSyslogSender(TLSSyslogSenderImpl.SocketTestPolicy socketTestPolicy) {
        this(SocketFactory.getDefault(), socketTestPolicy);
    }

    public TcpSyslogSender(SocketFactory socketFactory) {
        this(socketFactory, TLSSyslogSenderImpl.SocketTestPolicy.TEST_BEFORE_WRITE);
    }

    public TcpSyslogSender(SocketFactory socketFactory, TLSSyslogSenderImpl.SocketTestPolicy socketTestPolicy) {
        this.socketFactory = Objects.requireNonNull(socketFactory);
        this.socketTestPolicy = Objects.requireNonNull(socketTestPolicy);
    }

    public String getTransportName() {
        return "TCP";
    }

    private Socket getSocket(AuditContext auditContext) {
        if (this.socket.get() == null) {
            this.socket.compareAndSet(null, this.createSocket(auditContext));
        }
        return this.socket.get();
    }

    public void send(AuditContext auditContext, AuditMetadataProvider auditMetadataProvider, String auditMessage) throws Exception {
        if (auditMessage != null) {
            byte[] msgBytes = this.getTransportPayload(auditMetadataProvider, auditMessage);
            LOG.debug("Auditing {} bytes to {}:{}", new Object[]{msgBytes.length, auditContext.getAuditRepositoryHostName(), auditContext.getAuditRepositoryPort()});
            try {
                this.doSend(auditContext, msgBytes);
                if (LOG.isTraceEnabled()) {
                    LOG.trace(new String(msgBytes, StandardCharsets.UTF_8));
                }
            }
            catch (SocketException | SocketTimeoutException e) {
                try {
                    LOG.info("Failed to use existing socket. Will create a new connection and retry.");
                    this.closeSocket(this.socket.get());
                    this.socket.set(null);
                    this.doSend(auditContext, msgBytes);
                }
                catch (Exception exception) {
                    LOG.error("Failed to audit using new socket, giving up - this audit message will be lost.");
                    this.closeSocket(this.socket.get());
                    this.socket.set(null);
                    throw exception;
                }
            }
        }
    }

    public void shutdown() {
        if (this.socket.get() != null) {
            this.closeSocket(this.socket.get());
        }
    }

    private synchronized void doSend(AuditContext auditContext, byte[] msgBytes) throws IOException {
        Socket socket = this.getSocket(auditContext);
        if (this.socketTestPolicy.isBeforeWrite()) {
            LOG.trace("Testing whether socket connection is alive and well before attempting to write");
            if (!this.isSocketConnectionAlive(socket)) {
                this.closeSocket(socket);
                throw new FastSocketException("Read-test before write operation determined that the socket connection is dead");
            }
            LOG.debug("Socket connection is confirmed to be alive.");
        }
        LOG.trace("Now writing out ATNA record");
        OutputStream out = socket.getOutputStream();
        out.write(msgBytes);
        out.flush();
        LOG.trace("ATNA record has been written ({} bytes)", (Object)msgBytes.length);
        if (this.socketTestPolicy.isAfterWrite()) {
            LOG.trace("Testing whether socket connection is alive and well after write to confirm the write operation");
            if (!this.isSocketConnectionAlive(socket)) {
                this.closeSocket(socket);
                throw new FastSocketException("Read-test after write operation determined that the socket connection is dead");
            }
            LOG.debug("Socket connection is confirmed alive. Assuming write operation has succeeded");
        }
    }

    private Socket createSocket(AuditContext auditContext) {
        Socket socket;
        InetAddress auditRepositoryAddress = auditContext.getAuditRepositoryAddress();
        try {
            socket = this.socketFactory.createSocket(auditRepositoryAddress, auditContext.getAuditRepositoryPort());
            this.setSocketOptions(socket);
            if (this.socketTestPolicy != TLSSyslogSenderImpl.SocketTestPolicy.DONT_TEST_POLICY) {
                socket.setSoTimeout(1);
            }
        }
        catch (IOException e) {
            throw new AuditException(String.format("Could not establish connection to %s:%d (%s)", auditContext.getAuditRepositoryHostName(), auditContext.getAuditRepositoryPort(), auditRepositoryAddress.getHostAddress()), (Throwable)e);
        }
        return socket;
    }

    protected void setSocketOptions(Socket socket) throws SocketException {
        Objects.requireNonNull(socket);
        socket.setKeepAlive(DEFAULT_SOCKET_KEEPALIVE);
    }

    private boolean isSocketConnectionAlive(Socket socket) {
        boolean isAlive;
        block6: {
            try {
                if (socket.getSoTimeout() > 0) {
                    int nextByte = socket.getInputStream().read();
                    if (nextByte > -1) {
                        LOG.warn("Socket test was able to read a byte from the socket other than the 'stream closed' value of -1. This should never happen since SYSLOG is a simplex (write only) protocol! Byte value read from stream: {}", (Object)nextByte);
                        isAlive = true;
                    } else {
                        LOG.debug("Socket test read '-1' -> connection closed by server.");
                        isAlive = false;
                    }
                    break block6;
                }
                throw new IllegalStateException("Test requires an SO_TIMEOUT greater than zero set on the socket.");
            }
            catch (SocketTimeoutException e) {
                LOG.debug("Socket read timed out; assuming the connection is still alive.");
                isAlive = true;
            }
            catch (IOException e) {
                LOG.warn("Socket read failed for non-timeout reason; assuming the connection is dead.");
                isAlive = false;
            }
        }
        return isAlive;
    }

    private void closeSocket(Socket socket) {
        if (socket != null && !socket.isClosed()) {
            try {
                socket.close();
            }
            catch (IOException e) {
                LOG.debug("Failed to close pre-existing socket. As we are either shutting down or are in the process of replacing the socket this is not really a worry... Message: {}", (Object)e.getMessage());
            }
        }
    }

    private static class FastSocketException
    extends SocketException {
        private static final long serialVersionUID = 3441388621894032996L;

        public FastSocketException(String msg) {
            super(msg);
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }
    }
}

