/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication;

import java.util.ArrayList;
import java.util.List;
import org.projecthusky.common.model.Patient;
import org.projecthusky.communication.mpi.MpiQueryResponse;
import org.projecthusky.fhir.structures.gen.FhirPatient;

public class MasterPatientIndexQueryResponse {
    private int currentNumbers;
    private List<Patient> patients;
    private int remainingNumbers;
    private boolean success;
    private int totalNumbers;
    private MpiQueryResponse mpiQueryResponse;

    protected MasterPatientIndexQueryResponse(MpiQueryResponse mpiQueryResponse) {
        if (mpiQueryResponse != null) {
            this.mpiQueryResponse = mpiQueryResponse;
            this.success = mpiQueryResponse.getSuccess();
            this.totalNumbers = mpiQueryResponse.getTotalNumbers();
            this.currentNumbers = mpiQueryResponse.getCurrentNumbers();
            this.remainingNumbers = mpiQueryResponse.getRemainingNumbers();
            if (mpiQueryResponse.getPatients() != null && !mpiQueryResponse.getPatients().isEmpty()) {
                this.patients = new ArrayList<Patient>();
                for (FhirPatient patient : mpiQueryResponse.getPatients()) {
                    this.patients.add(patient.getPatient());
                }
            }
        }
    }

    public int getCurrentNumbers() {
        return this.currentNumbers;
    }

    public List<Patient> getPatients() {
        return this.patients;
    }

    public int getRemainingNumbers() {
        return this.remainingNumbers;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public int getTotalNumbers() {
        return this.totalNumbers;
    }

    public MpiQueryResponse getMpiQueryResponse() {
        return this.mpiQueryResponse;
    }
}

