/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication;

import java.util.Date;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.projecthusky.common.communication.Destination;
import org.projecthusky.common.enums.AdministrativeGender;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Name;
import org.projecthusky.common.model.Telecom;
import org.projecthusky.communication.mpi.impl.pdq.V3PdqQuery;
import org.projecthusky.fhir.structures.gen.FhirPatient;

public class MasterPatientIndexQuery {
    private final V3PdqQuery v3PdqQuery;

    public MasterPatientIndexQuery(Destination dest) {
        this.v3PdqQuery = new V3PdqQuery(dest.getSenderApplicationOid(), dest.getSenderFacilityOid(), dest.getReceiverApplicationOid(), dest.getReceiverFacilityOid());
    }

    public MasterPatientIndexQuery addDomainToReturn(String organizationOID) {
        this.v3PdqQuery.addDomainToReturn(organizationOID);
        return this;
    }

    public MasterPatientIndexQuery addMothersMaidenName(boolean useFuzzySearch, Name name) {
        if (name != null) {
            this.v3PdqQuery.addMothersMaidenName(useFuzzySearch, FhirPatient.convertName((Name)name));
        }
        return this;
    }

    public MasterPatientIndexQuery addMothersMaidenName(boolean useFuzzySearch, HumanName name) {
        if (name != null) {
            this.v3PdqQuery.addMothersMaidenName(useFuzzySearch, name);
        }
        return this;
    }

    public MasterPatientIndexQuery addPatientAddress(org.projecthusky.common.model.Address address) {
        if (address != null) {
            this.v3PdqQuery.addPatientAddress(FhirPatient.convertAddress((org.projecthusky.common.model.Address)address));
        }
        return this;
    }

    public MasterPatientIndexQuery addPatientAddress(Address address) {
        if (address != null) {
            this.v3PdqQuery.addPatientAddress(address);
        }
        return this;
    }

    public MasterPatientIndexQuery addPatientIdentificator(Identificator identificator) {
        if (identificator != null) {
            Identifier id = new Identifier();
            id.setSystem(identificator.getRoot());
            id.setValue(identificator.getExtension());
            this.v3PdqQuery.addPatientIdentifier(id);
        }
        return this;
    }

    public MasterPatientIndexQuery addPatientIdentificator(Identifier id) {
        if (id != null) {
            this.v3PdqQuery.addPatientIdentifier(id);
        }
        return this;
    }

    public MasterPatientIndexQuery addPatientName(boolean useFuzzySearch, Name name) {
        if (name != null) {
            this.v3PdqQuery.addPatientName(useFuzzySearch, FhirPatient.convertName((Name)name));
        }
        return this;
    }

    public MasterPatientIndexQuery addPatientName(boolean useFuzzySearch, HumanName name) {
        if (name != null) {
            this.v3PdqQuery.addPatientName(useFuzzySearch, name);
        }
        return this;
    }

    public MasterPatientIndexQuery addPatientTelecom(Telecom tel) {
        this.v3PdqQuery.addPatientTelecom(FhirPatient.convertTelecom((Telecom)tel));
        return this;
    }

    public MasterPatientIndexQuery addPatientTelecom(ContactPoint tel) {
        this.v3PdqQuery.addPatientTelecom(tel);
        return this;
    }

    public MasterPatientIndexQuery cancelQuery() {
        this.v3PdqQuery.cancelQuery();
        return this;
    }

    public MasterPatientIndexQuery continueQuery() {
        this.v3PdqQuery.continueQuery();
        return this;
    }

    protected V3PdqQuery getV3PdqQuery() {
        return this.v3PdqQuery;
    }

    public MasterPatientIndexQuery setPageCount(int pageCount) {
        this.v3PdqQuery.setPageCount(pageCount);
        return this;
    }

    public MasterPatientIndexQuery setPatientDateOfBirth(Date birthDate) {
        this.v3PdqQuery.setPatientBirthDate(birthDate);
        return this;
    }

    public MasterPatientIndexQuery setPatientSex(AdministrativeGender adminstrativeGender) {
        this.v3PdqQuery.setPatientSex(FhirPatient.convertGender((AdministrativeGender)adminstrativeGender));
        return this;
    }
}

