/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication;

import java.net.URI;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;

public class DocumentRequest {
    private DocumentEntry ipfDocReq = new DocumentEntry();
    private URI xdsRepositoryUri;

    public DocumentRequest() {
    }

    public DocumentRequest(String repositoryId, URI repositoryUri, String documentId) {
        this(repositoryId, repositoryUri, documentId, null);
    }

    public DocumentRequest(String repositoryId, URI repositoryUri, String documentId, String homeCommunityId) {
        this();
        this.setRepositoryId(repositoryId);
        this.setRepositoryUri(repositoryUri);
        this.setDocumentId(documentId);
        this.setHomeCommunityId(homeCommunityId);
    }

    public String getDocumentId() {
        return this.ipfDocReq.getUniqueId();
    }

    public String getHomeCommunityId() {
        return this.ipfDocReq.getHomeCommunityId();
    }

    public DocumentEntry getIpfDocumentEntry() {
        return this.ipfDocReq;
    }

    public String getRepositoryId() {
        return this.ipfDocReq.getRepositoryUniqueId();
    }

    public URI getRepositoryUri() {
        return this.xdsRepositoryUri;
    }

    public void setDocumentId(String documentId) {
        this.ipfDocReq.setUniqueId(documentId);
    }

    public void setHomeCommunityId(String homeCommunityId) {
        this.ipfDocReq.setHomeCommunityId(homeCommunityId);
    }

    public void setRepositoryId(String repositoryId) {
        this.ipfDocReq.setRepositoryUniqueId(repositoryId);
    }

    public void setRepositoryUri(URI repositoryUri) {
        this.xdsRepositoryUri = repositoryUri;
    }
}

