/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.projecthusky.common.communication.AffinityDomain;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Patient;
import org.projecthusky.communication.MasterPatientIndexQuery;
import org.projecthusky.communication.MasterPatientIndexQueryResponse;
import org.projecthusky.communication.mpi.impl.PdqV3Query;
import org.projecthusky.communication.mpi.impl.PixV3Query;
import org.projecthusky.communication.mpi.impl.pdq.V3PdqQueryResponse;
import org.projecthusky.fhir.structures.gen.FhirPatient;
import org.projecthusky.xua.core.SecurityHeaderElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="convenienceMasterPatientIndexV3Client")
public class ConvenienceMasterPatientIndexV3 {
    private static Logger log = LoggerFactory.getLogger(ConvenienceMasterPatientIndexV3.class);
    private static final String AFFINITY_DOMAIN_NOT_SPECIFIED = "affinityDomain has to be specified";
    @Autowired
    private CamelContext context;
    @Autowired
    private AuditContext auditContext;

    public boolean addPatientDemographics(Patient patient, String homeCommunityOid, AffinityDomain affinityDomain, SecurityHeaderElement security, String messageId) {
        if (affinityDomain == null) {
            log.error(AFFINITY_DOMAIN_NOT_SPECIFIED);
            return false;
        }
        log.debug("addPatientDemographics, creating patient");
        FhirPatient fhirPatient = new FhirPatient(patient);
        log.debug("addPatientDemographics, add patient");
        PixV3Query v3PixQuery = new PixV3Query(affinityDomain, homeCommunityOid, this.context, this.auditContext);
        boolean ret = v3PixQuery.addPatient(fhirPatient, security, messageId);
        log.debug("addPatientDemographics, add patient finished");
        return ret;
    }

    public boolean mergePatients(Patient finalPatient, String mergeObsoleteId, String homeCommunityOid, AffinityDomain affinityDomain, SecurityHeaderElement security, String messageId) {
        if (affinityDomain == null) {
            log.error(AFFINITY_DOMAIN_NOT_SPECIFIED);
            return false;
        }
        if (mergeObsoleteId == null) {
            log.error("no localid specified for oid {}", (Object)homeCommunityOid);
            return false;
        }
        PixV3Query v3PixQuery = new PixV3Query(affinityDomain, homeCommunityOid, this.context, this.auditContext);
        return v3PixQuery.mergePatient(new FhirPatient(finalPatient), mergeObsoleteId, security, messageId);
    }

    public MasterPatientIndexQueryResponse queryPatientDemographics(MasterPatientIndexQuery mpiQuery, AffinityDomain affinityDomain, SecurityHeaderElement security, String messageId) {
        if (affinityDomain == null) {
            log.error(AFFINITY_DOMAIN_NOT_SPECIFIED);
            return null;
        }
        PdqV3Query query = new PdqV3Query(affinityDomain, null, this.context, this.auditContext);
        V3PdqQueryResponse pdqQueryRespones = query.queryPatients(mpiQuery.getV3PdqQuery(), security, messageId);
        return new MasterPatientIndexQueryResponse(pdqQueryRespones);
    }

    public List<Identificator> queryPatientId(Patient patient, String homeCommunityOid, List<String> requestedCommunityOIDs, AffinityDomain affinityDomain, SecurityHeaderElement security, String messageId) {
        if (affinityDomain == null) {
            log.error(AFFINITY_DOMAIN_NOT_SPECIFIED);
            return new LinkedList<Identificator>();
        }
        PixV3Query query = new PixV3Query(affinityDomain, homeCommunityOid, null, requestedCommunityOIDs.get(0), null, this.context, this.getAuditContext());
        List<String> ids = query.queryPatientId(new FhirPatient(patient), null, null, security, messageId);
        ArrayList<Identificator> list = new ArrayList<Identificator>();
        for (int i = 0; i < requestedCommunityOIDs.size(); ++i) {
            String id = "";
            if (i < ids.size()) {
                id = ids.get(i);
            }
            list.add(new Identificator(requestedCommunityOIDs.get(i), id));
        }
        return list;
    }

    public boolean updatePatientDemographics(Patient patient, String homeCommunityOid, AffinityDomain affinityDomain, SecurityHeaderElement security, String messageId) {
        if (affinityDomain == null) {
            log.error(AFFINITY_DOMAIN_NOT_SPECIFIED);
            return false;
        }
        PixV3Query v3PixQuery = new PixV3Query(affinityDomain, homeCommunityOid, this.context, this.auditContext);
        return v3PixQuery.updatePatient(new FhirPatient(patient), security, messageId);
    }

    public CamelContext getContext() {
        return this.context;
    }

    public void setContext(CamelContext context) {
        this.context = context;
    }

    public AuditContext getAuditContext() {
        return this.auditContext;
    }

    public void setAuditContext(AuditContext context) {
        this.auditContext = context;
    }
}

