/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.UUID;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.commons.text.StringEscapeUtils;
import org.openehealth.ipf.commons.core.OidGenerator;
import org.openehealth.ipf.commons.ihe.xds.XDS;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Association;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssociationLabel;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssociationType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Code;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Document;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Folder;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.SubmissionSet;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Timestamp;
import org.openehealth.ipf.commons.ihe.xds.core.requests.ProvideAndRegisterDocumentSet;
import org.openehealth.ipf.commons.ihe.xds.core.requests.QueryRegistry;
import org.openehealth.ipf.commons.ihe.xds.core.requests.RetrieveDocumentSet;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.Query;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.QueryReturnType;
import org.openehealth.ipf.commons.ihe.xds.core.responses.QueryResponse;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Response;
import org.openehealth.ipf.commons.ihe.xds.core.responses.RetrievedDocumentSet;
import org.projecthusky.common.communication.AffinityDomain;
import org.projecthusky.common.communication.AtnaConfig;
import org.projecthusky.common.communication.Destination;
import org.projecthusky.common.communication.DocumentMetadata;
import org.projecthusky.common.communication.SubmissionSetMetadata;
import org.projecthusky.common.enums.DocumentDescriptor;
import org.projecthusky.common.enums.EhcVersions;
import org.projecthusky.common.utils.XdsMetadataUtil;
import org.projecthusky.common.utils.xml.XmlFactories;
import org.projecthusky.communication.CamelService;
import org.projecthusky.communication.DocumentRequest;
import org.projecthusky.communication.FolderMetadata;
import org.projecthusky.communication.utils.HuskyUtils;
import org.projecthusky.communication.xd.storedquery.AbstractStoredQuery;
import org.projecthusky.communication.xd.storedquery.FindFoldersStoredQuery;
import org.projecthusky.communication.xd.xdm.IndexHtm;
import org.projecthusky.communication.xd.xdm.ReadmeTxt;
import org.projecthusky.communication.xd.xdm.XdmContents;
import org.projecthusky.xua.core.SecurityHeaderElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Component
public class ConvenienceCommunication
extends CamelService {
    private static final String LOG_SEND_REQUEST = "Sending request to '{}' endpoint";
    private static Logger log = LoggerFactory.getLogger(ConvenienceCommunication.class);
    @Autowired
    private CamelContext context;
    private final ThreadLocal<AffinityDomain> affinityDomain = new ThreadLocal();
    private AtnaConfig.AtnaConfigMode atnaConfigMode = AtnaConfig.AtnaConfigMode.UNSECURE;
    private DocumentMetadata.DocumentMetadataExtractionMode documentMetadataExtractionMode = DocumentMetadata.DocumentMetadataExtractionMode.DEFAULT_EXTRACTION;
    private SubmissionSetMetadata.SubmissionSetMetadataExtractionMode submissionSetMetadataExtractionMode = SubmissionSetMetadata.SubmissionSetMetadataExtractionMode.DEFAULT_EXTRACTION;
    private final ThreadLocal<ProvideAndRegisterDocumentSet> txnData = new ThreadLocal();

    public ConvenienceCommunication() {
        this.atnaConfigMode = AtnaConfig.AtnaConfigMode.UNSECURE;
    }

    public ConvenienceCommunication(AffinityDomain affinityDomain) {
        this.affinityDomain.set(affinityDomain);
        this.atnaConfigMode = AtnaConfig.AtnaConfigMode.UNSECURE;
    }

    public ConvenienceCommunication(AffinityDomain affinityDomain, AtnaConfig.AtnaConfigMode atnaConfigMode, DocumentMetadata.DocumentMetadataExtractionMode documentMetadataExtractionMode, SubmissionSetMetadata.SubmissionSetMetadataExtractionMode submissionSetMetadataExtractionMode) {
        this.affinityDomain.set(affinityDomain);
        this.atnaConfigMode = atnaConfigMode;
        this.documentMetadataExtractionMode = documentMetadataExtractionMode;
        this.submissionSetMetadataExtractionMode = submissionSetMetadataExtractionMode;
    }

    public DocumentMetadata addDocument(DocumentDescriptor desc, InputStream inputStream) {
        return this.addDocument(desc, inputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentMetadata addDocument(DocumentDescriptor desc, InputStream inputStream, InputStream inputStream4Metadata) {
        DocumentMetadata retVal = null;
        Document doc = new Document();
        Document doc4Metadata = new Document();
        doc4Metadata.setDocumentEntry(new DocumentEntry());
        InputStream unicodeStream = null;
        try {
            ByteArrayDataSource dataSource;
            if (inputStream4Metadata != null) {
                unicodeStream = this.convertNonAsciiText2Unicode(inputStream4Metadata);
                dataSource = new ByteArrayDataSource(unicodeStream, desc.getMimeType());
                doc4Metadata.setDataHandler(new DataHandler((DataSource)dataSource));
            }
            dataSource = new ByteArrayDataSource(inputStream, desc.getMimeType());
            doc.setDataHandler(new DataHandler((DataSource)dataSource));
            retVal = this.addXdsDocument(doc, desc, doc4Metadata);
        }
        catch (IOException e) {
            log.error("Error adding document from inputstream.", (Throwable)e);
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (unicodeStream != null) {
                try {
                    unicodeStream.close();
                }
                catch (IOException e) {
                    log.error("Error adding document from inputstream.", (Throwable)e);
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (retVal != null) {
            retVal.setDocumentDescriptor(desc);
        }
        return retVal;
    }

    protected InputStream convertNonAsciiText2Unicode(InputStream inputStream) {
        ByteArrayInputStream retVal = null;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            DocumentBuilder docBuilder = XmlFactories.newSafeDocumentBuilder();
            org.w3c.dom.Document document = docBuilder.parse(inputStream);
            this.convertNonAsciiText2Unicode(document.getDocumentElement());
            DOMSource xmlSource = new DOMSource(document);
            StreamResult outputTarget = new StreamResult(outputStream);
            Transformer transformer = XmlFactories.newTransformer();
            transformer.transform(xmlSource, outputTarget);
            retVal = new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (IOException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError | SAXException throwable) {
            // empty catch block
        }
        return retVal;
    }

    protected void convertNonAsciiText2Unicode(Node node) {
        String nodeValue;
        if (node.getFirstChild() != null && (nodeValue = node.getFirstChild().getNodeValue()) != null) {
            nodeValue = nodeValue.replace("\n", "").replace("\t", "");
            node.getFirstChild().setNodeValue(StringEscapeUtils.escapeJava((String)nodeValue));
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node currentNode = nodeList.item(i);
            if (currentNode.getNodeType() != 1) continue;
            this.convertNonAsciiText2Unicode(currentNode);
        }
    }

    public DocumentMetadata addDocument(DocumentDescriptor desc, String filePath) throws IOException {
        return this.addDocument(desc, filePath, null);
    }

    public DocumentMetadata addDocument(DocumentDescriptor desc, String filePath, String filePathMetadata) throws IOException {
        try (FileInputStream is = new FileInputStream(new File(filePath));){
            DocumentMetadata documentMetadata = this.addDocument(desc, is);
            return documentMetadata;
        }
    }

    public void addDocumentToFolder(String documentEntryUUID, String folderEntryUUID) {
        Association association = new Association(AssociationType.HAS_MEMBER, UUID.randomUUID().toString(), folderEntryUUID, documentEntryUUID);
        this.getTxnData().getAssociations().add(association);
    }

    public FolderMetadata addFolder(org.projecthusky.common.model.Code submissionSetContentType) {
        if (this.getTxnData() == null) {
            this.txnData.set(new ProvideAndRegisterDocumentSet());
        }
        ProvideAndRegisterDocumentSet txnData = this.getTxnData();
        Folder folder = new Folder();
        folder.assignEntryUuid();
        if (folder.getUniqueId() == null) {
            folder.assignUniqueId();
        }
        txnData.getFolders().add(folder);
        if (txnData.getSubmissionSet() == null) {
            txnData.setSubmissionSet(new SubmissionSet());
        }
        txnData.getSubmissionSet().setContentTypeCode(XdsMetadataUtil.convertEhcCodeToCode((org.projecthusky.common.model.Code)submissionSetContentType));
        return new FolderMetadata(folder);
    }

    protected DocumentMetadata addXdsDocument(Document doc, DocumentDescriptor desc) {
        return this.addXdsDocument(doc, desc, null);
    }

    protected DocumentMetadata addXdsDocument(Document doc, DocumentDescriptor desc, Document metadataDoc) {
        if (this.getTxnData() == null) {
            this.txnData.set(new ProvideAndRegisterDocumentSet());
        }
        ProvideAndRegisterDocumentSet txnData = this.getTxnData();
        DocumentMetadata docMetadata = null;
        if (metadataDoc != null) {
            docMetadata = new DocumentMetadata(metadataDoc.getDocumentEntry());
            if (doc.getDocumentEntry() == null) {
                doc.setDocumentEntry(metadataDoc.getDocumentEntry());
            }
        } else {
            docMetadata = new DocumentMetadata(doc.getDocumentEntry());
        }
        txnData.getDocuments().add(doc);
        if (this.documentMetadataExtractionMode == DocumentMetadata.DocumentMetadataExtractionMode.DEFAULT_EXTRACTION) {
            if (DocumentDescriptor.CDA_R2.equals((Object)desc)) {
                this.cdaExtractionFixes(docMetadata);
            }
            this.generateDefaultDocEntryAttributes(docMetadata, doc, desc);
        } else {
            docMetadata.clear();
        }
        return docMetadata;
    }

    private void cdaExtractionFixes(DocumentMetadata docMetadata) {
        docMetadata.clearExtracted();
        if (docMetadata.getUniqueId() == null || docMetadata.getUniqueId() != null && docMetadata.getUniqueId().length() > 64) {
            docMetadata.setUniqueId(OidGenerator.uniqueOid().toString());
        }
    }

    public void clearDocuments() {
        this.txnData.set(new ProvideAndRegisterDocumentSet());
    }

    public XdmContents createXdmContents(OutputStream outputStream) {
        if (this.submissionSetMetadataExtractionMode == SubmissionSetMetadata.SubmissionSetMetadataExtractionMode.DEFAULT_EXTRACTION) {
            this.getTxnData().setSubmissionSet(this.generateDefaultSubmissionSetAttributes());
            this.linkDocumentEntryWithSubmissionSet();
        }
        ProvideAndRegisterDocumentSet txnData = this.getTxnData();
        XdmContents xdmContents = new XdmContents(new IndexHtm(txnData), new ReadmeTxt(txnData));
        xdmContents.createZip(outputStream, txnData);
        return xdmContents;
    }

    public XdmContents createXdmContents(OutputStream outputStream, XdmContents xdmContents) {
        ProvideAndRegisterDocumentSet txnData = this.getTxnData();
        if (this.submissionSetMetadataExtractionMode == SubmissionSetMetadata.SubmissionSetMetadataExtractionMode.DEFAULT_EXTRACTION) {
            txnData.setSubmissionSet(this.generateDefaultSubmissionSetAttributes());
            this.linkDocumentEntryWithSubmissionSet();
        }
        xdmContents.createZip(outputStream, txnData);
        return xdmContents;
    }

    public XdmContents createXdmContents(String filePath) {
        ProvideAndRegisterDocumentSet txnData = this.getTxnData();
        if (this.submissionSetMetadataExtractionMode == SubmissionSetMetadata.SubmissionSetMetadataExtractionMode.DEFAULT_EXTRACTION) {
            txnData.setSubmissionSet(this.generateDefaultSubmissionSetAttributes());
            this.linkDocumentEntryWithSubmissionSet();
        }
        XdmContents xdmContents = new XdmContents(new IndexHtm(txnData), new ReadmeTxt(txnData));
        xdmContents.createZip(filePath, txnData);
        return xdmContents;
    }

    public XdmContents createXdmContents(String filePath, XdmContents xdmContents) {
        ProvideAndRegisterDocumentSet txnData = this.getTxnData();
        if (this.submissionSetMetadataExtractionMode == SubmissionSetMetadata.SubmissionSetMetadataExtractionMode.DEFAULT_EXTRACTION) {
            txnData.setSubmissionSet(this.generateDefaultSubmissionSetAttributes());
            this.linkDocumentEntryWithSubmissionSet();
        }
        xdmContents.createZip(filePath, txnData);
        return xdmContents;
    }

    public XdmContents createXdmContents(SubmissionSetMetadata submissionSetMetadata, OutputStream outputStream) {
        ProvideAndRegisterDocumentSet txnData = this.getTxnData();
        if (txnData.getSubmissionSet() == null) {
            txnData.setSubmissionSet(new SubmissionSet());
        }
        submissionSetMetadata.toOhtSubmissionSetType(txnData.getSubmissionSet());
        XdmContents xdmContents = new XdmContents(new IndexHtm(txnData), new ReadmeTxt(txnData));
        xdmContents.createZip(outputStream, txnData);
        return xdmContents;
    }

    private void generateDefaultDocEntryAttributes(DocumentMetadata docMetadata, Document document, DocumentDescriptor documentDescriptor) {
        if (docMetadata.getDocumentEntry().getMimeType() == null) {
            docMetadata.setMimeType(documentDescriptor.getMimeType());
            document.getDocumentEntry().setMimeType(documentDescriptor.getMimeType());
        }
        if (docMetadata.getDocumentEntry().getUniqueId() == null) {
            document.getDocumentEntry().assignUniqueId();
            docMetadata.setUniqueId(document.getDocumentEntry().getUniqueId());
        }
        if (docMetadata.getDocumentEntry().getEntryUuid() == null) {
            document.getDocumentEntry().assignEntryUuid();
            docMetadata.setEntryUUID(document.getDocumentEntry().getEntryUuid());
        }
        if (docMetadata.getDocumentEntry().getCreationTime() == null) {
            docMetadata.setCreationTime(ZonedDateTime.now());
            Timestamp timestamp = new Timestamp(docMetadata.getCreationTime(), Timestamp.Precision.SECOND);
            document.getDocumentEntry().setCreationTime(timestamp);
        }
    }

    private void linkDocumentEntryWithSubmissionSet() {
        Association association;
        ProvideAndRegisterDocumentSet txnData = this.getTxnData();
        for (Document document : txnData.getDocuments()) {
            association = new Association();
            association.setAssociationType(AssociationType.HAS_MEMBER);
            association.setSourceUuid(txnData.getSubmissionSet().getEntryUuid());
            association.setTargetUuid(document.getDocumentEntry().getEntryUuid());
            association.setLabel(AssociationLabel.ORIGINAL);
            association.assignEntryUuid();
            txnData.getAssociations().add(association);
        }
        for (Folder folder : txnData.getFolders()) {
            association = new Association(AssociationType.HAS_MEMBER, txnData.getSubmissionSet().getEntryUuid(), txnData.getSubmissionSet().getEntryUuid(), folder.getEntryUuid());
            association.assignEntryUuid();
            txnData.getAssociations().add(association);
        }
    }

    public SubmissionSet generateDefaultSubmissionSetAttributes() {
        ProvideAndRegisterDocumentSet txnData = this.getTxnData();
        if (txnData.getSubmissionSet() == null) {
            txnData.setSubmissionSet(new SubmissionSet());
        }
        SubmissionSet subSet = txnData.getSubmissionSet();
        if (txnData.getDocuments() != null && !txnData.getDocuments().isEmpty()) {
            this.setSubSetDetailsFromDocument(subSet);
        } else if (txnData.getFolders() != null && !txnData.getFolders().isEmpty()) {
            this.setSubSetDetailsFromFolder(subSet);
        }
        return subSet;
    }

    private void setSubSetDetailsFromDocument(SubmissionSet subSet) {
        ProvideAndRegisterDocumentSet txnData = this.getTxnData();
        log.info("count of documents {}", (Object)txnData.getDocuments().size());
        for (Document document : txnData.getDocuments()) {
            DocumentEntry docEntry = document.getDocumentEntry();
            if (docEntry.getPatientId() == null) {
                log.warn("Missing destination patient ID in DocumentMetadata of document.");
            }
            if (subSet.getContentTypeCode() == null && docEntry.getTypeCode() != null) {
                subSet.setContentTypeCode(docEntry.getTypeCode());
            }
            this.setGeneralSubSetDetails(subSet, docEntry.getPatientId());
        }
    }

    private void setSubSetDetailsFromFolder(SubmissionSet subSet) {
        ProvideAndRegisterDocumentSet txnData = this.getTxnData();
        for (Folder folder : txnData.getFolders()) {
            if (folder.getPatientId() == null) {
                throw new IllegalStateException("Missing destination patient ID in DocumentMetadata of first document.");
            }
            if (subSet.getContentTypeCode() == null && folder.getCodeList() != null && folder.getCodeList().get(0) != null) {
                subSet.setContentTypeCode((Code)folder.getCodeList().get(0));
            }
            this.setGeneralSubSetDetails(subSet, folder.getPatientId());
        }
    }

    protected void setGeneralSubSetDetails(SubmissionSet subSet, Identifiable patientId) {
        if (subSet.getSubmissionTime() == null) {
            subSet.setSubmissionTime(new Timestamp(ZonedDateTime.now(), Timestamp.Precision.SECOND));
        }
        if (subSet.getEntryUuid() == null) {
            subSet.setEntryUuid(UUID.randomUUID().toString());
        }
        if (subSet.getUniqueId() == null || subSet.getSourceId() == null) {
            if (subSet.getUniqueId() == null) {
                subSet.assignUniqueId();
            }
            if (subSet.getSourceId() == null) {
                subSet.setSourceId(this.getSourceId(patientId));
            }
        }
        if (subSet.getPatientId() == null) {
            subSet.setPatientId(patientId);
        }
    }

    protected String getSourceId(Identifiable patientId) {
        if (patientId != null) {
            return patientId.getAssigningAuthority().getUniversalId();
        }
        return EhcVersions.getCurrentVersion().getOid();
    }

    public AffinityDomain getAffinityDomain() {
        if (this.affinityDomain.get() == null) {
            this.affinityDomain.set(new AffinityDomain(null, null, new ArrayList()));
        }
        return this.affinityDomain.get();
    }

    public void setAffinityDomain(AffinityDomain affinityDomain) {
        this.affinityDomain.set(affinityDomain);
    }

    public DocumentMetadata.DocumentMetadataExtractionMode getAutomaticExtractionEnabled() {
        return this.documentMetadataExtractionMode;
    }

    public void setAutomaticExtractionEnabled(DocumentMetadata.DocumentMetadataExtractionMode automaticExtractionEnabled) {
        this.documentMetadataExtractionMode = automaticExtractionEnabled;
    }

    public void setAutomaticExtractionEnabled(SubmissionSetMetadata.SubmissionSetMetadataExtractionMode automaticExtractionEnabled) {
        this.submissionSetMetadataExtractionMode = automaticExtractionEnabled;
    }

    public ProvideAndRegisterDocumentSet getTxnData() {
        return this.txnData.get();
    }

    public XdmContents getXdmContents(String filePath) {
        return new XdmContents(filePath);
    }

    public XdmContents getXdmContents(ZipFile zipFile) {
        return new XdmContents(zipFile);
    }

    public QueryResponse queryDocumentReferencesOnly(AbstractStoredQuery queryParameter, SecurityHeaderElement securityHeader, String messageId) throws Exception {
        return this.queryDocumentQuery(queryParameter, securityHeader, QueryReturnType.OBJECT_REF, messageId);
    }

    public QueryResponse queryDocuments(AbstractStoredQuery queryParameter, SecurityHeaderElement securityHeader, String messageId) throws Exception {
        return this.queryDocumentQuery(queryParameter, securityHeader, QueryReturnType.LEAF_CLASS, messageId);
    }

    protected QueryResponse queryDocumentQuery(AbstractStoredQuery query, SecurityHeaderElement securityHeader, QueryReturnType returnType, String messageId) throws Exception {
        AffinityDomain affinityDomain = this.getAffinityDomain();
        QueryRegistry queryRegistry = new QueryRegistry((Query)query.getIpfQuery());
        queryRegistry.setReturnType(returnType);
        String endpoint = HuskyUtils.createEndpoint(XDS.Interactions.ITI_18.getWsTransactionConfiguration().getName(), affinityDomain.getRepositoryDestination().getUri(), this.atnaConfigMode.equals((Object)AtnaConfig.AtnaConfigMode.SECURE));
        log.info(LOG_SEND_REQUEST, (Object)endpoint);
        Exchange exchange = this.send(endpoint, queryRegistry, securityHeader, messageId, null);
        return (QueryResponse)exchange.getMessage().getBody(QueryResponse.class);
    }

    public QueryResponse queryFolders(FindFoldersStoredQuery queryParameter, SecurityHeaderElement security, String messageId) throws Exception {
        return this.queryDocumentQuery(queryParameter, security, QueryReturnType.LEAF_CLASS, messageId);
    }

    public RetrievedDocumentSet retrieveDocument(DocumentRequest docReq, SecurityHeaderElement security, String messageId) throws Exception {
        return this.retrieveDocuments(new DocumentRequest[]{docReq}, security, messageId);
    }

    public RetrievedDocumentSet retrieveDocuments(DocumentRequest[] docReq, SecurityHeaderElement security, String messageId) throws Exception {
        AffinityDomain affinityDomain = this.getAffinityDomain();
        RetrieveDocumentSet retrieveDocumentSet = new RetrieveDocumentSet();
        for (DocumentRequest element : docReq) {
            if (element == null) continue;
            retrieveDocumentSet.addReferenceTo(element.getIpfDocumentEntry());
        }
        String endpoint = HuskyUtils.createEndpoint(XDS.Interactions.ITI_43.getWsTransactionConfiguration().getName(), affinityDomain.getRepositoryDestination().getUri(), this.atnaConfigMode.equals((Object)AtnaConfig.AtnaConfigMode.SECURE));
        log.info(LOG_SEND_REQUEST, (Object)endpoint);
        Exchange exchange = this.send(endpoint, retrieveDocumentSet, security, messageId, null);
        return (RetrievedDocumentSet)exchange.getMessage().getBody(RetrievedDocumentSet.class);
    }

    public void setAtnaConfig(AtnaConfig.AtnaConfigMode atnaConfigMode) {
        this.atnaConfigMode = atnaConfigMode;
    }

    private void setDefaultKeystoreTruststore(Destination dest) {
        if (dest.getKeyStore() == null) {
            System.clearProperty("javax.net.ssl.keyStore");
            System.clearProperty("javax.net.ssl.keyStorePassword");
            System.clearProperty("javax.net.ssl.keyStoreType");
            System.clearProperty("javax.net.ssl.trustStore");
            System.clearProperty("javax.net.ssl.trustStorePassword");
            System.clearProperty("javax.net.ssl.trustStoreType");
        } else {
            System.setProperty("javax.net.ssl.keyStore", dest.getKeyStore());
            System.setProperty("javax.net.ssl.keyStorePassword", dest.getKeyStorePassword());
            System.setProperty("javax.net.ssl.keyStoreType", dest.getKeyStoreType());
            System.setProperty("javax.net.ssl.trustStore", dest.getTrustStore());
            System.setProperty("javax.net.ssl.trustStorePassword", dest.getTrustStorePassword());
            System.setProperty("javax.net.ssl.trustStoreType", dest.getTrustStoreType());
        }
    }

    public Response submit(SecurityHeaderElement security, String messageId) throws Exception {
        return this.submit(security, null, messageId);
    }

    public Response submit(SubmissionSetMetadata submissionSetMetadata, SecurityHeaderElement security, String messageId) throws Exception {
        ProvideAndRegisterDocumentSet txnData = this.getTxnData();
        if (txnData.getSubmissionSet() == null) {
            txnData.setSubmissionSet(new SubmissionSet());
        }
        submissionSetMetadata.toOhtSubmissionSetType(txnData.getSubmissionSet());
        return this.submit(security, messageId);
    }

    public Response submitReplacement(SubmissionSetMetadata submissionSetMetadata, String idOfOriginDocument, SecurityHeaderElement security, String messageId) throws Exception {
        ProvideAndRegisterDocumentSet txnData = this.getTxnData();
        if (txnData.getSubmissionSet() == null) {
            txnData.setSubmissionSet(new SubmissionSet());
        }
        Association association = new Association();
        association.setAssociationType(AssociationType.REPLACE);
        association.setAvailabilityStatus(AvailabilityStatus.APPROVED);
        association.setTargetUuid(idOfOriginDocument);
        association.assignEntryUuid();
        txnData.getAssociations().add(association);
        submissionSetMetadata.toOhtSubmissionSetType(txnData.getSubmissionSet());
        return this.submit(security, association, messageId);
    }

    private Response submit(SecurityHeaderElement security, Association association, String messageId) throws Exception {
        log.debug("submit document");
        AffinityDomain affinityDomain = this.getAffinityDomain();
        ProvideAndRegisterDocumentSet txnData = this.getTxnData();
        this.setDefaultKeystoreTruststore(affinityDomain.getRepositoryDestination());
        if (this.submissionSetMetadataExtractionMode == SubmissionSetMetadata.SubmissionSetMetadataExtractionMode.DEFAULT_EXTRACTION) {
            log.debug("extract submission set metadata");
            txnData.setSubmissionSet(this.generateDefaultSubmissionSetAttributes());
            this.linkDocumentEntryWithSubmissionSet();
        }
        if (association != null) {
            log.debug("set association data");
            if (txnData.getDocuments() != null && !txnData.getDocuments().isEmpty() && txnData.getDocuments().get(0) != null) {
                association.setSourceUuid(((Document)txnData.getDocuments().get(0)).getDocumentEntry().getEntryUuid());
            } else if (txnData.getFolders() != null && !txnData.getFolders().isEmpty() && txnData.getFolders().get(0) != null) {
                association.setSourceUuid(((Folder)txnData.getFolders().get(0)).getEntryUuid());
            }
        }
        log.debug("prepare submit of document");
        String endpoint = HuskyUtils.createEndpoint(XDS.Interactions.ITI_41.getWsTransactionConfiguration().getName(), affinityDomain.getRepositoryDestination().getUri(), this.atnaConfigMode.equals((Object)AtnaConfig.AtnaConfigMode.SECURE));
        log.debug(LOG_SEND_REQUEST, (Object)endpoint);
        Exchange exchange = this.send(endpoint, txnData, security, messageId, null);
        return (Response)exchange.getMessage().getBody(Response.class);
    }
}

