/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.util.CastUtils;
import org.apache.cxf.headers.Header;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.platform.camel.ihe.ws.AbstractWsEndpoint;
import org.opensaml.core.xml.XMLObject;
import org.projecthusky.common.utils.xml.XmlFactories;
import org.projecthusky.xua.core.SecurityHeaderElement;
import org.projecthusky.xua.exceptions.SerializeException;
import org.projecthusky.xua.serialization.impl.OpenSaml2SerializerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class CamelService
implements CamelContextAware {
    private static Logger log = LoggerFactory.getLogger(CamelService.class);
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private AuditContext auditContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public AuditContext getAuditContext() {
        return this.auditContext;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    protected void addWssHeader(SecurityHeaderElement securityHeaderElement, Exchange exchange) throws SerializeException, ParserConfigurationException {
        Element wssElement = new OpenSaml2SerializerImpl().serializeToXml((XMLObject)securityHeaderElement.getWrappedObject());
        DocumentBuilder docBuilder = XmlFactories.newSafeDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element wsseElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
        QName wsseQName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security", "wsse");
        Node replaceNode = wsseElement.getOwnerDocument().importNode(wssElement, true);
        wsseElement.appendChild(replaceNode);
        HashMap<QName, Header> soapHeaders = CastUtils.cast((Map)((Map)exchange.getIn().getHeader(AbstractWsEndpoint.OUTGOING_SOAP_HEADERS)));
        if (soapHeaders == null) {
            soapHeaders = new HashMap<QName, Header>();
        }
        try {
            Header newHeader = new Header(wsseQName, (Object)wsseElement);
            newHeader.setDirection(Header.Direction.DIRECTION_OUT);
            soapHeaders.put(wsseQName, newHeader);
            exchange.getIn().setHeader(AbstractWsEndpoint.OUTGOING_SOAP_HEADERS, soapHeaders);
        }
        catch (Exception e) {
            log.error("Exception caught while creating the WSS header", (Throwable)e);
        }
    }

    protected void addHttpHeader(Exchange exchange, Map<String, String> outgoingHttpHeaders) {
        HashMap<String, String> outgoingHeaders = CastUtils.cast((Map)((Map)exchange.getIn().getHeader(AbstractWsEndpoint.OUTGOING_HTTP_HEADERS)));
        if (outgoingHeaders == null) {
            outgoingHeaders = new HashMap<String, String>();
        }
        for (Map.Entry<String, String> entry : outgoingHttpHeaders.entrySet()) {
            if (entry == null || entry.getValue() == null || entry.getKey() == null) continue;
            outgoingHeaders.put(entry.getKey(), entry.getValue());
        }
        exchange.getIn().setHeader(AbstractWsEndpoint.OUTGOING_HTTP_HEADERS, outgoingHeaders);
    }

    protected Exchange send(String endpoint, Object body, SecurityHeaderElement securityHeaderElement, String messageId, Map<String, String> outgoingHttpHeaders) throws Exception {
        DefaultExchange exchange = new DefaultExchange(this.camelContext);
        exchange.getIn().setBody(body);
        if (securityHeaderElement != null) {
            log.debug("build wss header");
            this.addWssHeader(securityHeaderElement, (Exchange)exchange);
        }
        if (outgoingHttpHeaders != null && !outgoingHttpHeaders.isEmpty()) {
            log.debug("add outgoing http headers");
            this.addHttpHeader((Exchange)exchange, outgoingHttpHeaders);
        }
        try (ProducerTemplate template = this.camelContext.createProducerTemplate();){
            Exchange result = template.send(endpoint, (Exchange)exchange);
            if (result.getException() != null) {
                throw result.getException();
            }
            Exchange exchange2 = result;
            return exchange2;
        }
    }
}

