/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.xd.storedquery;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.projecthusky.common.enums.DateTimeRangeAttributes;
import org.projecthusky.communication.xd.storedquery.DateTimeRange;

class DateTimeRangeTest {
    private ZonedDateTime testDate1;
    private ZonedDateTime testDate2;
    private String testDateToStr1;
    private ZonedDateTime testDateTo1;
    private ZonedDateTime testDateTo2;

    DateTimeRangeTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.testDate1 = ZonedDateTime.of(1980, 5, 21, 2, 22, 11, 0, ZoneOffset.UTC);
        this.testDate2 = ZonedDateTime.of(2015, 5, 21, 13, 34, 59, 0, ZoneOffset.UTC);
        this.testDateToStr1 = "20381231235959";
        this.testDateTo1 = ZonedDateTime.of(2038, 12, 31, 23, 59, 59, 0, ZoneOffset.UTC);
        this.testDateTo2 = ZonedDateTime.of(2027, 1, 10, 0, 31, 2, 0, ZoneOffset.UTC);
    }

    @Test
    void testDateTimeRange() {
        DateTimeRange d = new DateTimeRange(DateTimeRangeAttributes.CREATION_TIME, this.testDate1, this.testDate2);
        Assertions.assertEquals((Object)d.getFrom().toInstant(), (Object)this.testDate1.toInstant());
        Assertions.assertEquals((Object)d.getTo().toInstant(), (Object)this.testDate2.toInstant());
        Assertions.assertEquals((Object)"19800521022211", (Object)d.getFrom().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC)));
        Assertions.assertEquals((Object)"20150521133459", (Object)d.getTo().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC)));
        Assertions.assertEquals((Object)"19800521022211", (Object)d.getOhtDateTimeRange().getFrom().getDateTime().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC)));
        Assertions.assertEquals((Object)"20150521133459", (Object)d.getOhtDateTimeRange().getTo().getDateTime().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC)));
    }

    @Test
    void testSetGetFrom() {
        DateTimeRange d = new DateTimeRange(DateTimeRangeAttributes.CREATION_TIME, this.testDate1, this.testDate2);
        d.setFrom(this.testDateTo2, null);
        Assertions.assertEquals((Object)this.testDateTo2.toInstant(), (Object)d.getFrom().toInstant());
    }

    @Test
    void testSetGetTo() {
        DateTimeRange d = new DateTimeRange(DateTimeRangeAttributes.CREATION_TIME, this.testDate1, this.testDate2);
        d.setTo(this.testDateTo1, null);
        Assertions.assertEquals((Object)this.testDateTo1.toInstant(), (Object)d.getTo().toInstant());
        Assertions.assertEquals((Object)this.testDateToStr1, (Object)d.getTo().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC)));
    }
}

