/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.utils;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projecthusky.communication.utils.Traceparent;

class TraceparentTest {
    TraceparentTest() {
    }

    @Test
    void testParse() {
        Traceparent traceparent = Traceparent.parse((String)"00-0af7651916cd43dd8448eb211c80319c-b7ad6b7169203331-01");
        Assertions.assertEquals((int)0, (int)traceparent.version());
        Assertions.assertEquals((Object)"0af7651916cd43dd8448eb211c80319c", (Object)traceparent.traceId());
        Assertions.assertEquals((Object)"b7ad6b7169203331", (Object)traceparent.parentId());
        Assertions.assertEquals((int)1, (int)traceparent.flags());
        Assertions.assertEquals((Object)"00-0af7651916cd43dd8448eb211c80319c-b7ad6b7169203331-01", (Object)traceparent.toString());
        traceparent = Traceparent.parse((String)"fe-4bf92f3577b34da6a3ce929d0e0e4736-00f067aa0ba902b7-ff");
        Assertions.assertEquals((int)254, (int)traceparent.version());
        Assertions.assertEquals((Object)"4bf92f3577b34da6a3ce929d0e0e4736", (Object)traceparent.traceId());
        Assertions.assertEquals((Object)"00f067aa0ba902b7", (Object)traceparent.parentId());
        Assertions.assertEquals((int)255, (int)traceparent.flags());
        Assertions.assertEquals((Object)"fe-4bf92f3577b34da6a3ce929d0e0e4736-00f067aa0ba902b7-ff", (Object)traceparent.toString());
    }

    @Test
    void testWithers() {
        Traceparent traceparent = Traceparent.parse((String)"00-0af7651916cd43dd8448eb211c80319c-b7ad6b7169203331-01");
        Assertions.assertEquals((Object)"00-0af7651916cd43dd8448eb211c80319c-b7ad6b7169203331-01", (Object)traceparent.toString());
        traceparent = traceparent.withVersion("02");
        Assertions.assertEquals((Object)"02-0af7651916cd43dd8448eb211c80319c-b7ad6b7169203331-01", (Object)traceparent.toString());
        traceparent = traceparent.withTraceId("4bf92f3577b34da6a3ce929d0e0e4736");
        Assertions.assertEquals((Object)"02-4bf92f3577b34da6a3ce929d0e0e4736-b7ad6b7169203331-01", (Object)traceparent.toString());
        traceparent = traceparent.withParentId("00f067aa0ba902b7");
        Assertions.assertEquals((Object)"02-4bf92f3577b34da6a3ce929d0e0e4736-00f067aa0ba902b7-01", (Object)traceparent.toString());
        traceparent = traceparent.withFlags("ff");
        Assertions.assertEquals((Object)"02-4bf92f3577b34da6a3ce929d0e0e4736-00f067aa0ba902b7-ff", (Object)traceparent.toString());
        traceparent = traceparent.withRandomParentId();
        Assertions.assertNotEquals((Object)"00f067aa0ba902b7", (Object)traceparent.parentId());
    }

    @Test
    void testInvalids() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Traceparent.parse((String)"ff-0af7651916cd43dd8448eb211c80319c-b7ad6b7169203331-00"));
        Traceparent traceparent = Traceparent.parse((String)"00-0af7651916cd43dd8448eb211c80319c-b7ad6b7169203331-01");
        Assertions.assertThrows(IllegalArgumentException.class, () -> traceparent.withVersion("ff"));
    }

    @Test
    void testEquals() {
        Traceparent traceparent1 = Traceparent.parse((String)"00-0af7651916cd43dd8448eb211c80319c-b7ad6b7169203331-01");
        Traceparent traceparent2 = Traceparent.parse((String)"00-0af7651916cd43dd8448eb211c80319c-b7ad6b7169203331-01");
        Traceparent traceparent3 = Traceparent.parse((String)"00-0af7651916cd43dd8448eb211c80319c-b7ad6b7169203331-02");
        Assertions.assertEquals((Object)traceparent1, (Object)traceparent2);
        Assertions.assertNotEquals((Object)traceparent1, (Object)traceparent3);
        traceparent1 = Traceparent.random();
        traceparent2 = Traceparent.random();
        traceparent3 = Traceparent.random();
        Assertions.assertNotEquals((Object)traceparent1, (Object)traceparent2);
        Assertions.assertNotEquals((Object)traceparent2, (Object)traceparent3);
        Assertions.assertNotEquals((Object)traceparent1, (Object)traceparent3);
    }
}

