/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.testhelper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Document;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.requests.ProvideAndRegisterDocumentSet;
import org.projecthusky.common.communication.DocumentMetadata;
import org.projecthusky.common.enums.ConfidentialityCode;
import org.projecthusky.common.enums.DocumentDescriptor;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.communication.ConvenienceCommunication;
import org.projecthusky.communication.testhelper.XdsTestUtils;
import org.projecthusky.communication.xd.xdm.XdmContents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XdmTestUtils
extends XdsTestUtils {
    private static final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    protected static Logger log = LoggerFactory.getLogger(XdmTestUtils.class);

    public static String getTempFilePath() {
        String tmpPath = "";
        if (System.getProperty("java.io.tmpdir") != null) {
            tmpPath = System.getProperty("java.io.tmpdir");
        } else if (System.getenv("TMP") != null) {
            tmpPath = System.getenv("TMP");
        } else if (System.getenv("TEMP") != null) {
            tmpPath = System.getenv("TEMP");
        }
        return tmpPath;
    }

    public XdmContents exportSamples(ConvenienceCommunication conCom, File targetFile, String sourceFile1, String sourceFile2) {
        conCom.clearDocuments();
        InputStream inputStream = this.getClass().getResourceAsStream(sourceFile1);
        DocumentMetadata metaData = conCom.addDocument(DocumentDescriptor.CDA_R2, inputStream);
        this.setNistMetadata(metaData);
        InputStream inputStream2 = this.getClass().getResourceAsStream(sourceFile2);
        DocumentMetadata metaData2 = conCom.addDocument(DocumentDescriptor.PDF, inputStream2);
        this.setNistMetadata2(metaData2);
        XdmContents xdmContents = null;
        try {
            FileOutputStream outputStream = new FileOutputStream(targetFile);
            xdmContents = conCom.createXdmContents((OutputStream)outputStream);
            outputStream.close();
            log.debug(dateFormat.format(new Date()) + ": done. Stored to: " + targetFile.getCanonicalPath() + "\n");
        }
        catch (FileNotFoundException e) {
            log.error("FileNotFound.", (Throwable)e);
        }
        catch (IOException e) {
            log.error("IOException.", (Throwable)e);
        }
        return xdmContents;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean importIntegrityCheck(String filepath, ConvenienceCommunication conCom) {
        InputStream is;
        String path = this.prepareFile(filepath);
        File sourceFile = new File(path);
        XdmContents importContents = this.importSamples(conCom, sourceFile);
        Assertions.assertNotNull((Object)importContents);
        Document doc1 = (Document)importContents.getDocumentList().get(0);
        Document doc2 = (Document)importContents.getDocumentList().get(1);
        DocumentEntry doc1Metadata = ((Document)((ProvideAndRegisterDocumentSet)importContents.getXdmContentsAsIpfSubmitTransactionData().get(0)).getDocuments().stream().filter(d -> d != null && d.getDocumentEntry() != null && d.getDocumentEntry().getEntryUuid().equals(doc1.getDocumentEntry().getEntryUuid())).collect(Collectors.toList()).get(0)).getDocumentEntry();
        DocumentEntry doc2Metadata = ((Document)((ProvideAndRegisterDocumentSet)importContents.getXdmContentsAsIpfSubmitTransactionData().get(0)).getDocuments().stream().filter(d -> d != null && d.getDocumentEntry() != null && d.getDocumentEntry().getEntryUuid().equals(doc2.getDocumentEntry().getEntryUuid())).collect(Collectors.toList()).get(0)).getDocumentEntry();
        try {
            is = doc1.getDataHandler().getInputStream();
            try {
                byte[] doc1Bytes = IOUtils.toByteArray((InputStream)is);
                String doc1Hash = DigestUtils.sha1Hex((byte[])doc1Bytes);
                long doc1Size = doc1Bytes.length;
                if (!doc1Hash.equals(doc1Metadata.getHash())) {
                    boolean bl = false;
                    return bl;
                }
                if (doc1Size != doc1Metadata.getSize()) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        try {
            is = doc2.getDataHandler().getInputStream();
            try {
                byte[] doc2Bytes = IOUtils.toByteArray((InputStream)is);
                String doc2Hash = DigestUtils.sha1Hex((byte[])doc2Bytes);
                long doc2Size = doc2Bytes.length;
                if (!doc2Hash.equals(doc2Metadata.getHash())) {
                    boolean bl = false;
                    return bl;
                }
                if (doc2Size == doc2Metadata.getSize()) return true;
                boolean bl = false;
                return bl;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public XdmContents importSamples(ConvenienceCommunication conCom, File targetFile) {
        conCom.clearDocuments();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(targetFile);
        }
        catch (ZipException e) {
            log.error("ZipException.", (Throwable)e);
        }
        catch (IOException e) {
            log.error("IOException.", (Throwable)e);
        }
        return conCom.getXdmContents(zipFile);
    }

    public boolean isEqualHash(InputStream is1, InputStream is2) {
        try {
            return DigestUtils.sha1Hex((InputStream)is1).equals(DigestUtils.sha1Hex((InputStream)is2));
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isEqualSize(InputStream is1, InputStream is2) {
        try {
            return IOUtils.toByteArray((InputStream)is1).length == IOUtils.toByteArray((InputStream)is2).length;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isSamplesHashAndSizeEqual(XdmContents xdmContents, String sourceFile1, String sourceFile2) throws IOException {
        InputStream cdaOriginalIs = this.getClass().getResourceAsStream(sourceFile1);
        InputStream pdfOriginalIs = this.getClass().getResourceAsStream(sourceFile2);
        if (!this.isEqualHash(cdaOriginalIs, ((Document)xdmContents.getDocumentList().get(0)).getDataHandler().getInputStream())) {
            return false;
        }
        if (!this.isEqualHash(pdfOriginalIs, ((Document)xdmContents.getDocumentList().get(1)).getDataHandler().getInputStream())) {
            return false;
        }
        cdaOriginalIs = this.getClass().getResourceAsStream(sourceFile1);
        pdfOriginalIs = this.getClass().getResourceAsStream(sourceFile2);
        if (!this.isEqualSize(cdaOriginalIs, ((Document)xdmContents.getDocumentList().get(0)).getDataHandler().getInputStream())) {
            return false;
        }
        return this.isEqualSize(pdfOriginalIs, ((Document)xdmContents.getDocumentList().get(1)).getDataHandler().getInputStream());
    }

    protected String prepareFile(String resourcePath) {
        String filename = FilenameUtils.getName((String)resourcePath);
        String targetPath = null;
        try {
            int bytesRead;
            targetPath = File.createTempFile(filename, "").getAbsolutePath();
            InputStream input = this.getClass().getResourceAsStream(resourcePath);
            FileOutputStream output = new FileOutputStream(targetPath);
            byte[] buffer = new byte[2048];
            while ((bytesRead = input.read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, bytesRead);
            }
            input.close();
            ((OutputStream)output).close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return targetPath;
    }

    protected void setNistMetadata(DocumentMetadata metaData) {
        metaData.setDestinationPatientId(new Identificator("1.3.6.1.4.1.21367.2005.13.20.3000", "b8a9a9ad17b5429"));
        metaData.setSourcePatientId(new Identificator("1.2.3.4", "2342134localid"));
        metaData.setCodedLanguage("fr-CH");
        metaData.setTypeCode(new Code("2.16.840.1.113883.6.1", "34817-7", "Otorhinolaryngology Evaluation and Management Note"));
        metaData.setFormatCode(new Code("1.3.6.1.4.1.19376.1.2.3", "urn:ihe:rad:TEXT", "urn:ihe:rad:TEXT"));
        metaData.setClassCode(new Code("1.3.6.1.4.1.21367.100.1", "DEMO-Procedure", "Procedure"));
        metaData.setHealthcareFacilityTypeCode(new Code("2.16.840.1.113883.5.11", "AMB", "Ambulance"));
        metaData.setPracticeSettingCode(new Code("2.16.840.1.113883.6.96", "408478003", "Critical Care Medicine"));
        metaData.addConfidentialityCode(ConfidentialityCode.NORMAL);
    }

    protected void setNistMetadata2(DocumentMetadata metaData) {
        metaData.setDestinationPatientId(new Identificator("1.3.6.1.4.1.21367.2005.13.20.3000", "b8a9a9ad17b5429"));
        metaData.setSourcePatientId(new Identificator("1.2.3.4", "2342134localid"));
        metaData.setCodedLanguage("de-CH");
        metaData.setTypeCode(new Code("2.16.840.1.113883.6.1", "34133-9", "Summarization of Episode Note"));
        metaData.setFormatCode(new Code("1.3.6.1.4.1.19376.1.2.3", "urn:ihe:iti:xds-sd:pdf:2008", "1.3.6.1.4.1.19376.1.2.20 (Scanned Document)"));
        metaData.setClassCode(new Code("1.3.6.1.4.1.21367.100.1", "DEMO-Consult", "Consultation"));
        metaData.setHealthcareFacilityTypeCode(new Code("2.16.840.1.113883.5.11", "AMB", "Ambulance"));
        metaData.setPracticeSettingCode(new Code("2.16.840.1.113883.6.96", "394802001", "General Medicine"));
        metaData.addConfidentialityCode(ConfidentialityCode.NORMAL);
    }
}

