/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.testhelper;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.projecthusky.common.basetypes.AddressBaseType;
import org.projecthusky.common.basetypes.IdentificatorBaseType;
import org.projecthusky.common.basetypes.NameBaseType;
import org.projecthusky.common.basetypes.OrganizationBaseType;
import org.projecthusky.common.basetypes.TelecomBaseType;
import org.projecthusky.common.enums.AdministrativeGender;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.PostalAddressUse;
import org.projecthusky.common.enums.TelecomAddressUse;
import org.projecthusky.common.model.Address;
import org.projecthusky.common.model.Author;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Name;
import org.projecthusky.common.model.Organization;
import org.projecthusky.common.model.Patient;
import org.projecthusky.common.model.Performer;
import org.projecthusky.common.model.Telecom;
import org.projecthusky.common.model.Value;
import org.projecthusky.common.utils.DateUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class TestUtils {
    public static final int NUMBER_OF_RANDOM_STRING_LETTERS = 129;
    public Address address1;
    public Author author1;
    public Author author2;
    public Code code1;
    public Code code2;
    public Date endDate;
    public String endDateString;
    public Code gtinCode;
    public Identificator id1;
    public Identificator id2;
    public Code loincCode;
    public Name name1;
    public Name name2;
    public Double number;
    public String numS1;
    public String numS2;
    public Organization organization1;
    public Patient patient1;
    public Code problemCode;
    public Calendar startDate;
    public String startDateString;
    public List<TelecomBaseType> telecoms1;
    public String telS1;
    public String telS2;
    public String ts1;
    public String ts2;
    public String ts3;
    public String ts4;
    public String ts5;
    public Value value1;
    public Value value2;
    protected XPath xpath;
    protected XPathFactory xpathFactory = XPathFactory.newInstance();

    public static String generateString(int length) {
        Random rng = new Random();
        String characters = "abc\u00eb\u00d9d\u00c0\u00ffe\u0152f\u00fag\u00cb\u00db\u00f9hij\u00e0\u00cak\u00c7l\u0178m\u0153\ufffd?\u00e7\u00dan\u00d4\u00c8o\u00e6\u00fb\u00e8p\u00bb\u00d9\u00c8q\u00f9\u00f4\u00ea\u00ee\u00ef\u00c6rs\u00e2\u00c9t\u00e9\u00ceuvw\u00e8xyl\u00ef\u00e4\u00fc\u00ec\u00f6\u00c4\ufffd?\u00d2\u00dc\u00c2\u00d6\u00cc?\u00df\u00d3/\u00f2\u00f3:#\\\u00ed\ufffd?~*\u00c9'\u00e9,\u00b4\u00c0\u00e0";
        char[] text = new char[length];
        for (int i = 0; i < length; ++i) {
            text[i] = "abc\u00eb\u00d9d\u00c0\u00ffe\u0152f\u00fag\u00cb\u00db\u00f9hij\u00e0\u00cak\u00c7l\u0178m\u0153\ufffd?\u00e7\u00dan\u00d4\u00c8o\u00e6\u00fb\u00e8p\u00bb\u00d9\u00c8q\u00f9\u00f4\u00ea\u00ee\u00ef\u00c6rs\u00e2\u00c9t\u00e9\u00ceuvw\u00e8xyl\u00ef\u00e4\u00fc\u00ec\u00f6\u00c4\ufffd?\u00d2\u00dc\u00c2\u00d6\u00cc?\u00df\u00d3/\u00f2\u00f3:#\\\u00ed\ufffd?~*\u00c9'\u00e9,\u00b4\u00c0\u00e0".charAt(rng.nextInt("abc\u00eb\u00d9d\u00c0\u00ffe\u0152f\u00fag\u00cb\u00db\u00f9hij\u00e0\u00cak\u00c7l\u0178m\u0153\ufffd?\u00e7\u00dan\u00d4\u00c8o\u00e6\u00fb\u00e8p\u00bb\u00d9\u00c8q\u00f9\u00f4\u00ea\u00ee\u00ef\u00c6rs\u00e2\u00c9t\u00e9\u00ceuvw\u00e8xyl\u00ef\u00e4\u00fc\u00ec\u00f6\u00c4\ufffd?\u00d2\u00dc\u00c2\u00d6\u00cc?\u00df\u00d3/\u00f2\u00f3:#\\\u00ed\ufffd?~*\u00c9'\u00e9,\u00b4\u00c0\u00e0".length()));
        }
        return new String(text);
    }

    public static boolean isEqual(Author a1, Author a2) {
        if (a1.getGln() != null && !a1.getGln().equals(a2.getGln())) {
            return false;
        }
        for (int i = 0; i < a1.getIds().size(); ++i) {
            if (TestUtils.isEqual((Identificator)a1.getIds().get(i), (Identificator)a2.getIds().get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(Code c1, Code c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 != null && c2 == null || c1 == null && c2 != null) {
            return false;
        }
        if (!c1.getCode().equals(c2.getCode())) {
            return false;
        }
        if (c1.getCodeSystem() != null ? !c1.getCodeSystem().equals(c2.getCodeSystem()) : c2.getCodeSystem() != null) {
            return false;
        }
        return !(c1.getDisplayName() != null ? !c1.getDisplayName().equals(c2.getDisplayName()) : c2.getDisplayName() != null);
    }

    public static boolean isEqual(Identificator i1, Identificator i2) {
        if (!i1.getRoot().equals(i2.getRoot())) {
            return false;
        }
        return i1.getExtension().equals(i2.getExtension());
    }

    public static boolean isEqual(Name n1, Name n2) {
        if (!n1.getPrefix().equals(n2.getPrefix())) {
            return false;
        }
        if (!n1.getGiven().equals(n2.getGiven())) {
            return false;
        }
        if (!n1.getFamily().equals(n2.getFamily())) {
            return false;
        }
        return n1.getSuffix().equals(n2.getSuffix());
    }

    public static boolean isEqual(Organization o1, Organization o2) {
        if (!o1.getPrimaryIdentificator().equals((Object)o2.getPrimaryIdentificator())) {
            return false;
        }
        if (!o1.getPrimaryName().equals((Object)o2.getPrimaryName())) {
            return false;
        }
        return TestUtils.isEquals(o1.getTelecomList(), o2.getTelecomList());
    }

    public static boolean isEqual(Patient p1, Patient p2) {
        if (!TestUtils.isEqual(p1.getName(), p2.getName())) {
            return false;
        }
        if (!TestUtils.isEqual(p1.getAdministrativeGenderCode().getCode(), p2.getAdministrativeGenderCode().getCode())) {
            return false;
        }
        return p1.getBirthday().getTime() == p1.getBirthday().getTime();
    }

    public static boolean isEqual(Telecom t1, Telecom t2) {
        if (t1 == null && t2 == null) {
            return true;
        }
        if (t1.getValue() == null && t2.getValue() == null && t1.getUsage() == null && t2.getUsage() == null) {
            return true;
        }
        if (t1.getValue() == null && t2.getValue() == null && t1.getUsage() != null && t1.getUsage().equals((Object)t2.getUsage())) {
            return true;
        }
        if (t1.getValue() != null && t1.getValue().equalsIgnoreCase(t2.getValue()) && t1.getUsage() == null && t2.getUsage() == null) {
            return true;
        }
        return t1.getValue().equals(t2.getValue()) && t1.getUsage().equals((Object)t2.getUsage());
    }

    public static boolean isEquals(List<TelecomBaseType> t1, List<TelecomBaseType> t2) {
        for (TelecomBaseType t : t1) {
            if (t == null || t2.contains(t)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(Value v1, Value v2) {
        if (v1.getCode() != null) {
            if (!TestUtils.isEqual(v1.getCode(), v2.getCode())) {
                return false;
            }
            if (!v1.isCode() == v2.isCode()) {
                return false;
            }
        }
        if (v1.getPhysicalQuantityUnit() != null) {
            if (!v1.getPhysicalQuantityUnit().equals(v2.getPhysicalQuantityUnit())) {
                return false;
            }
            if (!v1.isPhysicalQuantity() == v2.isPhysicalQuantity()) {
                return false;
            }
        }
        return v1.getPhysicalQuantityValue() == null || v1.getPhysicalQuantityValue().equals(v2.getPhysicalQuantityValue());
    }

    public TestUtils() {
        this.xpath = this.xpathFactory.newXPath();
    }

    public Address createAddress1() {
        Address a = new Address(new AddressBaseType());
        a.setStreetName("Baurat-Gerber-Str.");
        a.setBuildingNumber("18");
        a.setPostalCode("37073");
        a.setCity("G\u00f6ttingen");
        a.setUsage(PostalAddressUse.WORK_PLACE);
        return a;
    }

    public Author createAuthor1() {
        Author a = new Author(this.createName1(), this.numS1);
        return a;
    }

    public Author createAuthor2() {
        Author a = new Author(this.createName2(), this.numS2);
        return a;
    }

    public Code createCode1() {
        Code code = new Code(this.ts1, this.ts2, this.ts3);
        return code;
    }

    public Code createCode2() {
        Code code = new Code(this.ts5, this.ts4, this.ts3);
        return code;
    }

    public Code createGtinCode() {
        Code code = new Code(CodeSystems.GTIN.getCodeSystemId(), this.ts3, null);
        return code;
    }

    public Identificator createIdentificator1() {
        Identificator id = new Identificator();
        id.setRoot(CodeSystems.GLN.getCodeSystemId());
        id.setExtension(this.numS1);
        return id;
    }

    public Identificator createIdentificator2() {
        Identificator id = new Identificator();
        id.setRoot(CodeSystems.ICD10.getCodeSystemId());
        id.setExtension(this.numS2);
        return id;
    }

    public Name createName1() {
        Name n = new Name();
        n.setGiven(this.ts1);
        n.setFamily(this.ts2);
        n.setPrefix(this.ts3);
        n.setSuffix(this.ts4);
        return n;
    }

    public Name createName2() {
        Name n = new Name();
        n.setGiven(this.ts5);
        n.setFamily(this.ts4);
        n.setPrefix(this.ts3);
        n.setSuffix(this.ts2);
        return n;
    }

    public Organization createOrganization1() {
        Organization o = new Organization(new OrganizationBaseType());
        o.setPrimaryName(new NameBaseType());
        o.getPrimaryName().setName(this.ts1);
        o.setPrimaryIdentificator(new IdentificatorBaseType());
        o.getPrimaryIdentificator().setExtension(this.numS1);
        Telecom t1 = new Telecom();
        t1.setMail("testMail");
        t1.setUsage(TelecomAddressUse.BUSINESS);
        this.telecoms1.add((TelecomBaseType)t1);
        Telecom t2 = new Telecom();
        t2.setPhone(this.numS1);
        t2.setUsage(TelecomAddressUse.PRIVATE);
        this.telecoms1.add((TelecomBaseType)t2);
        o.setTelecomList(this.telecoms1);
        return o;
    }

    public Patient createPatient() {
        Patient patient = new Patient(this.createName1(), AdministrativeGender.FEMALE, (Calendar)this.createStartDate());
        patient.addAddress(this.createAddress1());
        patient.setBirthday((Calendar)this.createStartDate());
        List<TelecomBaseType> telecoms = this.createTelecoms1();
        for (TelecomBaseType telecom : telecoms) {
            patient.getTelecoms().add(new Telecom(telecom));
        }
        return patient;
    }

    public Performer createPerformer1() {
        Performer p = new Performer(this.createName1(), this.numS1);
        return p;
    }

    public Performer createPerformer2() {
        Performer p = new Performer(this.createName2(), this.numS2);
        return p;
    }

    public GregorianCalendar createStartDate() {
        return new GregorianCalendar(2014, 11, 15);
    }

    public List<TelecomBaseType> createTelecoms1() {
        LinkedList<TelecomBaseType> t = new LinkedList<TelecomBaseType>();
        Telecom t1 = new Telecom();
        t1.setMail(this.telS1);
        t1.setUsage(TelecomAddressUse.BUSINESS);
        t.add((TelecomBaseType)t1);
        Telecom t2 = new Telecom();
        t2.setMail(this.telS2);
        t2.setUsage(TelecomAddressUse.PRIVATE);
        t.add((TelecomBaseType)t2);
        Telecom t3 = new Telecom();
        t3.setFax(this.telS1);
        t3.setUsage(TelecomAddressUse.BUSINESS);
        t.add((TelecomBaseType)t3);
        Telecom t4 = new Telecom();
        t4.setFax(this.telS2);
        t4.setUsage(TelecomAddressUse.PRIVATE);
        t.add((TelecomBaseType)t4);
        Telecom t5 = new Telecom();
        t5.setPhone(this.telS1);
        t5.setUsage(TelecomAddressUse.BUSINESS);
        t.add((TelecomBaseType)t5);
        Telecom t6 = new Telecom();
        t6.setPhone(this.telS2);
        t6.setUsage(TelecomAddressUse.PRIVATE);
        t.add((TelecomBaseType)t6);
        return t;
    }

    protected Value createValue1() {
        Value value = new Value("500", "ml");
        return value;
    }

    protected Value createValue2() {
        Value value = new Value(this.ts1, this.ts2);
        return value;
    }

    public String getTempFilePath(String aFileName) {
        Object tmpPath = "";
        if (System.getProperty("java.io.tmpdir") != null) {
            tmpPath = System.getProperty("java.io.tmpdir");
        } else if (System.getenv("TMP") != null) {
            tmpPath = System.getenv("TMP");
        } else if (System.getenv("TEMP") != null) {
            tmpPath = System.getenv("TEMP");
        }
        tmpPath = (String)tmpPath + File.separator + aFileName;
        return tmpPath;
    }

    public void init() {
        this.startDateString = "28.02.2015";
        this.endDateString = "28.02.2018";
        this.startDate = new GregorianCalendar(2015, 1, 28);
        this.endDate = DateUtil.parseDateyyyyMMdd((String)"20180228");
        this.ts1 = TestUtils.generateString(129);
        this.ts2 = TestUtils.generateString(129);
        this.ts3 = TestUtils.generateString(129);
        this.ts4 = TestUtils.generateString(129);
        this.ts5 = TestUtils.generateString(129);
        this.numS1 = "1231425352";
        this.numS2 = "987653";
        this.number = 1.21241241212323E8;
        this.telS1 = "+41.32.234.66.77";
        this.telS2 = "+44.32.234.66.99";
        this.code1 = this.createCode1();
        this.code2 = this.createCode2();
        this.loincCode = new Code("2.16.840.1.113883.6.1", this.numS1, null);
        this.problemCode = new Code("2.16.840.1.113883.6.139", this.numS2, null);
        this.value1 = this.createValue1();
        this.value2 = this.createValue2();
        this.gtinCode = this.createGtinCode();
        this.id1 = this.createIdentificator1();
        this.id2 = this.createIdentificator2();
        this.telecoms1 = this.createTelecoms1();
        this.name1 = this.createName1();
        this.name2 = this.createName2();
        this.author1 = this.createAuthor1();
        this.author2 = this.createAuthor2();
        this.organization1 = this.createOrganization1();
        this.address1 = this.createAddress1();
        this.patient1 = this.createPatient();
    }

    public boolean xCount(Document document, String xPath, int numberOfElements) throws XPathExpressionException {
        XPathExpression expr = this.xpath.compile(xPath);
        NodeList nodes = (NodeList)expr.evaluate(document, XPathConstants.NODESET);
        return nodes.getLength() == numberOfElements;
    }

    public boolean xExist(Document document, String xPath) throws XPathExpressionException {
        XPathExpression expr = this.xpath.compile(xPath);
        NodeList nodes = (NodeList)expr.evaluate(document, XPathConstants.NODESET);
        return nodes.getLength() == 1;
    }

    public boolean xExistTemplateId(Document document, String templateIdRoot, String templateIdExtension) throws XPathExpressionException {
        if (templateIdExtension == null) {
            return this.xExist(document, "//templateId[@root='" + templateIdRoot + "']");
        }
        return this.xExist(document, "//templateId[@root='" + templateIdRoot + "' and @extension='" + templateIdExtension + "']");
    }
}

