/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.testhelper;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.hl7.fhir.r4.model.Identifier;
import org.projecthusky.fhir.structures.gen.FhirCommon;
import org.projecthusky.fhir.structures.gen.FhirPatient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryMockMpiAdapter {
    private static Map<String, FhirPatient> map = new HashMap<String, FhirPatient>();
    private static String mpiCommunityOid = UUID.randomUUID().toString();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String homeCommunityOid;

    public boolean addPatient(FhirPatient patient) {
        if (patient == null) {
            this.log.debug("patient is null");
            return false;
        }
        boolean retVal = false;
        String mpiIdendity = UUID.randomUUID().toString();
        String mapKey = this.getMapKey(patient);
        if (mapKey != null) {
            if (!map.containsKey(mapKey)) {
                FhirPatient immutablePatient = new FhirPatient();
                immutablePatient.setIdentifier(patient.getIdentifier());
                Identifier id = immutablePatient.addIdentifier();
                id.setSystem(FhirCommon.addUrnOid((String)mpiCommunityOid));
                id.setValue(mpiIdendity);
                map.put(mapKey, immutablePatient);
                this.log.info("added patient to mpi with key " + mapKey + " and mpi idendity " + mpiCommunityOid + "," + mpiIdendity);
                retVal = true;
            } else {
                this.log.error("patient exists already with  " + this.getHomeCommunityPatientId(patient));
            }
        } else {
            this.log.error("patient has no homeCommunityPatientId of " + this.getHomeCommunityPatientId(patient));
        }
        return retVal;
    }

    public void clear() {
        map = new HashMap<String, FhirPatient>();
    }

    private String getHomeCommunityPatientId(FhirPatient patient) {
        this.initHomeCommunityId(patient);
        return this.getPatientId(patient, FhirCommon.addUrnOid((String)this.homeCommunityOid));
    }

    private String getMapKey(FhirPatient patient) {
        String homeCommunityPatientId = this.getHomeCommunityPatientId(patient);
        if (homeCommunityPatientId == null) {
            return null;
        }
        return this.getMapKey(homeCommunityPatientId);
    }

    private String getMapKey(String homeCommunityPatientId) {
        return this.homeCommunityOid + "-" + homeCommunityPatientId;
    }

    private String getMpiPatientId(FhirPatient patient) {
        this.initHomeCommunityId(patient);
        return this.getPatientId(patient, FhirCommon.addUrnOid((String)mpiCommunityOid));
    }

    private String getPatientId(FhirPatient patient, String system) {
        this.initHomeCommunityId(patient);
        for (Identifier Identifier2 : patient.getIdentifier()) {
            if (!Identifier2.getSystem().equals(system)) continue;
            return Identifier2.getValue();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initHomeCommunityId(FhirPatient patient) {
        if (this.homeCommunityOid != null) return;
        if (patient.getIdentifier().size() != 1) throw new IllegalStateException("homeCommunityId has to be specified");
        String system = ((Identifier)patient.getIdentifier().get(0)).getSystem();
        if (system.length() <= 8) throw new IllegalStateException("system has to start with urn:oid:");
        this.homeCommunityOid = system.substring(8);
    }

    public boolean mergePatient(FhirPatient patient, String obsoleteId) {
        if (patient == null || obsoleteId == null) {
            this.log.debug("patient or obosoleId is null");
            return false;
        }
        String mapKey = this.getMapKey(obsoleteId);
        if (mapKey != null) {
            if (map.containsKey(mapKey)) {
                map.put(mapKey, patient);
                return true;
            }
            this.log.error("patient not found in mpi " + String.valueOf(patient));
        } else {
            this.log.error("no patient id provided " + String.valueOf(patient));
        }
        return false;
    }

    public String queryPatientId(FhirPatient patient) {
        return this.queryPatientId(patient, null, null)[0];
    }

    public String[] queryPatientId(FhirPatient patient, String[] queryDomainOids, String[] queryDomainNamespaces) {
        String[] domainOids = null;
        domainOids = queryDomainOids != null ? queryDomainOids : new String[]{mpiCommunityOid};
        if (patient == null) {
            this.log.debug("patient is null");
            return null;
        }
        String mapKey = this.getMapKey(patient);
        if (mapKey != null) {
            if (map.containsKey(mapKey)) {
                FhirPatient patientMpi = map.get(mapKey);
                String[] returnIds = new String[domainOids.length];
                for (int i = 0; i < returnIds.length; ++i) {
                    returnIds[i] = this.getPatientId(patientMpi, FhirCommon.addUrnOid((String)domainOids[i]));
                }
                return returnIds;
            }
            this.log.error("patient not found in mpi " + String.valueOf(patient));
        } else {
            this.log.error("no patient id provided " + String.valueOf(patient));
        }
        return null;
    }

    public boolean updatePatient(FhirPatient patient) {
        if (patient == null) {
            this.log.debug("patient is null");
            return false;
        }
        String mapKey = this.getMapKey(patient);
        if (mapKey != null) {
            if (map.containsKey(mapKey)) {
                FhirPatient oldPatient = map.get(mapKey);
                FhirPatient immutablePatient = new FhirPatient();
                immutablePatient.setIdentifier(patient.getIdentifier());
                Identifier id = immutablePatient.addIdentifier();
                id.setSystem(FhirCommon.addUrnOid((String)mpiCommunityOid));
                id.setValue(this.getMpiPatientId(oldPatient));
                map.put(mapKey, immutablePatient);
                return true;
            }
            this.log.error("patient not found in mpi " + String.valueOf(patient));
        } else {
            this.log.error("no patient id provided " + String.valueOf(patient));
        }
        return false;
    }
}

