/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.mpi.impl.pdq;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import net.ihe.gazelle.hl7v3.prpain201306UV02.PRPAIN201306UV02Type;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.StringType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projecthusky.common.communication.AffinityDomain;
import org.projecthusky.common.communication.Destination;
import org.projecthusky.communication.mpi.impl.PdqV3Query;
import org.projecthusky.communication.mpi.impl.pdq.V3PdqConsumerResponse;
import org.projecthusky.fhir.structures.gen.FhirCommon;
import org.projecthusky.fhir.structures.gen.FhirPatient;

public class PdqV3QueryTest {
    private V3PdqConsumerResponse loadV3PdqResponse() throws Exception {
        try (FileInputStream inputStream = new FileInputStream("src/test/resources/02_PDQQuery1Response.xml");){
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{PRPAIN201306UV02Type.class}).createUnmarshaller();
            PRPAIN201306UV02Type rootElement = (PRPAIN201306UV02Type)unmarshaller.unmarshal((InputStream)inputStream);
            V3PdqConsumerResponse v3PdqConsumerResponse = new V3PdqConsumerResponse(rootElement);
            return v3PdqConsumerResponse;
        }
    }

    @Test
    void testGetPatientsFromPdqQuery() throws Exception {
        AffinityDomain affinityDomain = new AffinityDomain();
        Destination dest = new Destination();
        dest.setUri(URI.create(""));
        dest.setSenderApplicationOid("");
        dest.setReceiverApplicationOid("");
        dest.setReceiverFacilityOid("");
        affinityDomain.setPdqDestination(dest);
        affinityDomain.setPixDestination(dest);
        V3PdqConsumerResponse response = this.loadV3PdqResponse();
        Assertions.assertNotNull((Object)response);
        PdqV3Query v3PdqQuery = new PdqV3Query(affinityDomain, null, null, null);
        List patients = v3PdqQuery.getPatientsFromPdqQuery(response);
        Assertions.assertEquals((int)2, (int)patients.size());
        FhirPatient james = (FhirPatient)patients.get(0);
        Assertions.assertEquals((Object)"Jones", (Object)james.getNameFirstRep().getFamily());
        Assertions.assertEquals((Object)"James", (Object)james.getNameFirstRep().getGivenAsSingleString());
        Assertions.assertEquals((Object)"work", (Object)((ContactPoint)james.getTelecom().get(0)).getUse().toCode().toLowerCase());
        Assertions.assertEquals((Object)"+1-481-555-7684;ext=2342", (Object)((ContactPoint)james.getTelecom().get(0)).getValue());
        Assertions.assertEquals((Object)"home", (Object)((ContactPoint)james.getTelecom().get(1)).getUse().toCode().toLowerCase());
        Assertions.assertEquals((Object)"+1-765-555-4352", (Object)((ContactPoint)james.getTelecom().get(1)).getValue());
        Assertions.assertEquals((Object)"male", (Object)james.getGender().toCode().toLowerCase());
        Assertions.assertEquals((Object)"1963-08-04", (Object)james.getBirthDateElement().getValueAsString());
        Assertions.assertEquals((Object)"3443 North Arctic Avenue", (Object)((StringType)james.getAddressFirstRep().getLine().get(0)).getValue());
        Assertions.assertEquals((Object)"Some City", (Object)james.getAddressFirstRep().getCity());
        Assertions.assertEquals((Object)"IL", (Object)james.getAddressFirstRep().getState());
        Assertions.assertEquals((Object)FhirCommon.addUrnOid((String)"1.2.840.114350.1.13.99998.8734"), (Object)james.getIdentifierFirstRep().getSystem());
        Assertions.assertEquals((Object)"34827K410", (Object)james.getIdentifierFirstRep().getValue());
        Assertions.assertEquals((Object)FhirCommon.addUrnOid((String)"1.2.840.114350.1.13.99997.2.3412"), (Object)((Identifier)james.getIdentifier().get(1)).getSystem());
        Assertions.assertEquals((Object)"38273D433", (Object)((Identifier)james.getIdentifier().get(1)).getValue());
        Assertions.assertEquals((Object)FhirCommon.addUrnOid((String)"2.16.840.1.113883.4.1"), (Object)((Identifier)james.getIdentifier().get(2)).getSystem());
        Assertions.assertEquals((Object)"999-88-6345", (Object)((Identifier)james.getIdentifier().get(2)).getValue());
        Assertions.assertNotNull((Object)james.getManagingOrganization().getResource());
        Organization organization = (Organization)james.getManagingOrganization().getResource();
        Assertions.assertEquals((Object)FhirCommon.addUrnOid((String)"1.2.840.114350.1.13.99998.8734"), (Object)((Identifier)organization.getIdentifier().get(0)).getValue());
        Assertions.assertEquals((Object)"Good Health Clinic", (Object)organization.getName());
        Assertions.assertEquals((Object)"+1-342-555-8394", (Object)organization.getTelecomFirstRep().getValue());
    }
}

