/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.projecthusky.common.communication.SubmissionSetMetadata;
import org.projecthusky.common.model.Author;
import org.projecthusky.common.model.Code;
import org.projecthusky.communication.testhelper.TestUtils;

class SubmissionSetMetadataTest
extends TestUtils {
    private SubmissionSetMetadata s;

    SubmissionSetMetadataTest() {
    }

    @BeforeEach
    public void initTestData() {
        this.s = new SubmissionSetMetadata();
        this.ts1 = TestUtils.generateString(129);
        this.ts2 = TestUtils.generateString(129);
        this.ts3 = TestUtils.generateString(129);
        this.ts4 = TestUtils.generateString(129);
        this.ts5 = TestUtils.generateString(129);
        this.numS1 = "1231425352";
        this.numS2 = "987653";
        this.number = 1.21241241212323E8;
        this.code1 = this.createCode1();
        this.code2 = this.createCode2();
        this.loincCode = new Code("2.16.840.1.113883.6.1", this.numS1, null);
        this.author1 = this.createAuthor1();
        this.id1 = this.createIdentificator1();
    }

    @Test
    void testAuthor() {
        this.s.setAuthor(this.author1);
        Assertions.assertTrue((boolean)SubmissionSetMetadataTest.isEqual(this.author1, (Author)this.s.getAuthor().get(0)));
    }

    @Test
    void testAvailabilityStatus() {
        this.s.setAvailabilityStatus(AvailabilityStatus.DEPRECATED);
        Assertions.assertEquals((Object)AvailabilityStatus.DEPRECATED, (Object)this.s.getAvailabilityStatus());
    }

    @Test
    void testComments() {
        this.s.setComments(this.ts1);
        Assertions.assertEquals((Object)this.ts1, (Object)this.s.getComments());
    }

    @Test
    void testContentType() {
        this.s.setContentTypeCode(this.code1);
        Assertions.assertTrue((boolean)SubmissionSetMetadataTest.isEqual(this.code1, this.s.getContentTypeCode()));
    }

    @Test
    void testPatientId() {
        this.s.setDestinationPatientId(this.id1);
        Assertions.assertTrue((boolean)SubmissionSetMetadataTest.isEqual(this.id1, this.s.getPatientId()));
    }

    @Test
    void testSourceId() {
        this.s.setSourceId(this.numS2);
        Assertions.assertEquals((Object)this.numS2, (Object)this.s.getSourceId());
    }

    @Test
    void testTitle() {
        this.s.setTitle(this.ts2);
        Assertions.assertEquals((Object)this.ts2, (Object)this.s.getTitle());
    }
}

