/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.communication.FolderMetadata;

class FolderMetadataTest {
    private AvailabilityStatus testAvailabilityStatus1;
    private AvailabilityStatus testAvailabilityStatus2;
    private List<Code> testCodeList;
    private Code testCode1;
    private Code testCode2;
    private String testComments;
    private String testEntryUUID1;
    private String testEntryUUID2;
    private ZonedDateTime testLastUpdateTime;
    private Identificator testPatientId;
    private String testTitle1;
    private String testTitle2;
    private String testUniqueId1;
    private String testUniqueId2;

    FolderMetadataTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.testAvailabilityStatus1 = AvailabilityStatus.APPROVED;
        this.testAvailabilityStatus2 = AvailabilityStatus.DEPRECATED;
        this.testCodeList = new ArrayList<Code>();
        this.testCode1 = new Code("1.2.3.4", "TestCode1", null);
        this.testCode2 = new Code("5.6.7.8", "TestCode2", null);
        this.testCodeList.add(this.testCode1);
        this.testCodeList.add(this.testCode2);
        this.testComments = "This is a testcomment for the unit test \u00c4\u00d6\u00dc\u00e4\u00f6\u00fc";
        this.testEntryUUID1 = UUID.randomUUID().toString();
        this.testEntryUUID2 = UUID.randomUUID().toString();
        this.testLastUpdateTime = ZonedDateTime.now(ZoneOffset.UTC);
        this.testPatientId = new Identificator("1.2.3.4", "1234.345.23456.2346");
        this.testTitle1 = "The Folder Title 1";
        this.testTitle2 = "The Folder Title to be tested to";
        this.testUniqueId1 = "1.2.3.9999";
        this.testUniqueId2 = "1.2.3.9999";
    }

    @Test
    void testAddCode() {
        FolderMetadata ref = new FolderMetadata();
        Assertions.assertNotNull((Object)ref.getCodeList());
        Assertions.assertEquals((int)0, (int)ref.getCodeList().size());
        ref.addCode(this.testCode1);
        Assertions.assertNotNull((Object)ref.getCodeList());
        Assertions.assertEquals((int)1, (int)ref.getCodeList().size());
        Assertions.assertEquals((Object)this.testCode1, ref.getCodeList().get(0));
        ref.addCode(this.testCode2);
        Assertions.assertNotNull((Object)ref.getCodeList());
        Assertions.assertEquals((int)2, (int)ref.getCodeList().size());
        Assertions.assertEquals((Object)this.testCode2, ref.getCodeList().get(1));
    }

    @Test
    void testSetAvailabilityStatus() {
        FolderMetadata ref = new FolderMetadata();
        Assertions.assertNull((Object)ref.getAvailabilityStatus());
        ref.setAvailabilityStatus(this.testAvailabilityStatus1);
        Assertions.assertEquals((Object)this.testAvailabilityStatus1, (Object)ref.getAvailabilityStatus());
        ref.setAvailabilityStatus(this.testAvailabilityStatus2);
        Assertions.assertEquals((Object)this.testAvailabilityStatus2, (Object)ref.getAvailabilityStatus());
    }

    @Test
    void testSetGetCodeList() {
        FolderMetadata ref = new FolderMetadata();
        Assertions.assertNotNull((Object)ref.getCodeList());
        Assertions.assertEquals((int)0, (int)ref.getCodeList().size());
        ref.setCodeList(this.testCodeList);
        Assertions.assertNotNull((Object)ref.getCodeList());
        Assertions.assertEquals((int)2, (int)ref.getCodeList().size());
        Assertions.assertEquals((Object)this.testCode1, ref.getCodeList().get(0));
        Assertions.assertEquals((Object)this.testCode2, ref.getCodeList().get(1));
    }

    @Test
    void testSetGetComments() {
        FolderMetadata ref = new FolderMetadata();
        Assertions.assertNull((Object)ref.getComments());
        ref.setComments(this.testComments);
        Assertions.assertEquals((Object)this.testComments, (Object)ref.getComments());
    }

    @Test
    void testSetGetEntryUUID() {
        FolderMetadata ref = new FolderMetadata();
        Assertions.assertNull((Object)ref.getEntryUUID());
        ref.setEntryUUID(this.testEntryUUID1);
        Assertions.assertEquals((Object)this.testEntryUUID1, (Object)ref.getEntryUUID());
        Assertions.assertNotEquals((Object)this.testEntryUUID2, (Object)ref.getEntryUUID());
        ref.setEntryUUID(this.testEntryUUID2);
        Assertions.assertNotEquals((Object)this.testEntryUUID1, (Object)ref.getEntryUUID());
        Assertions.assertEquals((Object)this.testEntryUUID2, (Object)ref.getEntryUUID());
    }

    @Test
    void testSetGetLastUpdateTime() {
        FolderMetadata ref = new FolderMetadata();
        ref.setLastUpdateTime(this.testLastUpdateTime);
        Assertions.assertEquals((Object)this.testLastUpdateTime.toInstant(), (Object)ref.getLastUpdateTime().toInstant());
    }

    @Test
    void testSetGetPatientId() {
        FolderMetadata ref = new FolderMetadata();
        Assertions.assertNull((Object)ref.getPatientId());
        ref.setPatientId(this.testPatientId);
        Assertions.assertEquals((Object)this.testPatientId, (Object)ref.getPatientId());
    }

    @Test
    void testSetGetTitle() {
        FolderMetadata ref = new FolderMetadata();
        Assertions.assertNull((Object)ref.getTitle());
        ref.setTitle(this.testTitle1);
        Assertions.assertEquals((Object)this.testTitle1, (Object)ref.getTitle());
        ref.setTitle(this.testTitle2);
        Assertions.assertEquals((Object)this.testTitle2, (Object)ref.getTitle());
    }

    @Test
    void testSetGetUniqueId() {
        FolderMetadata ref = new FolderMetadata();
        Assertions.assertNull((Object)ref.getUniqueId());
        ref.setUniqueId(this.testUniqueId1);
        Assertions.assertEquals((Object)this.testUniqueId1, (Object)ref.getUniqueId());
        ref.setUniqueId(this.testUniqueId2);
        Assertions.assertEquals((Object)this.testUniqueId2, (Object)ref.getUniqueId());
    }
}

