/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication;

import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.LocalizedString;
import org.projecthusky.common.communication.DocumentMetadata;
import org.projecthusky.common.model.Author;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Patient;
import org.projecthusky.communication.testhelper.TestUtils;

class DocumentMetadataTest
extends TestUtils {
    private DocumentMetadata d = new DocumentMetadata();
    private LocalizedString l;
    private DocumentEntry m = this.d.getDocumentEntry();

    DocumentMetadataTest() {
    }

    @BeforeEach
    public void initTestData() {
        super.init();
        this.ts1 = TestUtils.generateString(129);
        this.ts2 = TestUtils.generateString(129);
        this.ts3 = TestUtils.generateString(129);
        this.ts4 = TestUtils.generateString(129);
        this.ts5 = TestUtils.generateString(129);
        this.numS1 = "1231425352";
        this.numS2 = "987653";
        this.number = 1.21241241212323E8;
        this.code1 = this.createCode1();
        this.code2 = this.createCode2();
        this.loincCode = new Code("2.16.840.1.113883.6.1", this.numS1, null);
    }

    @Test
    void testAuthor() {
        this.author1 = this.createAuthor1();
        this.d.addAuthor(this.author1);
        Assertions.assertTrue((boolean)DocumentMetadataTest.isEqual(this.author1, (Author)this.d.getAuthors().get(0)));
    }

    @Test
    void testClassCode() {
        Code cc = new Code("DEMO-Consult", "1.3.6.1.4.1.21367.100.1", "Consultation");
        this.d.setClassCode(cc);
        Assertions.assertEquals((Object)"1.3.6.1.4.1.21367.100.1", (Object)this.m.getClassCode().getSchemeName());
        Assertions.assertEquals((Object)"DEMO-Consult", (Object)this.m.getClassCode().getCode());
        this.l = this.m.getClassCode().getDisplayName();
        Assertions.assertEquals((Object)"Consultation", (Object)this.l.getValue());
        Assertions.assertTrue((boolean)DocumentMetadataTest.isEqual(cc, this.d.getClassCode()));
    }

    @Test
    void testCodedLanguage() {
        this.d.setCodedLanguage("de-CH");
        Assertions.assertEquals((Object)"de-CH", (Object)this.m.getLanguageCode());
    }

    @Test
    void testCreationTime() {
        Date creationTime = this.createStartDate().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssXXX");
        System.out.println(sdf.format(creationTime));
        System.out.println(ZonedDateTime.parse(sdf.format(creationTime), DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault())));
        this.d.setCreationTime(ZonedDateTime.parse(sdf.format(creationTime), DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault())));
        Assertions.assertEquals((Object)sdf.format(creationTime), (Object)this.d.getCreationTime().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault())));
    }

    @Test
    void testFormatCode() {
        Code fc = new Code("urn:ihe:iti:xds-sd:pdf:2008", "1.3.6.1.4.1.19376.1.2.3", "1.3.6.1.4.1.19376.1.2.20 (Scanned Document)");
        this.d.setFormatCode(fc);
        Assertions.assertEquals((Object)"1.3.6.1.4.1.19376.1.2.3", (Object)this.m.getFormatCode().getSchemeName());
        Assertions.assertEquals((Object)"urn:ihe:iti:xds-sd:pdf:2008", (Object)this.m.getFormatCode().getCode());
        this.l = this.m.getFormatCode().getDisplayName();
        Assertions.assertEquals((Object)"1.3.6.1.4.1.19376.1.2.20 (Scanned Document)", (Object)this.l.getValue());
        Assertions.assertTrue((boolean)DocumentMetadataTest.isEqual(fc, this.d.getFormatCode()));
    }

    @Test
    void testHealthcareFacilityTypeCode() {
        Code hftc = new Code("AMB", "2.16.840.1.113883.5.11", "Ambulance");
        this.d.setHealthcareFacilityTypeCode(hftc);
        Assertions.assertEquals((Object)"2.16.840.1.113883.5.11", (Object)this.m.getHealthcareFacilityTypeCode().getSchemeName());
        Assertions.assertEquals((Object)"AMB", (Object)this.m.getHealthcareFacilityTypeCode().getCode());
        this.l = this.m.getHealthcareFacilityTypeCode().getDisplayName();
        Assertions.assertEquals((Object)"Ambulance", (Object)this.l.getValue());
        Assertions.assertTrue((boolean)DocumentMetadataTest.isEqual(hftc, this.d.getHealthcareFacilityTypeCode()));
    }

    @Test
    void testMimeType() {
        this.numS1 = DocumentMetadataTest.generateString(128);
        this.d.setMimeType(this.numS1);
        Assertions.assertEquals((Object)this.numS1, (Object)this.d.getMimeType());
    }

    @Test
    void testPatient() {
        Patient p = this.createPatient();
        this.d.setPatient(p);
        Assertions.assertTrue((boolean)DocumentMetadataTest.isEqual(p, this.d.getPatient()));
    }

    @Test
    void testPatientId() {
        Identificator id = new Identificator("1.3.6.1.4.1.21367.2005.13.20.3000", "b8a9a9ad17b5429");
        this.d.setDestinationPatientId(id);
        Assertions.assertEquals((Object)"1.3.6.1.4.1.21367.2005.13.20.3000", (Object)this.m.getPatientId().getAssigningAuthority().getUniversalId());
        Assertions.assertEquals((Object)"b8a9a9ad17b5429", (Object)this.m.getPatientId().getId());
        Assertions.assertTrue((boolean)DocumentMetadataTest.isEqual(id, this.d.getPatientId()));
    }

    @Test
    void testPracticeSettingCode() {
        Code psc = new Code("394802001", "2.16.840.1.113883.6.96", "General Medicine");
        this.d.setPracticeSettingCode(psc);
        Assertions.assertEquals((Object)"2.16.840.1.113883.6.96", (Object)this.m.getPracticeSettingCode().getSchemeName());
        Assertions.assertEquals((Object)"394802001", (Object)this.m.getPracticeSettingCode().getCode());
        this.l = this.m.getPracticeSettingCode().getDisplayName();
        Assertions.assertEquals((Object)"General Medicine", (Object)this.l.getValue());
        Assertions.assertTrue((boolean)DocumentMetadataTest.isEqual(psc, this.d.getPracticeSettingCode()));
    }

    @Test
    void testSourcePatientId() {
        this.id1 = this.createIdentificator1();
        this.d.setSourcePatientId(this.id1);
        Assertions.assertTrue((boolean)DocumentMetadataTest.isEqual(this.id1, this.d.getSourcePatientId()));
    }

    @Test
    void testTitle() {
        this.d.setTitle(this.numS1);
        Assertions.assertEquals((Object)this.numS1, (Object)this.d.getTitle());
    }

    @Test
    void testTypeCode() {
        Code tc = new Code("34133-9", "2.16.840.1.113883.6.1", "Summarization of Episode Note");
        this.d.setTypeCode(tc);
        Assertions.assertEquals((Object)"2.16.840.1.113883.6.1", (Object)this.m.getTypeCode().getSchemeName());
        Assertions.assertEquals((Object)"34133-9", (Object)this.m.getTypeCode().getCode());
        this.l = this.m.getTypeCode().getDisplayName();
        Assertions.assertEquals((Object)"Summarization of Episode Note", (Object)this.l.getValue());
        Assertions.assertTrue((boolean)DocumentMetadataTest.isEqual(tc, this.d.getTypeCode()));
    }

    @Test
    void testUniqueId() {
        this.d.setUniqueId(this.numS2);
        Assertions.assertEquals((Object)this.numS2, (Object)this.d.getUniqueId());
    }
}

