/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication;

import java.net.URI;
import java.net.URISyntaxException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.projecthusky.common.communication.Destination;

class DestinationTest {
    public static final String NIST = "http://test.url";
    public static final String NIST_SECURED = "https://test.url";
    public static final String KEY_STORE = "docConsumer/security/keystore.jks";
    public static final String KEY_STORE_PASS = "nistbill";
    public static final String TRUST_STORE = "docConsumer/security/keystore.jks";
    public static final String TRUST_STORE_PASS = "nistbill";
    public static final String ORGANIZATIONAL_ID = "1.3.6.1.4.1.21367.2010.1.2.666";
    public static final String pdfFilePath = "./rsc/patientconsent.pdf";
    public static final String cdaFilePath = "./rsc/CDA-CH-VACD_Impfausweis.xml";
    URI repUri = null;
    URI u1 = null;
    URI u2 = null;

    DestinationTest() {
    }

    @BeforeEach
    public void init() {
        try {
            this.repUri = new URI(NIST_SECURED);
            this.u1 = new URI("https://foo.bar:9090");
            this.u2 = new URI("http://eheahlt-connector.org");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Test
    void testKeyStoreConstructor() {
        Destination dest = new Destination(ORGANIZATIONAL_ID, this.repUri, "docConsumer/security/keystore.jks", "nistbill");
        Assertions.assertEquals((Object)ORGANIZATIONAL_ID, (Object)dest.getSenderOrganizationalOid());
        Assertions.assertEquals((Object)this.repUri, (Object)dest.getUri());
        Assertions.assertEquals((Object)"docConsumer/security/keystore.jks", (Object)dest.getKeyStore());
        Assertions.assertEquals((Object)"nistbill", (Object)dest.getKeyStorePassword());
        Assertions.assertEquals((Object)"docConsumer/security/keystore.jks", (Object)dest.getTrustStore());
        Assertions.assertEquals((Object)"nistbill", (Object)dest.getTrustStorePassword());
    }

    @Test
    void testKeyStoreTrustStoreConstructor() {
        Destination dest = new Destination(ORGANIZATIONAL_ID, this.repUri, "docConsumer/security/keystore.jks", "nistbill", "docConsumer/security/keystore.jks", "nistbill");
        Assertions.assertEquals((Object)ORGANIZATIONAL_ID, (Object)dest.getSenderOrganizationalOid());
        Assertions.assertEquals((Object)this.repUri, (Object)dest.getUri());
        Assertions.assertEquals((Object)"docConsumer/security/keystore.jks", (Object)dest.getKeyStore());
        Assertions.assertEquals((Object)"nistbill", (Object)dest.getKeyStorePassword());
        Assertions.assertEquals((Object)"docConsumer/security/keystore.jks", (Object)dest.getTrustStore());
        Assertions.assertEquals((Object)"nistbill", (Object)dest.getTrustStorePassword());
    }

    @Test
    void testSetterGetter() {
        Destination dest = new Destination();
        dest.setKeyStore("docConsumer/security/keystore.jks");
        Assertions.assertEquals((Object)"docConsumer/security/keystore.jks", (Object)dest.getKeyStore());
        dest.setKeyStorePassword("nistbill");
        Assertions.assertEquals((Object)"nistbill", (Object)dest.getKeyStorePassword());
        dest.setUri(this.u1);
        Assertions.assertEquals((Object)this.u1, (Object)dest.getUri());
        dest.setUri(this.u2);
        Assertions.assertEquals((Object)this.u2, (Object)dest.getUri());
        dest.setReceiverApplicationOid("1");
        Assertions.assertEquals((Object)"1", (Object)dest.getReceiverApplicationOid());
        dest.setReceiverFacilityOid(ORGANIZATIONAL_ID);
        Assertions.assertEquals((Object)ORGANIZATIONAL_ID, (Object)dest.getReceiverFacilityOid());
        dest.setUri(this.repUri);
        Assertions.assertEquals((Object)this.repUri, (Object)dest.getUri());
        dest.setSenderApplicationOid(ORGANIZATIONAL_ID);
        Assertions.assertEquals((Object)ORGANIZATIONAL_ID, (Object)dest.getSenderApplicationOid());
        dest.setSenderOrganizationalOid(ORGANIZATIONAL_ID);
        Assertions.assertEquals((Object)ORGANIZATIONAL_ID, (Object)dest.getSenderOrganizationalOid());
        dest.setTrustStore("docConsumer/security/keystore.jks");
        Assertions.assertEquals((Object)"docConsumer/security/keystore.jks", (Object)dest.getTrustStore());
        dest.setTrustStorePassword("nistbill");
        Assertions.assertEquals((Object)"nistbill", (Object)dest.getTrustStorePassword());
    }
}

