/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.xd.storedquery;

import java.util.List;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.StoredQuery;
import org.projecthusky.common.ch.enums.stable.ConfidentialityCode;
import org.projecthusky.common.enums.DateTimeRangeAttributes;
import org.projecthusky.common.enums.ValueSetEnumInterface;
import org.projecthusky.common.model.Author;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.utils.XdsMetadataUtil;
import org.projecthusky.communication.ch.enums.stable.ClassCode;
import org.projecthusky.communication.ch.enums.stable.FormatCode;
import org.projecthusky.communication.ch.enums.stable.HealthcareFacilityTypeCode;
import org.projecthusky.communication.ch.enums.stable.PracticeSettingCode;
import org.projecthusky.communication.xd.storedquery.AbstractStoredQuery;
import org.projecthusky.communication.xd.storedquery.DateTimeRange;

public class FindDocumentsQuery
extends AbstractStoredQuery {
    private org.openehealth.ipf.commons.ihe.xds.core.requests.query.FindDocumentsQuery ipfStoredQuery = new org.openehealth.ipf.commons.ihe.xds.core.requests.query.FindDocumentsQuery();

    public FindDocumentsQuery(Identificator patientId, org.projecthusky.communication.ch.enums.AvailabilityStatus status) {
        this.ipfStoredQuery.setPatientId(XdsMetadataUtil.convertEhcIdentificator((Identificator)patientId));
        this.ipfStoredQuery.setStatus(List.of(AvailabilityStatus.valueOfOpcode((String)status.getCodeValue())));
    }

    public FindDocumentsQuery(Identificator patientId, ClassCode[] classCodes, DateTimeRange[] dateTimeRanges, PracticeSettingCode[] practiceSettingCodes, HealthcareFacilityTypeCode[] healthCareFacilityCodes, ConfidentialityCode[] confidentialityCodes, FormatCode[] formatCodes, Author authorPerson, org.projecthusky.communication.ch.enums.AvailabilityStatus status) {
        this.ipfStoredQuery.setPatientId(XdsMetadataUtil.convertEhcIdentificator((Identificator)patientId));
        this.ipfStoredQuery.setClassCodes(XdsMetadataUtil.convertEhcCodeToCode((ValueSetEnumInterface[])classCodes));
        this.ipfStoredQuery.setPracticeSettingCodes(XdsMetadataUtil.convertEhcCodeToCode((ValueSetEnumInterface[])practiceSettingCodes));
        this.ipfStoredQuery.setHealthcareFacilityTypeCodes(XdsMetadataUtil.convertEhcCodeToCode((ValueSetEnumInterface[])healthCareFacilityCodes));
        this.ipfStoredQuery.setConfidentialityCodes(XdsMetadataUtil.convertEhcCodeToQueryListCode((ValueSetEnumInterface[])confidentialityCodes));
        this.ipfStoredQuery.setFormatCodes(XdsMetadataUtil.convertEhcCodeToCode((ValueSetEnumInterface[])formatCodes));
        this.ipfStoredQuery.setStatus(List.of(AvailabilityStatus.valueOfOpcode((String)status.getCodeValue())));
        if (dateTimeRanges != null) {
            for (int index = 0; index < dateTimeRanges.length; ++index) {
                if (dateTimeRanges[index] == null) continue;
                if (dateTimeRanges[index].getDateTimeRangeAttribute().equals((Object)DateTimeRangeAttributes.SERVICE_START_TIME)) {
                    this.ipfStoredQuery.getServiceStartTime().setFrom(dateTimeRanges[index].getFromAsUsFormattedString());
                    this.ipfStoredQuery.getServiceStartTime().setTo(dateTimeRanges[index].getToAsUsFormattedString());
                    continue;
                }
                if (dateTimeRanges[index].getDateTimeRangeAttribute().equals((Object)DateTimeRangeAttributes.SERVICE_STOP_TIME)) {
                    this.ipfStoredQuery.getServiceStopTime().setFrom(dateTimeRanges[index].getFromAsUsFormattedString());
                    this.ipfStoredQuery.getServiceStopTime().setTo(dateTimeRanges[index].getToAsUsFormattedString());
                    continue;
                }
                if (!dateTimeRanges[index].getDateTimeRangeAttribute().equals((Object)DateTimeRangeAttributes.CREATION_TIME)) continue;
                this.ipfStoredQuery.getCreationTime().setFrom(dateTimeRanges[index].getFromAsUsFormattedString());
                this.ipfStoredQuery.getCreationTime().setTo(dateTimeRanges[index].getToAsUsFormattedString());
            }
        }
        org.openehealth.ipf.commons.ihe.xds.core.metadata.Author author = XdsMetadataUtil.converteHCAuthor((Author)authorPerson);
        this.ipfStoredQuery.setTypedAuthorPersons(List.of(author.getAuthorPerson()));
    }

    public void addConfidentialityCodes(ConfidentialityCode[] confidentialityCodes) {
        this.ipfStoredQuery.setConfidentialityCodes(XdsMetadataUtil.convertEhcCodeToQueryListCode((ValueSetEnumInterface[])confidentialityCodes));
    }

    public AvailabilityStatus getAsIpfAvailabilityStatusType(org.projecthusky.communication.ch.enums.AvailabilityStatus availabilityStatus) {
        switch (availabilityStatus) {
            case APPROVED: {
                return AvailabilityStatus.APPROVED;
            }
            case DEPRECATED: {
                return AvailabilityStatus.DEPRECATED;
            }
        }
        return AvailabilityStatus.APPROVED;
    }

    public StoredQuery getIpfQuery() {
        return this.ipfStoredQuery;
    }
}

