/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.enums.vacd.v140;

import org.openehealth.ipf.commons.ihe.xds.core.metadata.Code;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;
import org.projecthusky.common.utils.XdsMetadataUtil;

public enum FormatCode implements ValueSetEnumInterface
{
    EIMPFDOSSIER("urn:epd:2015:EPD_ImmunizationContent", "eImpfdossier"),
    EPD_DOKUMENT("urn:epd:2015:EPD_Basic_Document", "EPD Dokument"),
    KOS_DOKUMENT("urn:ihe:rad:1.2.840.10008.5.1.4.1.1.88.59", "KOS Dokument");

    public static final String EIMPFDOSSIER_CODE = "urn:epd:2015:EPD_ImmunizationContent";
    public static final String EPD_DOKUMENT_CODE = "urn:epd:2015:EPD_Basic_Document";
    public static final String KOS_DOKUMENT_CODE = "urn:ihe:rad:1.2.840.10008.5.1.4.1.1.88.59";
    public static final String CODE_SYSTEM_OID = "2.16.756.5.30.1.127.3.10.1.9";
    public static final String CODE_SYSTEM_NAME = "epd_xds_formatCode";
    private String code;
    private String displayName;

    public static FormatCode getEnum(String code) {
        for (FormatCode x : FormatCode.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(FormatCode.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(String codeValue) {
        for (FormatCode x : FormatCode.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private FormatCode(String code, String displayName) {
        this.code = code;
        this.displayName = displayName;
    }

    public org.projecthusky.common.model.Code getCode() {
        return new org.projecthusky.common.model.Code(this.code, CODE_SYSTEM_OID, this.displayName);
    }

    public Code getIpfCode() {
        Code cmt = new Code();
        cmt.setSchemeName(this.getCodeSystemId());
        cmt.setCode(this.getCodeValue());
        cmt.setDisplayName(XdsMetadataUtil.createInternationalString((String)this.getDisplayName(), (String)"de-ch"));
        return cmt;
    }

    public String getCodeSystemId() {
        return CODE_SYSTEM_OID;
    }

    public String getCodeSystemName() {
        return CODE_SYSTEM_NAME;
    }

    public String getCodeSystemOid() {
        return CODE_SYSTEM_OID;
    }

    public String getCodeValue() {
        return this.code;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayName(LanguageCode languageCode) {
        return this.displayName;
    }

    public String getValueSetId() {
        return null;
    }

    public String getValueSetName() {
        return null;
    }
}

