/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.enums.vacd.v140;

import org.openehealth.ipf.commons.ihe.xds.core.metadata.Code;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;
import org.projecthusky.common.utils.XdsMetadataUtil;

public enum ClassCode implements ValueSetEnumInterface
{
    ALERTS("DTC13", "Alerts"),
    CARE_PLANS("DTC12", "Care Plans"),
    CLINICAL_CARE_REFERRALS("DTC05", "Clinical Care Referrals"),
    DATA_FROM_PATIENT("DTC21", "Data from Patient"),
    DIAGNOSTIC_TEST_RESULTS("DTC08", "Diagnostic Test Results"),
    EPISODE_SUMMARY_REPORTS("DTC06", "Episode Summary Reports"),
    HISTORIC_OVERVIEWS("DTC10", "Historic Overviews"),
    NOTES_ON_CONSULTATIONS("DTC01", "Notes on Consultations"),
    NOTES_ON_PROCEDURES("DTC03", "Notes on Procedures"),
    NOTIFICATIONS("DTC09", "Notifications"),
    OTHER_COMPOSITION("DTC90", "Other Composition"),
    PRESENT_STATE_SUMMARIES("DTC11", "Present State Summaries"),
    PROGRESS_NOTES("DTC02", "Progress Notes"),
    PROGRESS_REPORTS("DTC07", "Progress Reports"),
    SCANNED_DOCUMENTS("DTC20", "Scanned Documents"),
    TESTSPROCEDURE_REQUESTS("DTC04", "Tests/Procedure Requests");

    public static final String ALERTS_CODE = "DTC13";
    public static final String CARE_PLANS_CODE = "DTC12";
    public static final String CLINICAL_CARE_REFERRALS_CODE = "DTC05";
    public static final String DATA_FROM_PATIENT_CODE = "DTC21";
    public static final String DIAGNOSTIC_TEST_RESULTS_CODE = "DTC08";
    public static final String EPISODE_SUMMARY_REPORTS_CODE = "DTC06";
    public static final String HISTORIC_OVERVIEWS_CODE = "DTC10";
    public static final String NOTES_ON_CONSULTATIONS_CODE = "DTC01";
    public static final String NOTES_ON_PROCEDURES_CODE = "DTC03";
    public static final String NOTIFICATIONS_CODE = "DTC09";
    public static final String OTHER_COMPOSITION_CODE = "DTC90";
    public static final String PRESENT_STATE_SUMMARIES_CODE = "DTC11";
    public static final String PROGRESS_NOTES_CODE = "DTC02";
    public static final String PROGRESS_REPORTS_CODE = "DTC07";
    public static final String SCANNED_DOCUMENTS_CODE = "DTC20";
    public static final String TESTSPROCEDURE_REQUESTS_CODE = "DTC04";
    public static final String CODE_SYSTEM_OID = "2.16.756.5.30.1.127.3.10.1.3";
    public static final String CODE_SYSTEM_NAME = "epd_xds_classCode";
    private String code;
    private String displayName;

    public static ClassCode getEnum(String code) {
        for (ClassCode x : ClassCode.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ClassCode.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    private ClassCode(String code, String displayName) {
        this.code = code;
        this.displayName = displayName;
    }

    public org.projecthusky.common.model.Code getCode() {
        org.projecthusky.common.model.Code ehcCode = new org.projecthusky.common.model.Code(this.code, CODE_SYSTEM_OID, this.displayName);
        return ehcCode;
    }

    public Code getIpfCode() {
        Code cmt = new Code();
        cmt.setSchemeName(this.getCodeSystemId());
        cmt.setCode(this.getCodeValue());
        cmt.setDisplayName(XdsMetadataUtil.createInternationalString((String)this.getDisplayName(), (String)"de-ch"));
        return cmt;
    }

    public String getCodeSystemId() {
        return CODE_SYSTEM_OID;
    }

    public String getCodeSystemName() {
        return CODE_SYSTEM_NAME;
    }

    public String getCodeSystemOid() {
        return CODE_SYSTEM_OID;
    }

    public String getCodeValue() {
        return this.code;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayName(LanguageCode languageCode) {
        return this.displayName;
    }

    public String getValueSetId() {
        return null;
    }

    public String getValueSetName() {
        return null;
    }

    public boolean isInValueSet(String codeValue) {
        for (ClassCode x : ClassCode.values()) {
            if (!x.getCodeValue().equals(this.code)) continue;
            return true;
        }
        return false;
    }
}

