/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.enums.stable;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum TypeCode implements ValueSetEnumInterface
{
    ALLERGY_RECORD("722446000", "2.16.840.1.113883.6.96", "Allergy record (record artifact)", "Allergy record", "Allergieausweis", "carnet des allergies", "passaporto delle allergie"),
    CONSULTATION_REPORT("371530004", "2.16.840.1.113883.6.96", "Clinical consultation report (record artifact)", "Consultation report", "Konsultationsbericht", "rapport de consultation", "rapporto di consultazione"),
    DISCHARGE_SUMMARY("373942005", "2.16.840.1.113883.6.96", "Discharge summary (record artifact)", "Discharge summary", "Austrittsbericht", "rapport de sortie", "rapporto di dimissione"),
    EMERGENCY_REPORT("445300006", "2.16.840.1.113883.6.96", "Emergency department record (record artifact)", "Emergency report", "Notfallbericht", "rapport d'urgence", "rapporto d'urgenza"),
    HISTORY_AND_PHYSICAL_REPORT("371529009", "2.16.840.1.113883.6.96", "History and physical report (record artifact)", "History and physical report", "Anamnese", "anamn\u00e8se", "anamnesi"),
    IMAGE("900000000000471006", "2.16.840.1.113883.6.96", "Image reference (foundation metadata concept)", "Image", "Bild", "image", "immagine"),
    IMAGING_ORDER("2161000195103", "2.16.756.5.30.1.127.3.4", "Imaging order (record artifact)", "Imaging Order", "Bildgebungsauftrag", "demande d'imagerie", "richiesta di immaginografia"),
    IMAGING_REPORT("4201000179104", "2.16.840.1.113883.6.96", "Imaging report (record artifact)", "Imaging report", "Bericht zur Bildgebung", "rapport sur l'imagerie", "referto di immaginografia"),
    IMMUNIZATION_RECORD("41000179103", "2.16.840.1.113883.6.96", "Immunization record (record artifact)", "Immunization record", "Impfdokument", "document de vaccination", "documento di vaccinazione"),
    LABORATORY_ORDER("721965002", "2.16.840.1.113883.6.96", "Laboratory order (record artifact)", "Laboratory Order", "Laborauftrag", "demande de laboratoire", "richiesta di laboratorio"),
    LABORATORY_REPORT("4241000179101", "2.16.840.1.113883.6.96", "Laboratory report (record artifact)", "Laboratory report", "Laborbericht", "rapport de laboratoire", "referto di laboratorio"),
    MEDICAL_CARE_PLAN("737427001", "2.16.840.1.113883.6.96", "Clinical management plan (record artifact)", "Medical care plan", "\u00c4rztlicher behandlungsplan", "plan de traitement m\u00e9dical", "piano di cure mediche"),
    MEDICAL_CERTIFICATE("772786005", "2.16.840.1.113883.6.96", "Medical certificate (record artifact)", "Medical certificate", "\u00c4rztliches Attest", "certificat m\u00e9dical", "certificato medico"),
    MEDICAL_PRESCRIPTION_RECORD("761938008", "2.16.840.1.113883.6.96", "Medicinal prescription record (record artifact)", "Medical Prescription record", "Arzneimittelrezept", "prescription de m\u00e9dicaments", "prescrizione di medicamenti"),
    MEDICATION_CARD_DOCUMENT("736378000", "2.16.840.1.113883.6.96", "Medication management plan (record artifact)", "Medication Card document", "Medikationsplan", "plan de m\u00e9dication", "piano dei medicamenti"),
    MEDICATION_DISPENSE("82291000195104", "2.16.756.5.30.1.127.3.4", "Medication dispense document (record artifact)", "Medication dispense", "Medikamentenabgabe", "dispense de m\u00e9dicaments", "dispensazione di medicamenti"),
    MEDICATION_LIST("721912009", "2.16.840.1.113883.6.96", "Medication summary document (record artifact)", "Medication list", "Medikationsliste", "liste des m\u00e9dicaments", "elenco dei medicamenti"),
    MEDICATION_TREATMENT_PLAN("761931002", "2.16.840.1.113883.6.96", "Medication treatment plan report (record artifact)", "Medication treatment plan", "Therapieentscheid Medikation", "plan de traitement medicament", "decisione di terapia medicament"),
    NON_DRUG_PRESCRIPTION("765492005", "2.16.840.1.113883.6.96", "Non-drug prescription record (record artifact)", "Non-drug prescription", "Nicht-Arzneimittel-Verschreibung", "prescription non m\u00e9dicamenteuse", "prescrizione non di medicamenti"),
    NON_MEDICAL_REPORT("445418005", "2.16.840.1.113883.6.96", "Professional allied to medicine clinical report (record artifact)", "Non-medical report", "Nichtmedizinischer Bericht", "rapport non m\u00e9dical", "rapporto non medico"),
    NURSING_CARE_PLAN("773130005", "2.16.840.1.113883.6.96", "Nursing care plan (record artifact)", "Nursing care plan", "Pflegeplan", "plan de soins infirmier", "piano di cure infermieristiche"),
    OPERATIVE_REPORT("371526002", "2.16.840.1.113883.6.96", "Operative report (record artifact)", "Operative report", "Operationsbericht", "rapport d'op\u00e9ration", "rapporto operatorio"),
    PATHOLOGY_ORDER("721966001", "2.16.840.1.113883.6.96", "Pathology order (record artifact)", "Pathology order", "Pathologieauftrag", "demande de pathologie", "richiesta di patologia"),
    PATHOLOGY_REPORT("371528001", "2.16.840.1.113883.6.96", "Pathology report (record artifact)", "Pathology report", "Pathologiebericht", "rapport de pathologie", "rapporto di patologia"),
    PICTURE_VIDEO_AUDIO("787148009", "2.16.840.1.113883.6.96", "Digital representation of specimen (record artifact)", "Picture/Video/Audio", "Bild/Video/Audio", "image/vid\u00e9o/audio", "immagine/video/audio"),
    PROGRESS_NOTE("371532007", "2.16.840.1.113883.6.96", "Progress report (record artifact)", "Progress note", "Verlaufsbericht", "rapport de suivi", "referto sul decorso"),
    RECORD_ARTIFACT("419891008", "2.16.840.1.113883.6.96", "Record artifact (record artifact)", "Record artifact", "Sonstige Dokumentation", "autre documentation", "altra documentazione"),
    REHABILITATION_CARE_PLAN("736055001", "2.16.840.1.113883.6.96", "Rehabilitation care plan (record artifact)", "Rehabilitation care plan", "Rehabilitationsplan", "plan de r\u00e9habilitation", "piano di riabilitazione"),
    TRANSFER_SUMMARY_REPORT("371535009", "2.16.840.1.113883.6.96", "Transfer summary report (record artifact)", "Transfer summary report", "\u00dcberweisungsbericht", "rapport de transfert", "rapporto di trasferimento");

    public static final String ALLERGY_RECORD_CODE = "722446000";
    public static final String CONSULTATION_REPORT_CODE = "371530004";
    public static final String DISCHARGE_SUMMARY_CODE = "373942005";
    public static final String EMERGENCY_REPORT_CODE = "445300006";
    public static final String HISTORY_AND_PHYSICAL_REPORT_CODE = "371529009";
    public static final String IMAGE_CODE = "900000000000471006";
    public static final String IMAGING_ORDER_CODE = "2161000195103";
    public static final String IMAGING_REPORT_CODE = "4201000179104";
    public static final String IMMUNIZATION_RECORD_CODE = "41000179103";
    public static final String LABORATORY_ORDER_CODE = "721965002";
    public static final String LABORATORY_REPORT_CODE = "4241000179101";
    public static final String MEDICAL_CARE_PLAN_CODE = "737427001";
    public static final String MEDICAL_CERTIFICATE_CODE = "772786005";
    public static final String MEDICAL_PRESCRIPTION_RECORD_CODE = "761938008";
    public static final String MEDICATION_CARD_DOCUMENT_CODE = "736378000";
    public static final String MEDICATION_DISPENSE_CODE = "82291000195104";
    public static final String MEDICATION_LIST_CODE = "721912009";
    public static final String MEDICATION_TREATMENT_PLAN_CODE = "761931002";
    public static final String NON_DRUG_PRESCRIPTION_CODE = "765492005";
    public static final String NON_MEDICAL_REPORT_CODE = "445418005";
    public static final String NURSING_CARE_PLAN_CODE = "773130005";
    public static final String OPERATIVE_REPORT_CODE = "371526002";
    public static final String PATHOLOGY_ORDER_CODE = "721966001";
    public static final String PATHOLOGY_REPORT_CODE = "371528001";
    public static final String PICTURE_VIDEO_AUDIO_CODE = "787148009";
    public static final String PROGRESS_NOTE_CODE = "371532007";
    public static final String RECORD_ARTIFACT_CODE = "419891008";
    public static final String REHABILITATION_CARE_PLAN_CODE = "736055001";
    public static final String TRANSFER_SUMMARY_REPORT_CODE = "371535009";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.3.10.1.27";
    public static final String VALUE_SET_NAME = "DocumentEntry.typeCode";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable TypeCode getEnum(@Nullable String code) {
        for (TypeCode x : TypeCode.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(TypeCode.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (TypeCode x : TypeCode.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private TypeCode(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

