/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.enums.stable;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum PracticeSettingCode implements ValueSetEnumInterface
{
    ACCIDENT_AND_EMERGENCY("394576009", "2.16.840.1.113883.6.96", "Accident &amp; emergency (qualifier value)", "Accident &amp; emergency", "Notfall- und Rettungsmedizin", "m\u00e9decine d'urgence et de sauvetage", "medicina d'urgenza e di salvataggio"),
    ANAESTHESIOLOGY("394577000", "2.16.840.1.113883.6.96", "Anesthetics (qualifier value)", "Anaesthesiology", "An\u00e4sthesiologie", "anesth\u00e9siologie", "anestesiologia"),
    CARDIAC_SURGERY("408466002", "2.16.840.1.113883.6.96", "Cardiac surgery (qualifier value)", "Cardiac surgery", "Herzchirurgie", "chirurgie cardiaque", "chirurgia cardiaca"),
    CARDIOLOGY("394579002", "2.16.840.1.113883.6.96", "Cardiology (qualifier value)", "Cardiology", "Kardiologie", "cardiologie", "cardiologia"),
    CHIROPRACTIC_SERVICE("722170006", "2.16.840.1.113883.6.96", "Chiropractic service (qualifier value)", "Chiropractic service", "Chiropraktik", "chiropractie", "chiropratica"),
    CLINICAL_GENETICS("394580004", "2.16.840.1.113883.6.96", "Clinical genetics (qualifier value)", "Clinical genetics", "Medizinische Genetik", "g\u00e9n\u00e9tique m\u00e9dicale", "genetica medica"),
    CLINICAL_HAEMATOLOGY("394803006", "2.16.840.1.113883.6.96", "Clinical hematology (qualifier value)", "Clinical haematology", "H\u00e4matologie", "h\u00e9matologie", "ematologia"),
    CLINICAL_IMMUNOLOGY("408480009", "2.16.840.1.113883.6.96", "Clinical immunology (qualifier value)", "Clinical immunology", "Immunologie", "immunologie", "immunologia"),
    CLINICAL_IMMUNOLOGY_ALLERGY("394805004", "2.16.840.1.113883.6.96", "Clinical immunology/allergy (qualifier value)", "Clinical immunology/allergy", "Immunologie/Allergologie", "immunologie/allergologie", "allergologia e immunologia clinica"),
    CLINICAL_ONCOLOGY("394592004", "2.16.840.1.113883.6.96", "Clinical oncology (qualifier value)", "Clinical oncology", "Onkologie", "oncologie", "oncologia medica"),
    CLINICAL_PHARMACOLOGY("394600006", "2.16.840.1.113883.6.96", "Clinical pharmacology (qualifier value)", "Clinical pharmacology", "Klinische Pharmakologie", "pharmacologie clinique", "farmacologia clinica"),
    COMPLEMENTARY_THERAPY("310025004", "2.16.840.1.113883.6.96", "Complementary therapy service (qualifier value)", "Complementary therapy", "Komplement\u00e4rmedizin", "m\u00e9decine alternative et compl\u00e9mentaire", "medicina complementare"),
    CRITICAL_CARE_MEDICINE("408478003", "2.16.840.1.113883.6.96", "Critical care medicine (qualifier value)", "Critical care medicine", "Intensivmedizin", "m\u00e9decine intensive", "medicina intensiva"),
    DENTAL_MEDICINE("394812008", "2.16.840.1.113883.6.96", "Dental medicine specialties (qualifier value)", "Dental medicine", "Zahnheilkunde", "odontologie", "odontoiatria"),
    DENTISTRY("722163006", "2.16.840.1.113883.6.96", "Dentistry (qualifier value)", "Dentistry", "Zahnmedizin", "dentisterie", "odontoiatria"),
    DERMATOLOGY("394582007", "2.16.840.1.113883.6.96", "Dermatology (qualifier value)", "Dermatology", "Dermatologie und Venerologie", "dermatologie et v\u00e9n\u00e9rologie", "dermatologia e venereologia"),
    DIETETICS_AND_NUTRITION("722164000", "2.16.840.1.113883.6.96", "Dietetics and nutrition (qualifier value)", "Dietetics and nutrition", "Ern\u00e4hrungsberatung", "conseil en nutrition et di\u00e9t\u00e9tique", "dietetica"),
    EMERGENCY_MEDICINE("773568002", "2.16.840.1.113883.6.96", "Emergency medicine (qualifier value)", "Emergency medicine", "Notfallmedizin", "m\u00e9decine d'urgence", "medicina d'urgenza"),
    ENDOCRINOLOGY("394583002", "2.16.840.1.113883.6.96", "Endocrinology (qualifier value)", "Endocrinology", "Endokrinologie/Diabetologie", "endocrinologie/diab\u00e9tologie", "endocrinologia/diabetologia"),
    GASTROENTEROLOGY("394584008", "2.16.840.1.113883.6.96", "Gastroenterology (qualifier value)", "Gastroenterology", "Gastroenterologie", "gastroent\u00e9rologie", "gastroenterologia"),
    GENERAL_MEDICINE("394802001", "2.16.840.1.113883.6.96", "General medicine (qualifier value)", "General medicine", "Allgemeinmedizin", "m\u00e9decine g\u00e9n\u00e9rale", "medicina generale"),
    GENERAL_SURGERY("394609007", "2.16.840.1.113883.6.96", "General surgery (qualifier value)", "General surgery", "Chirurgie", "chirurgie", "chirurgia"),
    GERIATRIC_MEDICINE("394811001", "2.16.840.1.113883.6.96", "Geriatric medicine (qualifier value)", "Geriatric medicine", "Geriatrie", "g\u00e9riatrie", "geriatria"),
    GYNECOLOGY("394586005", "2.16.840.1.113883.6.96", "Gynecology (qualifier value)", "Gynecology", "Gyn\u00e4kologie", "gyn\u00e9cologie", "ginecologia"),
    INFECTIOUS_DISEASES("394807007", "2.16.840.1.113883.6.96", "Infectious diseases (specialty) (qualifier value)", "Infectious diseases", "Infektionskrankheiten", "maladies infectieuses", "malattia infettiva"),
    INTERNAL_MEDICINE("419192003", "2.16.840.1.113883.6.96", "Internal medicine (qualifier value)", "Internal medicine", "Innere Medizin", "m\u00e9decine interne", "medicina interna"),
    LABORATORY_SERVICE("708184003", "2.16.840.1.113883.6.96", "Clinical pathology service (qualifier value)", "Laboratory service", "Labormedizin", "m\u00e9decin de laboratoire", "medicina di laboratorio"),
    LEGAL_MEDICINE("722204007", "2.16.840.1.113883.6.96", "Legal medicine (qualifier value)", "Legal medicine", "Rechtsmedizin", "m\u00e9decine l\u00e9gale", "medicina legale"),
    NEPHROLOGY("394589003", "2.16.840.1.113883.6.96", "Nephrology (qualifier value)", "Nephrology", "Nephrologie", "n\u00e9phrologie", "nefrologia"),
    NEUROLOGY("394591006", "2.16.840.1.113883.6.96", "Neurology (qualifier value)", "Neurology", "Neurologie", "neurologie", "neurologia"),
    NEUROSURGERY("394610002", "2.16.840.1.113883.6.96", "Neurosurgery (qualifier value)", "Neurosurgery", "Neurochirurgie", "neurochirurgie", "neurochirurgia"),
    NUCLEAR_MEDICINE("394649004", "2.16.840.1.113883.6.96", "Nuclear medicine - specialty (qualifier value)", "Nuclear medicine", "Nuklearmedizin", "m\u00e9decine nucl\u00e9aire", "medicina nucleare"),
    NURSING("722165004", "2.16.840.1.113883.6.96", "Nursing (qualifier value)", "Nursing", "Pflege", "soins", "cure infermieristiche"),
    OBSTETRICS("408470005", "2.16.840.1.113883.6.96", "Obstetrics (qualifier value)", "Obstetrics", "Geburtshilfe", "obst\u00e9trique", "ostetricia"),
    OCCUPATIONAL_THERAPY_SERVICE("310093001", "2.16.840.1.113883.6.96", "Occupational therapy service (qualifier value)", "Occupational therapy service", "Ergotherapie", "ergoth\u00e9rapie", "ergoterapia"),
    OPHTHALMOLOGY("394594003", "2.16.840.1.113883.6.96", "Ophthalmology (qualifier value)", "Ophthalmology", "Ophthalmologie", "ophtalmologie", "oftalmologia"),
    ORAL_AND_MAXILLOFACIAL_SURGERY("408465003", "2.16.840.1.113883.6.96", "Oral and maxillofacial surgery (qualifier value)", "Oral and maxillofacial surgery", "Mund-, Kiefer- und Gesichtschirurgie", "chirurgie dento-maxillo-faciale", "chirurgia oro-maxillo-facciale"),
    OSTEOPATHIC_MANIPULATIVE_MEDICINE("416304004", "2.16.840.1.113883.6.96", "Osteopathic manipulative medicine (qualifier value)", "Osteopathic manipulative medicine", "Osteopathie", "ost\u00e9opathie", "osteopatia"),
    OTHER_CLINICAL_SPECIALTY("394658006", "2.16.840.1.113883.6.96", "Clinical specialty (qualifier value)", "Other clinical specialty", "Andere nicht n\u00e4her spezifizierte medizinische Fachrichtung", "autres sp\u00e9cialisations non sp\u00e9cifi\u00e9es", "altre specialit\u00e0 mediche non meglio precisate"),
    OTOLARYNGOLOGY("418960008", "2.16.840.1.113883.6.96", "Otolaryngology (qualifier value)", "Otolaryngology", "Oto-Rhino-Laryngologie", "oto-rhino-laryngologie", "otorinolaringoiatria"),
    PALLIATIVE_MEDICINE("394806003", "2.16.840.1.113883.6.96", "Palliative medicine (qualifier value)", "Palliative medicine", "Palliativmedizin", "m\u00e9decine palliative", "medicina palliativa"),
    PATHOLOGY("394595002", "2.16.840.1.113883.6.96", "Pathology (qualifier value)", "Pathology", "Pathologie", "pathologie", "patologia"),
    PEDIATRICS("394537008", "2.16.840.1.113883.6.96", "Pediatric specialty (qualifier value)", "Pediatrics", "P\u00e4diatrie", "p\u00e9diatrie", "pediatria"),
    PHARMACY_SERVICE("310080006", "2.16.840.1.113883.6.96", "Pharmacy service (qualifier value)", "Pharmacy service", "Pharmazeutische Dienstleistungen", "service pharmaceutique", "servizio farmaceutico"),
    PHYSIOTHERAPY("722138006", "2.16.840.1.113883.6.96", "Physiotherapy (qualifier value)", "Physiotherapy", "Physiotherapie", "physioth\u00e9rapie", "fisioterapia"),
    PLASTIC_SURGERY("394611003", "2.16.840.1.113883.6.96", "Plastic surgery - specialty (qualifier value)", "Plastic surgery", "Plastische, Rekonstruktive und \u00c4sthetische Chirurgie", "chirurgie plastique, reconstructrice et esth\u00e9tique", "chirurgia plastica, ricostruttiva ed estetica"),
    PODIATRY_SERVICE("310087009", "2.16.840.1.113883.6.96", "Podiatry service (qualifier value)", "Podiatry service", "Podologie", "podologie", "podologia"),
    PREVENTIVE_MEDICINE("409968004", "2.16.840.1.113883.6.96", "Preventive medicine (qualifier value)", "Preventive medicine", "Pr\u00e4ventionsmedizin", "m\u00e9decine pr\u00e9ventive", "prevenzione"),
    PSYCHIATRY("394587001", "2.16.840.1.113883.6.96", "Psychiatry (qualifier value)", "Psychiatry", "Psychiatrie und Psychotherapie", "psychiatrie et psychoth\u00e9rapie", "psichiatria e psicoterapia"),
    PSYCHOLOGY("722162001", "2.16.840.1.113883.6.96", "Psychology (qualifier value)", "Psychology", "Psychologie", "psychologie", "psicologia"),
    PSYCHOSOMATIC_MEDICINE("721961006", "2.16.840.1.113883.6.96", "Psychosomatic medicine (qualifier value)", "Psychosomatic medicine", "Psychosomatik", "psychosomatique", "medicina psicosomatica"),
    PULMONARY_MEDICINE("418112009", "2.16.840.1.113883.6.96", "Pulmonary medicine (qualifier value)", "Pulmonary medicine", "Pneumologie", "pneumologie", "pneumologia"),
    RADIATION_ONCOLOGY("419815003", "2.16.840.1.113883.6.96", "Radiation oncology (qualifier value)", "Radiation oncology", "Radio-Onkologie", "radio-oncologie", "radio-oncologia"),
    RADIOLOGY("394914008", "2.16.840.1.113883.6.96", "Radiology - specialty (qualifier value)", "Radiology", "Radiologie", "radiologie", "radiologia"),
    REHABILITATION("394602003", "2.16.840.1.113883.6.96", "Rehabilitation - specialty (qualifier value)", "Rehabilitation", "Rehabilitation", "r\u00e9adaptation", "riabilitazione"),
    RHEUMATOLOGY("394810000", "2.16.840.1.113883.6.96", "Rheumatology (qualifier value)", "Rheumatology", "Rheumatologie", "rhumatologie", "reumatologia"),
    SPEECH_AND_LANGUAGE_THERAPY_SERVICE("310101009", "2.16.840.1.113883.6.96", "Speech and language therapy service (qualifier value)", "Speech and language therapy service", "Logop\u00e4die", "logop\u00e9die", "logopedia"),
    THORACIC_SURGERY("408456005", "2.16.840.1.113883.6.96", "Thoracic surgery (qualifier value)", "Thoracic surgery", "Thoraxchirurgie", "chirurgie thoracique", "chirurgia toracica"),
    TRANSFUSION_MEDICINE("394819004", "2.16.840.1.113883.6.96", "Blood transfusion (specialty) (qualifier value)", "Transfusion medicine", "Transfusionsmedizin", "m\u00e9decine transfusionnelle", "medicina trasfusionale"),
    TRANSPLANT_SURGERY("408477008", "2.16.840.1.113883.6.96", "Transplantation surgery (qualifier value)", "Transplant surgery", "Transplatationschirurgie", "chirurgie de transplantation", "chirurgia dei trapianti"),
    TRAUMA_AND_ORTHOPEDICS("394801008", "2.16.840.1.113883.6.96", "Trauma and orthopedics (qualifier value)", "Trauma and orthopedics", "Orthop\u00e4die und Traumatologie", "chirurgie orthop\u00e9dique et traumatologie de l'appareil locomoteur", "chirurgia ortopedica e traumatologia dell'apparato locomotore"),
    TROPICAL_MEDICINE("408448007", "2.16.840.1.113883.6.96", "Tropical medicine (qualifier value)", "Tropical medicine", "Tropen- und Reisemedizin", "m\u00e9decine tropicale et des voyages", "medicina tropicale e di viaggio"),
    UROLOGY("394612005", "2.16.840.1.113883.6.96", "Urology (qualifier value)", "Urology", "Urologie", "urologie", "urologia"),
    VASCULAR_MEDICINE("722414000", "2.16.840.1.113883.6.96", "Vascular medicine (qualifier value)", "Vascular medicine", "Angiologie", "angiologie", "angiologia"),
    VASCULAR_SURGERY("408463005", "2.16.840.1.113883.6.96", "Vascular surgery (qualifier value)", "Vascular surgery", "Gef\u00e4sschirurgie", "chirurgie vasculaire", "chirurgia vascolare");

    public static final String ACCIDENT_AND_EMERGENCY_CODE = "394576009";
    public static final String ANAESTHESIOLOGY_CODE = "394577000";
    public static final String CARDIAC_SURGERY_CODE = "408466002";
    public static final String CARDIOLOGY_CODE = "394579002";
    public static final String CHIROPRACTIC_SERVICE_CODE = "722170006";
    public static final String CLINICAL_GENETICS_CODE = "394580004";
    public static final String CLINICAL_HAEMATOLOGY_CODE = "394803006";
    public static final String CLINICAL_IMMUNOLOGY_CODE = "408480009";
    public static final String CLINICAL_IMMUNOLOGY_ALLERGY_CODE = "394805004";
    public static final String CLINICAL_ONCOLOGY_CODE = "394592004";
    public static final String CLINICAL_PHARMACOLOGY_CODE = "394600006";
    public static final String COMPLEMENTARY_THERAPY_CODE = "310025004";
    public static final String CRITICAL_CARE_MEDICINE_CODE = "408478003";
    public static final String DENTAL_MEDICINE_CODE = "394812008";
    public static final String DENTISTRY_CODE = "722163006";
    public static final String DERMATOLOGY_CODE = "394582007";
    public static final String DIETETICS_AND_NUTRITION_CODE = "722164000";
    public static final String EMERGENCY_MEDICINE_CODE = "773568002";
    public static final String ENDOCRINOLOGY_CODE = "394583002";
    public static final String GASTROENTEROLOGY_CODE = "394584008";
    public static final String GENERAL_MEDICINE_CODE = "394802001";
    public static final String GENERAL_SURGERY_CODE = "394609007";
    public static final String GERIATRIC_MEDICINE_CODE = "394811001";
    public static final String GYNECOLOGY_CODE = "394586005";
    public static final String INFECTIOUS_DISEASES_CODE = "394807007";
    public static final String INTERNAL_MEDICINE_CODE = "419192003";
    public static final String LABORATORY_SERVICE_CODE = "708184003";
    public static final String LEGAL_MEDICINE_CODE = "722204007";
    public static final String NEPHROLOGY_CODE = "394589003";
    public static final String NEUROLOGY_CODE = "394591006";
    public static final String NEUROSURGERY_CODE = "394610002";
    public static final String NUCLEAR_MEDICINE_CODE = "394649004";
    public static final String NURSING_CODE = "722165004";
    public static final String OBSTETRICS_CODE = "408470005";
    public static final String OCCUPATIONAL_THERAPY_SERVICE_CODE = "310093001";
    public static final String OPHTHALMOLOGY_CODE = "394594003";
    public static final String ORAL_AND_MAXILLOFACIAL_SURGERY_CODE = "408465003";
    public static final String OSTEOPATHIC_MANIPULATIVE_MEDICINE_CODE = "416304004";
    public static final String OTHER_CLINICAL_SPECIALTY_CODE = "394658006";
    public static final String OTOLARYNGOLOGY_CODE = "418960008";
    public static final String PALLIATIVE_MEDICINE_CODE = "394806003";
    public static final String PATHOLOGY_CODE = "394595002";
    public static final String PEDIATRICS_CODE = "394537008";
    public static final String PHARMACY_SERVICE_CODE = "310080006";
    public static final String PHYSIOTHERAPY_CODE = "722138006";
    public static final String PLASTIC_SURGERY_CODE = "394611003";
    public static final String PODIATRY_SERVICE_CODE = "310087009";
    public static final String PREVENTIVE_MEDICINE_CODE = "409968004";
    public static final String PSYCHIATRY_CODE = "394587001";
    public static final String PSYCHOLOGY_CODE = "722162001";
    public static final String PSYCHOSOMATIC_MEDICINE_CODE = "721961006";
    public static final String PULMONARY_MEDICINE_CODE = "418112009";
    public static final String RADIATION_ONCOLOGY_CODE = "419815003";
    public static final String RADIOLOGY_CODE = "394914008";
    public static final String REHABILITATION_CODE = "394602003";
    public static final String RHEUMATOLOGY_CODE = "394810000";
    public static final String SPEECH_AND_LANGUAGE_THERAPY_SERVICE_CODE = "310101009";
    public static final String THORACIC_SURGERY_CODE = "408456005";
    public static final String TRANSFUSION_MEDICINE_CODE = "394819004";
    public static final String TRANSPLANT_SURGERY_CODE = "408477008";
    public static final String TRAUMA_AND_ORTHOPEDICS_CODE = "394801008";
    public static final String TROPICAL_MEDICINE_CODE = "408448007";
    public static final String UROLOGY_CODE = "394612005";
    public static final String VASCULAR_MEDICINE_CODE = "722414000";
    public static final String VASCULAR_SURGERY_CODE = "408463005";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.3.10.1.18";
    public static final String VALUE_SET_NAME = "DocumentEntry.practiceSettingCode";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.6.96";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable PracticeSettingCode getEnum(@Nullable String code) {
        for (PracticeSettingCode x : PracticeSettingCode.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(PracticeSettingCode.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (PracticeSettingCode x : PracticeSettingCode.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private PracticeSettingCode(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

