/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.enums.stable;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ClassTypeCodeMapping implements ValueSetEnumInterface
{
    ADMINISTRATIVE_DOCUMENTATION_RECORD_ARTIFACT("405624007", "2.16.840.1.113883.6.96", "Administrative documentation (record artifact)", "Administrative documentation (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ADVANCE_DIRECTIVE_REPORT_RECORD_ARTIFACT("371538006", "2.16.840.1.113883.6.96", "Advance directive report (record artifact)", "Advance directive report (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ALLERGY_RECORD_RECORD_ARTIFACT_L1("722446000", "2.16.840.1.113883.6.96", "Allergy record (record artifact)", "Allergy record (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    AUDIT_TRAIL_REPORT_RECORD_ARTIFACT("722160009", "2.16.840.1.113883.6.96", "Audit trail report (record artifact)", "Audit trail report (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CARE_PLAN_RECORD_ARTIFACT("734163000", "2.16.840.1.113883.6.96", "Care plan (record artifact)", "Care plan (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CLINICAL_CONSULTATION_REPORT_RECORD_ARTIFACT_L1("371530004", "2.16.840.1.113883.6.96", "Clinical consultation report (record artifact)", "Clinical consultation report (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CLINICAL_MANAGEMENT_PLAN_RECORD_ARTIFACT_L1("737427001", "2.16.840.1.113883.6.96", "Clinical management plan (record artifact)", "Clinical management plan (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CLINICAL_PROCEDURE_REPORT_RECORD_ARTIFACT("371525003", "2.16.840.1.113883.6.96", "Clinical procedure report (record artifact)", "Clinical procedure report (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CONSENT_REPORT_RECORD_ARTIFACT("371537001", "2.16.840.1.113883.6.96", "Consent report (record artifact)", "Consent report (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    DIGITAL_REPRESENTATION_OF_SPECIMEN_RECORD_ARTIFACT_L1("787148009", "2.16.840.1.113883.6.96", "Digital representation of specimen (record artifact)", "Digital representation of specimen (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    DISCHARGE_SUMMARY_RECORD_ARTIFACT_L1("373942005", "2.16.840.1.113883.6.96", "Discharge summary (record artifact)", "Discharge summary (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    EMERGENCY_DEPARTMENT_RECORD_RECORD_ARTIFACT_L1("445300006", "2.16.840.1.113883.6.96", "Emergency department record (record artifact)", "Emergency department record (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    EMERGENCY_MEDICAL_IDENTIFICATION_RECORD_RECORD_ARTIFACT("722216001", "2.16.840.1.113883.6.96", "Emergency medical identification record (record artifact)", "Emergency medical identification record (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    HISTORY_AND_PHYSICAL_REPORT_RECORD_ARTIFACT_L1("371529009", "2.16.840.1.113883.6.96", "History and physical report (record artifact)", "History and physical report (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    IMAGE_REFERENCE_FOUNDATION_METADATA_CONCEPT_L1("900000000000471006", "2.16.840.1.113883.6.96", "Image reference (foundation metadata concept)", "Image reference (foundation metadata concept)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    IMAGING_ORDER_RECORD_ARTIFACT_L1("2161000195103", "2.16.840.1.113883.6.96", "Imaging order (record artifact)", "Imaging order (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    IMAGING_REPORT_RECORD_ARTIFACT_L1("4201000179104", "2.16.840.1.113883.6.96", "Imaging report (record artifact)", "Imaging report (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    IMMUNIZATION_RECORD_RECORD_ARTIFACT_L1("41000179103", "2.16.840.1.113883.6.96", "Immunization record (record artifact)", "Immunization record (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    LABORATORY_ORDER_RECORD_ARTIFACT_L1("721965002", "2.16.840.1.113883.6.96", "Laboratory order (record artifact)", "Laboratory order (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    LABORATORY_REPORT_RECORD_ARTIFACT_L1("4241000179101", "2.16.840.1.113883.6.96", "Laboratory report (record artifact)", "Laboratory report (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MEDICAL_CERTIFICATE_RECORD_ARTIFACT_L1("772786005", "2.16.840.1.113883.6.96", "Medical certificate (record artifact)", "Medical certificate (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MEDICATION_DISPENSE_DOCUMENT_RECORD_ARTIFACT_L1("82291000195104", "2.16.756.5.30.1.127.3.4", "Medication dispense document (record artifact)", "Medication dispense document (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MEDICATION_MANAGEMENT_PLAN_RECORD_ARTIFACT_L1("736378000", "2.16.840.1.113883.6.96", "Medication management plan (record artifact)", "Medication management plan (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MEDICATION_SUMMARY_DOCUMENT_RECORD_ARTIFACT_L1("721912009", "2.16.840.1.113883.6.96", "Medication summary document (record artifact)", "Medication summary document (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MEDICATION_TREATMENT_PLAN_REPORT_RECORD_ARTIFACT_L1("761931002", "2.16.840.1.113883.6.96", "Medication treatment plan report (record artifact)", "Medication treatment plan report (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MEDICINAL_PRESCRIPTION_RECORD_RECORD_ARTIFACT_L1("761938008", "2.16.840.1.113883.6.96", "Medicinal prescription record (record artifact)", "Medicinal prescription record (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NON_DRUG_PRESCRIPTION_RECORD_RECORD_ARTIFACT_L1("765492005", "2.16.840.1.113883.6.96", "Non-drug prescription record (record artifact)", "Non-drug prescription record (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NURSING_CARE_PLAN_RECORD_ARTIFACT_L1("773130005", "2.16.840.1.113883.6.96", "Nursing care plan (record artifact)", "Nursing care plan (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    OBSTETRICAL_RECORD_RECORD_ARTIFACT("2171000195109", "2.16.756.5.30.1.127.3.4", "Obstetrical record (record artifact)", "Obstetrical record (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    OPERATIVE_REPORT_RECORD_ARTIFACT_L1("371526002", "2.16.840.1.113883.6.96", "Operative report (record artifact)", "Operative report (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ORDER_RECORD_ARTIFACT("721963009", "2.16.840.1.113883.6.96", "Order (record artifact)", "Order (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ORGAN_DONOR_CARD_RECORD_ARTIFACT("772790007", "2.16.840.1.113883.6.96", "Organ donor card (record artifact)", "Organ donor card (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PATHOLOGY_ORDER_RECORD_ARTIFACT_L1("721966001", "2.16.840.1.113883.6.96", "Pathology order (record artifact)", "Pathology order (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PATHOLOGY_REPORT_RECORD_ARTIFACT_L1("371528001", "2.16.840.1.113883.6.96", "Pathology report (record artifact)", "Pathology report (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PATIENT_RECORD_TYPE_RECORD_ARTIFACT("184216000", "2.16.840.1.113883.6.96", "Patient record type (record artifact)", "Patient record type (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PRESCRIPTION_RECORD_RECORD_ARTIFACT("440545006", "2.16.840.1.113883.6.96", "Prescription record (record artifact)", "Prescription record (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PROFESSIONAL_ALLIED_TO_MEDICINE_CLINICAL_REPORT_RECORD_ARTIFACT_L1("445418005", "2.16.840.1.113883.6.96", "Professional allied to medicine clinical report (record artifact)", "Professional allied to medicine clinical report (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PROGRESS_REPORT_RECORD_ARTIFACT_L1("371532007", "2.16.840.1.113883.6.96", "Progress report (record artifact)", "Progress report (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    RECORD_ARTIFACT_RECORD_ARTIFACT("419891008", "2.16.840.1.113883.6.96", "Record artifact (record artifact)", "Record artifact (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    RECORD_ARTIFACT_RECORD_ARTIFACT_L1("419891008", "2.16.840.1.113883.6.96", "Record artifact (record artifact)", "Record artifact (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    RECORD_OF_HEALTH_EVENT_RECORD_ARTIFACT("417319006", "2.16.840.1.113883.6.96", "Record of health event (record artifact)", "Record of health event (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    REFERRAL_NOTE_RECORD_ARTIFACT("721927009", "2.16.840.1.113883.6.96", "Referral note (record artifact)", "Referral note (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    REHABILITATION_CARE_PLAN_RECORD_ARTIFACT_L1("736055001", "2.16.840.1.113883.6.96", "Rehabilitation care plan (record artifact)", "Rehabilitation care plan (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    REPORT_OF_CLINICAL_ENCOUNTER_RECORD_ARTIFACT("371531000", "2.16.840.1.113883.6.96", "Report of clinical encounter (record artifact)", "Report of clinical encounter (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SUMMARY_CLINICAL_DOCUMENT_RECORD_ARTIFACT("422735006", "2.16.840.1.113883.6.96", "Summary clinical document (record artifact)", "Summary clinical document (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    TRANSFER_SUMMARY_REPORT_RECORD_ARTIFACT_L1("371535009", "2.16.840.1.113883.6.96", "Transfer summary report (record artifact)", "Transfer summary report (record artifact)", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String ADMINISTRATIVE_DOCUMENTATION_RECORD_ARTIFACT_CODE = "405624007";
    public static final String ADVANCE_DIRECTIVE_REPORT_RECORD_ARTIFACT_CODE = "371538006";
    public static final String ALLERGY_RECORD_RECORD_ARTIFACT_L1_CODE = "722446000";
    public static final String AUDIT_TRAIL_REPORT_RECORD_ARTIFACT_CODE = "722160009";
    public static final String CARE_PLAN_RECORD_ARTIFACT_CODE = "734163000";
    public static final String CLINICAL_CONSULTATION_REPORT_RECORD_ARTIFACT_L1_CODE = "371530004";
    public static final String CLINICAL_MANAGEMENT_PLAN_RECORD_ARTIFACT_L1_CODE = "737427001";
    public static final String CLINICAL_PROCEDURE_REPORT_RECORD_ARTIFACT_CODE = "371525003";
    public static final String CONSENT_REPORT_RECORD_ARTIFACT_CODE = "371537001";
    public static final String DIGITAL_REPRESENTATION_OF_SPECIMEN_RECORD_ARTIFACT_L1_CODE = "787148009";
    public static final String DISCHARGE_SUMMARY_RECORD_ARTIFACT_L1_CODE = "373942005";
    public static final String EMERGENCY_DEPARTMENT_RECORD_RECORD_ARTIFACT_L1_CODE = "445300006";
    public static final String EMERGENCY_MEDICAL_IDENTIFICATION_RECORD_RECORD_ARTIFACT_CODE = "722216001";
    public static final String HISTORY_AND_PHYSICAL_REPORT_RECORD_ARTIFACT_L1_CODE = "371529009";
    public static final String IMAGE_REFERENCE_FOUNDATION_METADATA_CONCEPT_L1_CODE = "900000000000471006";
    public static final String IMAGING_ORDER_RECORD_ARTIFACT_L1_CODE = "2161000195103";
    public static final String IMAGING_REPORT_RECORD_ARTIFACT_L1_CODE = "4201000179104";
    public static final String IMMUNIZATION_RECORD_RECORD_ARTIFACT_L1_CODE = "41000179103";
    public static final String LABORATORY_ORDER_RECORD_ARTIFACT_L1_CODE = "721965002";
    public static final String LABORATORY_REPORT_RECORD_ARTIFACT_L1_CODE = "4241000179101";
    public static final String MEDICAL_CERTIFICATE_RECORD_ARTIFACT_L1_CODE = "772786005";
    public static final String MEDICATION_DISPENSE_DOCUMENT_RECORD_ARTIFACT_L1_CODE = "82291000195104";
    public static final String MEDICATION_MANAGEMENT_PLAN_RECORD_ARTIFACT_L1_CODE = "736378000";
    public static final String MEDICATION_SUMMARY_DOCUMENT_RECORD_ARTIFACT_L1_CODE = "721912009";
    public static final String MEDICATION_TREATMENT_PLAN_REPORT_RECORD_ARTIFACT_L1_CODE = "761931002";
    public static final String MEDICINAL_PRESCRIPTION_RECORD_RECORD_ARTIFACT_L1_CODE = "761938008";
    public static final String NON_DRUG_PRESCRIPTION_RECORD_RECORD_ARTIFACT_L1_CODE = "765492005";
    public static final String NURSING_CARE_PLAN_RECORD_ARTIFACT_L1_CODE = "773130005";
    public static final String OBSTETRICAL_RECORD_RECORD_ARTIFACT_CODE = "2171000195109";
    public static final String OPERATIVE_REPORT_RECORD_ARTIFACT_L1_CODE = "371526002";
    public static final String ORDER_RECORD_ARTIFACT_CODE = "721963009";
    public static final String ORGAN_DONOR_CARD_RECORD_ARTIFACT_CODE = "772790007";
    public static final String PATHOLOGY_ORDER_RECORD_ARTIFACT_L1_CODE = "721966001";
    public static final String PATHOLOGY_REPORT_RECORD_ARTIFACT_L1_CODE = "371528001";
    public static final String PATIENT_RECORD_TYPE_RECORD_ARTIFACT_CODE = "184216000";
    public static final String PRESCRIPTION_RECORD_RECORD_ARTIFACT_CODE = "440545006";
    public static final String PROFESSIONAL_ALLIED_TO_MEDICINE_CLINICAL_REPORT_RECORD_ARTIFACT_L1_CODE = "445418005";
    public static final String PROGRESS_REPORT_RECORD_ARTIFACT_L1_CODE = "371532007";
    public static final String RECORD_ARTIFACT_RECORD_ARTIFACT_CODE = "419891008";
    public static final String RECORD_ARTIFACT_RECORD_ARTIFACT_L1_CODE = "419891008";
    public static final String RECORD_OF_HEALTH_EVENT_RECORD_ARTIFACT_CODE = "417319006";
    public static final String REFERRAL_NOTE_RECORD_ARTIFACT_CODE = "721927009";
    public static final String REHABILITATION_CARE_PLAN_RECORD_ARTIFACT_L1_CODE = "736055001";
    public static final String REPORT_OF_CLINICAL_ENCOUNTER_RECORD_ARTIFACT_CODE = "371531000";
    public static final String SUMMARY_CLINICAL_DOCUMENT_RECORD_ARTIFACT_CODE = "422735006";
    public static final String TRANSFER_SUMMARY_REPORT_RECORD_ARTIFACT_L1_CODE = "371535009";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.3.10.1.30";
    public static final String VALUE_SET_NAME = "DocumentEntry.classCode_DocumentEntry.typeCode_mapping";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable ClassTypeCodeMapping getEnum(@Nullable String code) {
        for (ClassTypeCodeMapping x : ClassTypeCodeMapping.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ClassTypeCodeMapping.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (ClassTypeCodeMapping x : ClassTypeCodeMapping.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ClassTypeCodeMapping(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

