/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.enums.stable;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ClassCode implements ValueSetEnumInterface
{
    ADMINISTRATIVE_DOCUMENT("405624007", "2.16.840.1.113883.6.96", "Administrative documentation (record artifact)", "Administrative document", "Administratives Dokument", "document administratif", "documento amministrativo"),
    ADVANCE_DIRECTIVES("371538006", "2.16.840.1.113883.6.96", "Advance directive report (record artifact)", "Advance directives", "Patientenverf\u00fcgung", "directives anticip\u00e9es", "direttive anticipate"),
    BIRTH_REPORT("2171000195109", "2.16.756.5.30.1.127.3.4", "Obstetrical record (record artifact)", "Birth report", "Schwangerschaftsbericht", "rapport de grossesse", "rapporto di gravidanza"),
    CARE_PLAN("734163000", "2.16.840.1.113883.6.96", "Care plan (record artifact)", "Care plan", "Behandlungsplan", "plans de soins", "piano di cura"),
    CONSENT("371537001", "2.16.840.1.113883.6.96", "Consent report (record artifact)", "Consent", "Einverst\u00e4ndniserkl\u00e4rung", "consentement", "consenso"),
    EMERGENCY_ID_CARD("722216001", "2.16.840.1.113883.6.96", "Emergency medical identification record (record artifact)", "Emergency ID card", "Notfallkarte", "carte d'urgence", "tessera di emergenza"),
    EVENT_REPORT("417319006", "2.16.840.1.113883.6.96", "Record of health event (record artifact)", "Event report", "Dokument zu gesundheitsrelevantem Ereignis", "document sur l'\u00e9v\u00e9nement sanitaire", "documento concernente un evento rilevante per la salute"),
    ORDER("721963009", "2.16.840.1.113883.6.96", "Order (record artifact)", "Order", "Untersuchungsauftrag", "demande d'examen", "richiesta di esami"),
    ORGAN_DONOR_CARD("772790007", "2.16.840.1.113883.6.96", "Organ donor card (record artifact)", "Organ donor card", "Organspendeausweis", "carte de donneur d'organes", "tessera di donatore di organi"),
    OTHER_DOCUMENTATION("419891008", "2.16.840.1.113883.6.96", "Record artifact (record artifact)", "Other documentation", "Sonstige Dokumentation", "autre documentation", "altra documentazione"),
    PATIENT_DOCUMENTATION("184216000", "2.16.840.1.113883.6.96", "Patient record type (record artifact)", "Patient documentation", "Patientendokumentation", "documentation du patient", "documentazione del paziente"),
    PRESCRIPTION("440545006", "2.16.840.1.113883.6.96", "Prescription record (record artifact)", "Prescription", "Rezept", "ordonnance", "prescrizione medica"),
    PROCEDURE_REPORT("371525003", "2.16.840.1.113883.6.96", "Clinical procedure report (record artifact)", "Procedure report", "Interventionsbericht", "rapport d'intervention", "rapporto operatorio"),
    RECORD_ACCESS("722160009", "2.16.840.1.113883.6.96", "Audit trail report (record artifact)", "Record access", "R\u00fcckverfolgung der EPD Zugriffe", "tra\u00e7abilit\u00e9 des acc\u00e8s aux DEP", "calloutronologia degli accessi alla CIP"),
    REFERRAL_NOTE("721927009", "2.16.840.1.113883.6.96", "Referral note (record artifact)", "Referral note", "Zuweisungsschreiben", "lettre de r\u00e9f\u00e9rence", "lettera d'invio"),
    REPORT_OF_CLINICAL_ENCOUNTER("371531000", "2.16.840.1.113883.6.96", "Report of clinical encounter (record artifact)", "Report of clinical encounter", "Konsultationsbericht", "rapport de consultation", "rapporto di visita medica"),
    SUMMARY("422735006", "2.16.840.1.113883.6.96", "Summary clinical document (record artifact)", "Summary", "Zusammenfassung", "r\u00e9sum\u00e9", "riepilogo");

    public static final String ADMINISTRATIVE_DOCUMENT_CODE = "405624007";
    public static final String ADVANCE_DIRECTIVES_CODE = "371538006";
    public static final String BIRTH_REPORT_CODE = "2171000195109";
    public static final String CARE_PLAN_CODE = "734163000";
    public static final String CONSENT_CODE = "371537001";
    public static final String EMERGENCY_ID_CARD_CODE = "722216001";
    public static final String EVENT_REPORT_CODE = "417319006";
    public static final String ORDER_CODE = "721963009";
    public static final String ORGAN_DONOR_CARD_CODE = "772790007";
    public static final String OTHER_DOCUMENTATION_CODE = "419891008";
    public static final String PATIENT_DOCUMENTATION_CODE = "184216000";
    public static final String PRESCRIPTION_CODE = "440545006";
    public static final String PROCEDURE_REPORT_CODE = "371525003";
    public static final String RECORD_ACCESS_CODE = "722160009";
    public static final String REFERRAL_NOTE_CODE = "721927009";
    public static final String REPORT_OF_CLINICAL_ENCOUNTER_CODE = "371531000";
    public static final String SUMMARY_CODE = "422735006";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.3.10.1.3";
    public static final String VALUE_SET_NAME = "DocumentEntry.classCode";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable ClassCode getEnum(@Nullable String code) {
        for (ClassCode x : ClassCode.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ClassCode.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (ClassCode x : ClassCode.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ClassCode(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

