/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.enums.r202406;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum FormatCode implements ValueSetEnumInterface
{
    CDA_IMAGING_REPORT_WITH_STRUCTURED_HEADINGS("urn:ihe:rad:CDA:ImagingReportStructuredHeadings:2013", "1.3.6.1.4.1.19376.1.2.3", "XDS-I Imaging Report with Structured Headings (XDS-I)", "CDA Imaging Report with Structured Headings", "CDA Imaging Report with Structured Headings", "CDA Imaging Report with Structured Headings", "CDA Imaging Report with Structured Headings"),
    CDA_LABORATORY_REPORT("urn:ihe:lab:xd-lab:2008", "1.3.6.1.4.1.19376.1.2.3", "CDA Laboratory Report", "CDA Laboratory Report", "CDA Laboratory Report", "CDA Laboratory Report", "CDA Laboratory Report"),
    CDA_WRAPPED_TEXT_REPORT("urn:ihe:rad:TEXT", "1.3.6.1.4.1.19376.1.2.3", "XDS-I CDA Wrapped Text Report (XDS-I)", "CDA Wrapped Text Report", "CDA Wrapped Text Report", "CDA Wrapped Text Report", "CDA Wrapped Text Report"),
    CH_ALLERGYINTOLERANCE_DOCUMENT("urn:che:epr:ch-allergyintolerance:2024", "2.16.756.5.30.1.127.3.10.10", "CH AllergyIntolerance document", "CH AllergyIntolerance document", "CH AllergyIntolerance document", "CH AllergyIntolerance document", "CH AllergyIntolerance document"),
    CH_EMED_MEDICATION_CARD_DOCUMENT("urn:che:epr:ch-emed:medication-card:2023", "2.16.756.5.30.1.127.3.10.10", "CH EMED Medication Card document", "CH EMED Medication Card document", "CH EMED Medication Card document", "CH EMED Medication Card document", "CH EMED Medication Card document"),
    CH_EMED_MEDICATION_DISPENSE_DOCUMENT("urn:che:epr:ch-emed:dis:2024", "2.16.756.5.30.1.127.3.10.10", "CH EMED Medication Dispense document", "CH EMED Medication Dispense document", "CH EMED Medication Dispense document", "CH EMED Medication Dispense document", "CH EMED Medication Dispense document"),
    CH_EMED_MEDICATION_LIST_DOCUMENT("urn:che:epr:ch-emed:pml:2024", "2.16.756.5.30.1.127.3.10.10", "CH EMED Medication List document", "CH EMED Medication List document", "CH EMED Medication List document", "CH EMED Medication List document", "CH EMED Medication List document"),
    CH_EMED_MEDICATION_PRESCRIPTION_DOCUMENT("urn:che:epr:ch-emed:pre:2024", "2.16.756.5.30.1.127.3.10.10", "CH EMED Medication Prescription document", "CH EMED Medication Prescription document", "CH EMED Medication Prescription document", "CH EMED Medication Prescription document", "CH EMED Medication Prescription document"),
    CH_EMED_MEDICATION_TREATMENT_PLAN_DOCUMENT("urn:che:epr:ch-emed:mtp:2024", "2.16.756.5.30.1.127.3.10.10", "CH EMED Medication Treatment Plan document", "CH EMED Medication Treatment Plan document", "CH EMED Medication Treatment Plan document", "CH EMED Medication Treatment Plan document", "CH EMED Medication Treatment Plan document"),
    CH_EMED_PHARMACEUTICAL_ADVICE_DOCUMENT("urn:che:epr:ch-emed:padv:2024", "2.16.756.5.30.1.127.3.10.10", "CH EMED Pharmaceutical Advice document", "CH EMED Pharmaceutical Advice document", "CH EMED Pharmaceutical Advice document", "CH EMED Pharmaceutical Advice document", "CH EMED Pharmaceutical Advice document"),
    CH_VACD_IMMUNIZATION_ADMINISTRATION("urn:che:epr:ch-vacd:immunization-administration:2022", "2.16.756.5.30.1.127.3.10.10", "CH VACD Immunization Administration", "CH VACD Immunization Administration", "CH VACD Immunization Administration", "CH VACD Immunization Administration", "CH VACD Immunization Administration"),
    CH_VACD_VACCINATION_RECORD("urn:che:epr:ch-vacd:vaccination-record:2022", "2.16.756.5.30.1.127.3.10.10", "CH VACD Vaccination Record", "CH VACD Vaccination Record", "CH VACD Vaccination Record", "CH VACD Vaccination Record", "CH VACD Vaccination Record"),
    COMMUNITY_DISPENSE("urn:ihe:pharm:dis:2010", "1.3.6.1.4.1.19376.1.2.3", "Community Dispense", "Community Dispense", "Community Dispense", "Community Dispense", "Community Dispense"),
    COMMUNITY_MEDICATION_LIST("urn:ihe:pharm:pml:2013", "1.3.6.1.4.1.19376.1.2.3", "Community Medication List", "Community Medication List", "Community Medication List", "Community Medication List", "Community Medication List"),
    COMMUNITY_MEDICATION_TREATMENT_PLAN("urn:ihe:pharm:mtp:2015", "1.3.6.1.4.1.19376.1.2.3", "Community Medication Treatment Plan", "Community Medication Treatment Plan", "Community Medication Treatment Plan", "Community Medication Treatment Plan", "Community Medication Treatment Plan"),
    COMMUNITY_PHARMACEUTICAL_ADVICE("urn:ihe:pharm:padv:2010", "1.3.6.1.4.1.19376.1.2.3", "Community Pharmaceutical Advice", "Community Pharmaceutical Advice", "Community Pharmaceutical Advice", "Community Pharmaceutical Advice", "Community Pharmaceutical Advice"),
    COMMUNITY_PRESCRIPTION("urn:ihe:pharm:pre:2010", "1.3.6.1.4.1.19376.1.2.3", "Community Prescription", "Community Prescription", "Community Prescription", "Community Prescription", "Community Prescription"),
    IHE_KOS_DOCUMENT("1.2.840.10008.5.1.4.1.1.88.59", "1.2.840.10008.2.6.1", "DICOM Manifest (DICOM KOS SOP Class UID)", "IHE KOS document", "KOS Dokument", "Document KOS", "Documento KOS "),
    IMMUNIZATION_CONTENT("urn:ihe:pcc:ic:2009", "1.3.6.1.4.1.19376.1.2.3", "Immunization Content (IC)", "Immunization Content (IC)", "Immunization Content (IC)", "Immunization Content (IC)", "Immunization Content (IC)"),
    IMMUNIZATION_REGISTRY_CONTENT_IRC("urn:ihe:pcc:ic:2008", "1.3.6.1.4.1.19376.1.2.3", "Immunization Registry Content (IRC)", "Immunization Registry Content (IRC)", "Immunization Registry Content (IRC)", "Immunization Registry Content (IRC)", "Immunization Registry Content (IRC)"),
    MIMETYPE_SUFFICIENT("urn:ihe:iti:xds:2017:mimeTypeSufficient", "1.3.6.1.4.1.19376.1.2.3", "MimeType sufficient", "MimeType sufficient", "MimeType sufficient", "MimeType sufficient", "MimeType sufficient"),
    PDF_EMBEDDED_IN_CDA_PER_XDS_SD_PROFILE("urn:ihe:iti:xds-sd:pdf:2008", "1.3.6.1.4.1.19376.1.2.3", "Scanned Documents (PDF)", "PDF embedded in CDA per XDS-SD profile", "PDF embedded in CDA per XDS-SD profile", "PDF embedded in CDA per XDS-SD profile", "PDF embedded in CDA per XDS-SD profile"),
    PDF_RADIOLOGY_REPORT("urn:ihe:rad:PDF", "1.3.6.1.4.1.19376.1.2.3", "XDS-I PDF (XDS-I)", "PDF Radiology Report", "PDF Radiology Report", "PDF Radiology Report", "PDF Radiology Report"),
    TEXT_EMBEDDED_IN_CDA_PER_XDS_SD_PROFILE("urn:ihe:iti:xds-sd:text:2008", "1.3.6.1.4.1.19376.1.2.3", "Scanned Documents (text)", "Text embedded in CDA per XDS-SD profile", "Text embedded in CDA per XDS-SD profile", "Text embedded in CDA per XDS-SD profile", "Text embedded in CDA per XDS-SD profile"),
    UNSTRUCTURED_EPR_DOCUMENT("urn:che:epr:EPR_Unstructured_Document", "2.16.756.5.30.1.127.3.10.10", "Unstructured EPR document", "Unstructured EPR document", "Unstrukturiertes EPD Dokument", "Document DEP non structur\u00e9", "Documento CIP non strutturato");

    public static final String CDA_IMAGING_REPORT_WITH_STRUCTURED_HEADINGS_CODE = "urn:ihe:rad:CDA:ImagingReportStructuredHeadings:2013";
    public static final String CDA_LABORATORY_REPORT_CODE = "urn:ihe:lab:xd-lab:2008";
    public static final String CDA_WRAPPED_TEXT_REPORT_CODE = "urn:ihe:rad:TEXT";
    public static final String CH_ALLERGYINTOLERANCE_DOCUMENT_CODE = "urn:che:epr:ch-allergyintolerance:2024";
    public static final String CH_EMED_MEDICATION_CARD_DOCUMENT_CODE = "urn:che:epr:ch-emed:medication-card:2023";
    public static final String CH_EMED_MEDICATION_DISPENSE_DOCUMENT_CODE = "urn:che:epr:ch-emed:dis:2024";
    public static final String CH_EMED_MEDICATION_LIST_DOCUMENT_CODE = "urn:che:epr:ch-emed:pml:2024";
    public static final String CH_EMED_MEDICATION_PRESCRIPTION_DOCUMENT_CODE = "urn:che:epr:ch-emed:pre:2024";
    public static final String CH_EMED_MEDICATION_TREATMENT_PLAN_DOCUMENT_CODE = "urn:che:epr:ch-emed:mtp:2024";
    public static final String CH_EMED_PHARMACEUTICAL_ADVICE_DOCUMENT_CODE = "urn:che:epr:ch-emed:padv:2024";
    public static final String CH_VACD_IMMUNIZATION_ADMINISTRATION_CODE = "urn:che:epr:ch-vacd:immunization-administration:2022";
    public static final String CH_VACD_VACCINATION_RECORD_CODE = "urn:che:epr:ch-vacd:vaccination-record:2022";
    public static final String COMMUNITY_DISPENSE_CODE = "urn:ihe:pharm:dis:2010";
    public static final String COMMUNITY_MEDICATION_LIST_CODE = "urn:ihe:pharm:pml:2013";
    public static final String COMMUNITY_MEDICATION_TREATMENT_PLAN_CODE = "urn:ihe:pharm:mtp:2015";
    public static final String COMMUNITY_PHARMACEUTICAL_ADVICE_CODE = "urn:ihe:pharm:padv:2010";
    public static final String COMMUNITY_PRESCRIPTION_CODE = "urn:ihe:pharm:pre:2010";
    public static final String IHE_KOS_DOCUMENT_CODE = "1.2.840.10008.5.1.4.1.1.88.59";
    public static final String IMMUNIZATION_CONTENT_CODE = "urn:ihe:pcc:ic:2009";
    public static final String IMMUNIZATION_REGISTRY_CONTENT_IRC_CODE = "urn:ihe:pcc:ic:2008";
    public static final String MIMETYPE_SUFFICIENT_CODE = "urn:ihe:iti:xds:2017:mimeTypeSufficient";
    public static final String PDF_EMBEDDED_IN_CDA_PER_XDS_SD_PROFILE_CODE = "urn:ihe:iti:xds-sd:pdf:2008";
    public static final String PDF_RADIOLOGY_REPORT_CODE = "urn:ihe:rad:PDF";
    public static final String TEXT_EMBEDDED_IN_CDA_PER_XDS_SD_PROFILE_CODE = "urn:ihe:iti:xds-sd:text:2008";
    public static final String UNSTRUCTURED_EPR_DOCUMENT_CODE = "urn:che:epr:EPR_Unstructured_Document";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.3.10.1.9";
    public static final String VALUE_SET_NAME = "DocumentEntry.formatCode";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable FormatCode getEnum(@Nullable String code) {
        for (FormatCode x : FormatCode.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(FormatCode.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (FormatCode x : FormatCode.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private FormatCode(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

