/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.enums.r202406;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum AuditTrailConsumptionEventType implements ValueSetEnumInterface
{
    ACCESSING_THE_PATIENT_AUDIT_RECORD_REPOSITORY("ATC_LOG_READ", "2.16.756.5.30.1.127.3.10.7", "Accessing the Patient Audit Record Repository", "Accessing the Patient Audit Record Repository", "Auf die patientenbezogene Auditprotokoll-Ablage zugreifen", "En cours d\u2019acc\u00e8s au d\u00e9p\u00f4t de contr\u00f4le des dossiers de patients", "Accesso all'Audit Record Repository del paziente"),
    ASSIGN_A_HEALTHCARE_PROFESSIONAL_TO_BLACKLIST("ATC_POL_INCL_BLACKLIST", "2.16.756.5.30.1.127.3.10.7", "Assign a Healthcare Professional to Blacklist", "Assign a Healthcare Professional to Blacklist", "Gesundheitsfachperson auf die schwarze Liste setzen", "Ajouter un professionnel de la sant\u00e9 \u00e0 la liste noire", "Aggiungere un professionista della salute alla lista nera"),
    AUTHORIZE_PARTICIPANTS_TO_ACCESS_LEVEL_DATE("ATC_POL_CREATE_AUT_PART_AL", "2.16.756.5.30.1.127.3.10.7", "Authorize participants to access level/date", "Authorize participants to access level/date", "Teilnehmende f\u00fcr Zugriffsstufe/Datum autorisieren", "Autoriser les participants pour ce niveau d\u2019acc\u00e8s / \u00e0 cette date", "Autorizzare i partecipanti ad accedere a un livello/una data"),
    DISABLING_EMERGENCY_ACCESS("ATC_POL_DIS_EMER_USE", "2.16.756.5.30.1.127.3.10.7", "Disabling Emergency Access", "Disabling Emergency Access", "Notfall-Zugriff deaktivieren", "D\u00e9sactiver l\u2019acc\u00e8s d\u2019urgence", "Disabilitare l'accesso di emergenza"),
    DOCUMENT_OR_DOCUMENT_METADATA_UPDATE("ATC_DOC_UPDATE", "2.16.756.5.30.1.127.3.10.7", "Document or Document Metadata update", "Document or Document Metadata update", "Dokument- oder Dokument-Metadaten-Aktualisierung", "Mise \u00e0 jour de documents ou de m\u00e9tadonn\u00e9es de documents", "Aggiornamento di un documento o dei metadati di un documento"),
    DOCUMENT_REMOVAL("ATC_DOC_DELETE", "2.16.756.5.30.1.127.3.10.7", "Document removal", "Document removal", "Dokumentl\u00f6schung", "Suppression de documents", "Rimozione di un documento"),
    DOCUMENT_RETRIEVAL("ATC_DOC_READ", "2.16.756.5.30.1.127.3.10.7", "Document retrieval", "Document retrieval", "Dokumentabruf", "R\u00e9cup\u00e9ration de documents", "Ricerca di un documento"),
    DOCUMENT_SEARCH("ATC_DOC_SEARCH", "2.16.756.5.30.1.127.3.10.7", "Document search", "Document search", "Dokumentensuche", "Recherche de documents", "Ricerca documenti"),
    DOCUMENT_UPLOAD("ATC_DOC_CREATE", "2.16.756.5.30.1.127.3.10.7", "Document upload", "Document upload", "Dokument-Upload", "Chargement de documents", "Upload di un documento"),
    ENABLING_EMERGENCY_ACCESS("ATC_POL_ENA_EMER_USE", "2.16.756.5.30.1.127.3.10.7", "Enabling Emergency Access", "Enabling Emergency Access", "Notfall-Zugriff aktivieren", "Autoriser l\u2019acc\u00e8s d\u2019urgence", "Abilitare l'accesso di emergenza"),
    ENTRY_OF_HEALTHCARE_PROFESSIONALS_INTO_A_GROUP("ATC_HPD_GROUP_ENTRY_NOTIFY", "2.16.756.5.30.1.127.3.10.7", "Entry of healthcare professionals into a group", "Entry of healthcare professionals into a group", "Aufnahme von Gesundheitsfachpersonal in eine Gruppe", "Entr\u00e9e des professionnels de sant\u00e9 dans un groupe", "Inserimento di operatori sanitari in un gruppo"),
    EXCLUDE_A_HEALTHCARE_PROFESSIONAL_FROM_BLACKLIST("ATC_POL_EXL_BLACKLIST", "2.16.756.5.30.1.127.3.10.7", "Exclude a Healthcare Professional from Blacklist", "Exclude a Healthcare Professional from Blacklist", "Gesundheitsfachperson von der schwarzen Liste streichen", "Retirer un professionnel de la sant\u00e9 de la liste noire", "Rimuovere un professionista della salute dalla lista nera"),
    REMOVE_AUTHORIZATION_FOR_PARTICIPANTS_TO_ACCESS_LEVEL_DATE("ATC_POL_REMOVE_AUT_PART_AL", "2.16.756.5.30.1.127.3.10.7", "Remove authorization for participants to access level/date", "Remove authorization for participants to access level/date", "Autorisierung von Teilnehmenden f\u00fcr Zugriffsstufe/Datum aufheben", "Supprimer l\u2019autorisation des participants \u00e0 ce niveau d\u2019acc\u00e8s / \u00e0 cette date", "Rimuovere l'autorizzazione di accesso dei partecipanti al livello/alla data"),
    SET_OR_UPDATE_THE_DEFAULT_CONFIDENTIALITY_LEVEL_FOR_NEW_DOCUMENTS("ATC_POL_DEF_CONFLEVEL", "2.16.756.5.30.1.127.3.10.7", "Set or update the default Confidentiality Level for new documents", "Set or update the default Confidentiality Level for new documents", "Standard-Vertraulichkeitsstufe f\u00fcr neue Dokumente setzen oder aktualisieren", "D\u00e9finir ou mettre \u00e0 jour le niveau de confidentialit\u00e9 pour les nouveaux documents", "Impostare o aggiornare il livello di confidenzialit\u00e0 di default per i documenti nuovi"),
    UPDATE_ACCESS_LEVEL_DATE_OF_AUTHORIZED_PARTICIPANTS("ATC_POL_UPDATE_AUT_PART_AL", "2.16.756.5.30.1.127.3.10.7", "Update access level/date of authorized participants", "Update access level/date of authorized participants", "Zugriffsstufe/Datum autorisierter Teilnehmender aktualisieren", "Mettre \u00e0 jour le niveau d\u2019acc\u00e8s / la date des participants autoris\u00e9s", "Aggiornare il livello/la data di accesso dei partecipanti autorizzati");

    public static final String ACCESSING_THE_PATIENT_AUDIT_RECORD_REPOSITORY_CODE = "ATC_LOG_READ";
    public static final String ASSIGN_A_HEALTHCARE_PROFESSIONAL_TO_BLACKLIST_CODE = "ATC_POL_INCL_BLACKLIST";
    public static final String AUTHORIZE_PARTICIPANTS_TO_ACCESS_LEVEL_DATE_CODE = "ATC_POL_CREATE_AUT_PART_AL";
    public static final String DISABLING_EMERGENCY_ACCESS_CODE = "ATC_POL_DIS_EMER_USE";
    public static final String DOCUMENT_OR_DOCUMENT_METADATA_UPDATE_CODE = "ATC_DOC_UPDATE";
    public static final String DOCUMENT_REMOVAL_CODE = "ATC_DOC_DELETE";
    public static final String DOCUMENT_RETRIEVAL_CODE = "ATC_DOC_READ";
    public static final String DOCUMENT_SEARCH_CODE = "ATC_DOC_SEARCH";
    public static final String DOCUMENT_UPLOAD_CODE = "ATC_DOC_CREATE";
    public static final String ENABLING_EMERGENCY_ACCESS_CODE = "ATC_POL_ENA_EMER_USE";
    public static final String ENTRY_OF_HEALTHCARE_PROFESSIONALS_INTO_A_GROUP_CODE = "ATC_HPD_GROUP_ENTRY_NOTIFY";
    public static final String EXCLUDE_A_HEALTHCARE_PROFESSIONAL_FROM_BLACKLIST_CODE = "ATC_POL_EXL_BLACKLIST";
    public static final String REMOVE_AUTHORIZATION_FOR_PARTICIPANTS_TO_ACCESS_LEVEL_DATE_CODE = "ATC_POL_REMOVE_AUT_PART_AL";
    public static final String SET_OR_UPDATE_THE_DEFAULT_CONFIDENTIALITY_LEVEL_FOR_NEW_DOCUMENTS_CODE = "ATC_POL_DEF_CONFLEVEL";
    public static final String UPDATE_ACCESS_LEVEL_DATE_OF_AUTHORIZED_PARTICIPANTS_CODE = "ATC_POL_UPDATE_AUT_PART_AL";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.3.10.13.2";
    public static final String VALUE_SET_NAME = "EprAuditTrailConsumptionEventType";
    public static final String CODE_SYSTEM_ID = "2.16.756.5.30.1.127.3.10.7";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable AuditTrailConsumptionEventType getEnum(@Nullable String code) {
        for (AuditTrailConsumptionEventType x : AuditTrailConsumptionEventType.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(AuditTrailConsumptionEventType.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (AuditTrailConsumptionEventType x : AuditTrailConsumptionEventType.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private AuditTrailConsumptionEventType(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

