/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.enums.r202212;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum MimeType implements ValueSetEnumInterface
{
    CDA_LEVEL_1_MULTIPART("multipart/x-hl7-cda-level1", "2.16.840.1.113883.5.79", "CDA Level 1 Multipart", "CDA Level 1 Multipart", "CDA Level 1 Multipart", "CDA Level 1 Multipart", "CDA Level 1 Multipart"),
    CSV_COMMA_SEPARATED_VALUES("text/csv", "2.16.840.1.113883.5.79", "CSV Comma-separated Values", "CSV Comma-separated Values", "CSV Comma-separated Values", "CSV Comma-separated Values", "CSV Comma-separated Values"),
    DICOM("application/dicom", "2.16.840.1.113883.5.79", "DICOM", "DICOM", "DICOM", "DICOM", "DICOM"),
    EXTENSIBLE_3D_GRAPHICS_VRML("model/x3d-vrml", "2.16.840.1.113883.5.79", "Extensible 3D Graphics (VRML)", "Extensible 3D Graphics (VRML)", "Extensible 3D Graphics (VRML)", "Extensible 3D Graphics (VRML)", "Extensible 3D Graphics (VRML)"),
    EXTENSIBLE_3D_GRAPHICS_XML("model/x3d+xml", "2.16.840.1.113883.5.79", "Extensible 3D Graphics (XML)", "Extensible 3D Graphics (XML)", "Extensible 3D Graphics (XML)", "Extensible 3D Graphics (XML)", "Extensible 3D Graphics (XML)"),
    FHIR_JSON("application/fhir+json", "2.16.840.1.113883.5.79", "FHIR (JSON)", "FHIR (JSON)", "FHIR (JSON)", "FHIR (JSON)", "FHIR (JSON)"),
    FHIR_XML("application/fhir+xml", "2.16.840.1.113883.5.79", "FHIR (XML)", "FHIR (XML)", "FHIR (XML)", "FHIR (XML)", "FHIR (XML)"),
    GIF_GRAPHICS_INTERCHANGE_FORMAT("image/gif", "2.16.840.1.113883.5.79", "GIF Graphics Interchange Format", "GIF Graphics Interchange Format", "GIF Graphics Interchange Format", "GIF Graphics Interchange Format", "GIF Graphics Interchange Format"),
    JPEG_2000_COMPOUND_IMAGE_FILE("image/jpm", "2.16.840.1.113883.5.79", "JPEG 2000 Compound Image File", "JPEG 2000 Compound Image File", "JPEG 2000 Compound Image File", "JPEG 2000 Compound Image File", "JPEG 2000 Compound Image File"),
    JPEG_2000_CORE_IMAGE_FILE("image/jp2", "2.16.840.1.113883.5.79", "JPEG 2000 Core Image File", "JPEG 2000 Core Image File", "JPEG 2000 Core Image File", "JPEG 2000 Core Image File", "JPEG 2000 Core Image File"),
    JPEG_2000_IMAGE_FILE("image/jpx", "2.16.840.1.113883.5.79", "JPEG 2000 Image File", "JPEG 2000 Image File", "JPEG 2000 Image File", "JPEG 2000 Image File", "JPEG 2000 Image File"),
    JPEG_IMAGE("image/jpeg", "2.16.840.1.113883.5.79", "JPEG Image", "JPEG Image", "JPEG Image", "JPEG Image", "JPEG Image"),
    MOTION_JPEG_2000("video/mj2", "2.16.840.1.113883.5.79", "Motion JPEG 2000", "Motion JPEG 2000", "Motion JPEG 2000", "Motion JPEG 2000", "Motion JPEG 2000"),
    MP4_AUDIO("audio/mp4", "2.16.840.1.113883.5.79", "MP4 Audio", "MP4 Audio", "MP4 Audio", "MP4 Audio", "MP4 Audio"),
    MPEG_4_PART_14("video/mp4", "2.16.840.1.113883.5.79", "MPEG-4 Part 14", "MPEG-4 Part 14", "MPEG-4 Part 14", "MPEG-4 Part 14", "MPEG-4 Part 14"),
    MPEG_AUDIO_LAYER_3("audio/mpeg", "2.16.840.1.113883.5.79", "MPEG audio layer 3", "MPEG audio layer 3", "MPEG audio layer 3", "MPEG audio layer 3", "MPEG audio layer 3"),
    MPEG_VIDEO("video/mpeg", "2.16.840.1.113883.5.79", "MPEG Video", "MPEG Video", "MPEG Video", "MPEG Video", "MPEG Video"),
    MULTILINGUAL_MULTIPART("multipart/multilingual", "2.16.840.1.113883.5.79", "Multilingual Multipart", "Multilingual Multipart", "Multilingual Multipart", "Multilingual Multipart", "Multilingual Multipart"),
    PDF("application/pdf", "2.16.840.1.113883.5.79", "PDF", "PDF", "PDF", "PDF", "PDF"),
    PLAIN_TEXT("text/plain", "2.16.840.1.113883.5.79", "Plain Text", "Plain Text", "Plain Text", "Plain Text", "Plain Text"),
    PNG_PORTABLE_NETWORK_GRAPHICS("image/png", "2.16.840.1.113883.5.79", "PNG Portable Network Graphics", "PNG Portable Network Graphics", "PNG Portable Network Graphics", "PNG Portable Network Graphics", "PNG Portable Network Graphics"),
    SIGNED_MULTIPART("multipart/signed", "2.16.840.1.113883.5.79", "Signed Multipart", "Signed Multipart", "Signed Multipart", "Signed Multipart", "Signed Multipart"),
    TIFF_IMAGE("image/tiff", "2.16.840.1.113883.5.79", "TIFF Image", "TIFF Image", "TIFF Image", "TIFF Image", "TIFF Image"),
    VIRTUAL_REALITY_MODELING_LANGUAGE("model/vrml", "2.16.840.1.113883.5.79", "Virtual Reality Modeling Language", "Virtual Reality Modeling Language", "Virtual Reality Modeling Language", "Virtual Reality Modeling Language", "Virtual Reality Modeling Language"),
    XML_TEXT("text/xml", "2.16.840.1.113883.5.79", "XML-Text", "XML-Text", "XML-Text", "XML-Text", "XML-Text");

    public static final String CDA_LEVEL_1_MULTIPART_CODE = "multipart/x-hl7-cda-level1";
    public static final String CSV_COMMA_SEPARATED_VALUES_CODE = "text/csv";
    public static final String DICOM_CODE = "application/dicom";
    public static final String EXTENSIBLE_3D_GRAPHICS_VRML_CODE = "model/x3d-vrml";
    public static final String EXTENSIBLE_3D_GRAPHICS_XML_CODE = "model/x3d+xml";
    public static final String FHIR_JSON_CODE = "application/fhir+json";
    public static final String FHIR_XML_CODE = "application/fhir+xml";
    public static final String GIF_GRAPHICS_INTERCHANGE_FORMAT_CODE = "image/gif";
    public static final String JPEG_2000_COMPOUND_IMAGE_FILE_CODE = "image/jpm";
    public static final String JPEG_2000_CORE_IMAGE_FILE_CODE = "image/jp2";
    public static final String JPEG_2000_IMAGE_FILE_CODE = "image/jpx";
    public static final String JPEG_IMAGE_CODE = "image/jpeg";
    public static final String MOTION_JPEG_2000_CODE = "video/mj2";
    public static final String MP4_AUDIO_CODE = "audio/mp4";
    public static final String MPEG_4_PART_14_CODE = "video/mp4";
    public static final String MPEG_AUDIO_LAYER_3_CODE = "audio/mpeg";
    public static final String MPEG_VIDEO_CODE = "video/mpeg";
    public static final String MULTILINGUAL_MULTIPART_CODE = "multipart/multilingual";
    public static final String PDF_CODE = "application/pdf";
    public static final String PLAIN_TEXT_CODE = "text/plain";
    public static final String PNG_PORTABLE_NETWORK_GRAPHICS_CODE = "image/png";
    public static final String SIGNED_MULTIPART_CODE = "multipart/signed";
    public static final String TIFF_IMAGE_CODE = "image/tiff";
    public static final String VIRTUAL_REALITY_MODELING_LANGUAGE_CODE = "model/vrml";
    public static final String XML_TEXT_CODE = "text/xml";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.3.10.1.16";
    public static final String VALUE_SET_NAME = "DocumentEntry.mimeType";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.5.79";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable MimeType getEnum(@Nullable String code) {
        for (MimeType x : MimeType.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(MimeType.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (MimeType x : MimeType.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private MimeType(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

