/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.enums.r202212;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum HealthcareFacilityTypeCode implements ValueSetEnumInterface
{
    ACCIDENT_AND_EMERGENCY_DEPARTMENT("225728007", "2.16.840.1.113883.6.96", "Accident and Emergency department (environment)", "Accident and Emergency department", "Notfall-/Rettungsdienste", "Service d'urgence et de sauvetage", "Servizio di pronto soccorso e di salvataggio"),
    AMBULATORY_CARE_SITE("35971002", "2.16.840.1.113883.6.96", "Ambulatory care site (environment)", "Ambulatory care site", "Ambulante Einrichtung/Ambulatorium", "Etablissement ambulatoire", "Struttura ambulatoriale, incl. gli studi medici"),
    CLIENT_OR_PATIENT_HOME("394778007", "2.16.840.1.113883.6.96", "Client's or patient's home (environment)", "Client's or patient's home", "Domizil des Patienten", "Domicile du patient", "Domicilio del paziente"),
    DIAGNOSTIC_INSTITUTION("722171005", "2.16.840.1.113883.6.96", "Diagnostic institution (environment)", "Diagnostic institution", "Institution f\u00fcr medizinische Diagnostik", "Institut d\u2019aide au diagnostic", "Istituto di diagnostica medica"),
    GENERAL_PRACTICE_PREMISES("264358009", "2.16.840.1.113883.6.96", "General practice premises (environment)", "General practice premises", "Arztpraxis", "Cabinet m\u00e9dical", "Studio medico"),
    HEALTH_AUTHORITY("394747008", "2.16.840.1.113883.6.96", "Health Authority (qualifier value)", "Health Authority", "Gesundheitsbeh\u00f6rde", "Autorit\u00e9 sanitaire", "Autorit\u00e0 sanitaria"),
    HOSPITAL("22232009", "2.16.840.1.113883.6.96", "Hospital (environment)", "Hospital", "Station\u00e4re Einrichtung/Spital", "H\u00f4pital", "Ospedale"),
    MILITARY_HEALTH_INSTITUTION("722172003", "2.16.840.1.113883.6.96", "Military health institution (environment)", "Military health institution", "Armee\u00e4rztliche Dienste", "Service sanitaire de l'arm\u00e9e", "Servizio di medicina militare"),
    NURSING_HOME("42665001", "2.16.840.1.113883.6.96", "Nursing home (environment)", "Nursing home", "Pflegeheim", "Etablissement m\u00e9dico-social", "Casa di cura"),
    OTHER_SITE_OF_CARE("43741000", "2.16.840.1.113883.6.96", "Site of care (environment)", "Other Site of Care", "Andere Gesundheitsorganisation", "Autres prestataires de soins", "Altre organizzazioni sanitarie"),
    PHARMACY("264372000", "2.16.840.1.113883.6.96", "Pharmacy (environment)", "Pharmacy", "Apotheke", "Pharmacie", "Farmacia"),
    PRISON_BASED_CARE_SITE("722173008", "2.16.840.1.113883.6.96", "Prison based care site (environment)", "Prison based care site", "Gesundheitseinrichtung in der Haftanstalt", "Service de sant\u00e9 en milieu carc\u00e9ral", "Struttura sanitaria in uno stabilimento carcerario"),
    PRIVATE_HOME_BASED_CARE("66280005", "2.16.840.1.113883.6.96", "Private home-based care (environment)", "Private home-based care", "Organisation f\u00fcr Pflege zu Hause", "Soins \u00e0 domicile", "Servizio di assistenza e cura a domicilio"),
    REHABILITATION_HOSPITAL("80522000", "2.16.840.1.113883.6.96", "Rehabilitation hospital (environment)", "Rehabilitation hospital", "Organisation f\u00fcr station\u00e4re Rehabilitation", "R\u00e9adaptation stationnaire", "Istituto di riabilitazione stazionaria"),
    TELEMEDICINE_INSTITUTION("288565001", "2.16.840.1.113883.6.96", "Medical center (environment)", "Telemedicine institution", "Telemedizinische Einrichtung", "Institut de t\u00e9l\u00e9m\u00e9decine", "Centro di telemedicina");

    public static final String ACCIDENT_AND_EMERGENCY_DEPARTMENT_CODE = "225728007";
    public static final String AMBULATORY_CARE_SITE_CODE = "35971002";
    public static final String CLIENT_OR_PATIENT_HOME_CODE = "394778007";
    public static final String DIAGNOSTIC_INSTITUTION_CODE = "722171005";
    public static final String GENERAL_PRACTICE_PREMISES_CODE = "264358009";
    public static final String HEALTH_AUTHORITY_CODE = "394747008";
    public static final String HOSPITAL_CODE = "22232009";
    public static final String MILITARY_HEALTH_INSTITUTION_CODE = "722172003";
    public static final String NURSING_HOME_CODE = "42665001";
    public static final String OTHER_SITE_OF_CARE_CODE = "43741000";
    public static final String PHARMACY_CODE = "264372000";
    public static final String PRISON_BASED_CARE_SITE_CODE = "722173008";
    public static final String PRIVATE_HOME_BASED_CARE_CODE = "66280005";
    public static final String REHABILITATION_HOSPITAL_CODE = "80522000";
    public static final String TELEMEDICINE_INSTITUTION_CODE = "288565001";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.3.10.1.11";
    public static final String VALUE_SET_NAME = "DocumentEntry.healthcareFacilityTypeCode";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.6.96";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable HealthcareFacilityTypeCode getEnum(@Nullable String code) {
        for (HealthcareFacilityTypeCode x : HealthcareFacilityTypeCode.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(HealthcareFacilityTypeCode.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (HealthcareFacilityTypeCode x : HealthcareFacilityTypeCode.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private HealthcareFacilityTypeCode(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

