/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.enums.r202104;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum TypeCode implements ValueSetEnumInterface
{
    ALLERGY_RECORD("722446000", "2.16.840.1.113883.6.96", "Allergy record (record artifact)", "Allergy record", "Allergieausweis", "Carnet des allergies", "Passaporto delle allergie"),
    CLINICAL_MANAGEMENT_PLAN("737427001", "2.16.840.1.113883.6.96", "Clinical management plan (record artifact)", "Clinical Management plan", "Behandlungsplan", "Plan de traitement", "Piano di trattamento"),
    CONSULTATION_REPORT("371530004", "2.16.840.1.113883.6.96", "Clinical consultation report (record artifact)", "Consultation report", "Beurteilung durch Fachspezialisten", "\u00c9valuation par des sp\u00e9cialistes", "Valutazione dello specialista"),
    DISCHARGE_SUMMARY("373942005", "2.16.840.1.113883.6.96", "Discharge summary (record artifact)", "Discharge summary", "Austrittsbericht", "Rapport de sortie", "Rapporto di dimissione"),
    EMERGENCY_DEPARTMENT_RECORD("445300006", "2.16.840.1.113883.6.96", "Emergency department record (record artifact)", "Emergency department record", "Notfallberichtt", "Rapport d\u2019urgence", "Referto di pronto soccorso"),
    HISTORY_AND_PHYSICAL_REPORT("371529009", "2.16.840.1.113883.6.96", "History and physical report (record artifact)", "History and physical report", "Anamnese / Untersuchungsbericht", "Anamn\u00e8se / rapport d\u2019analyse", "Anamnesi / Rapporto di visita medica"),
    IMAGE("900000000000471006", "2.16.840.1.113883.6.96", "Image reference (foundation metadata concept)", "Image", "Bild", "Image", "Immagine"),
    IMAGING_ORDER("2161000195103", "2.16.756.5.30.1.127.3.4", "Imaging order (record artifact)", "Imaging Order", "Bildgebungsauftrag", "Mandat d\u2019imagerie", "Richiesta di immaginografia"),
    IMAGING_REPORT("4201000179104", "2.16.840.1.113883.6.96", "Imaging report (record artifact)", "Imaging report", "Befundbericht zur Bildgebung", "Rapport de r\u00e9sultat relatif \u00e0 l\u2019imagerie", "Referto di immaginografia"),
    IMMUNIZATION_RECORD("41000179103", "2.16.840.1.113883.6.96", "Immunization record (record artifact)", "Immunization record", "Impfausweis", "Carnet de vaccination", "Certificato di vaccinazione"),
    LABORATORY_ORDER("721965002", "2.16.840.1.113883.6.96", "Laboratory order (record artifact)", "Laboratory Order", "Laborauftrag", "Mandat d\u2019analyse en laboratoire", "Richiesta di analisi di laboratorio"),
    LABORATORY_REPORT("4241000179101", "2.16.840.1.113883.6.96", "Laboratory report (record artifact)", "Laboratory report", "Laborbericht", "Rapport de laboratoire", "Referto di laboratorio"),
    MEDICAL_CERTIFICATE("772786005", "2.16.840.1.113883.6.96", "Medical certificate (record artifact)", "Medical certificate", "\u00c4rztliches Attest", "Certificat m\u00e9dical", "Certificato medico"),
    MEDICAL_PRESCRIPTION_RECORD("761938008", "2.16.840.1.113883.6.96", "Medical prescription record (record artifact)", "Medical Prescription record", "Arzneimittel-Verschreibung / Rezept", "Prescription de m\u00e9dicaments / ordonnance", "Prescrizione di medicamenti"),
    MEDICATION_SUMMARY_DOCUMENT("721912009", "2.16.840.1.113883.6.96", "Medication summary document (record artifact)", "Medication summary document", "Medikationsliste", "Liste de m\u00e9dication", "Elenco dei medicamenti"),
    NON_DRUG_PRESCRIPTION("765492005", "2.16.840.1.113883.6.96", "Non-drug prescription record (record artifact)", "Non-drug prescription", "Nicht-Arzneimittel-Verschreibung / Rezept", "Prescription sans m\u00e9dicaments / ordonnance", "Prescrizione non di medicamenti"),
    NURSING_CARE_PLAN("773130005", "2.16.840.1.113883.6.96", "Nursing care plan (record artifact)", "Nursing care plan", "Pflegeplan", "Plan de soins", "Piano di cura"),
    OPERATIVE_REPORT("371526002", "2.16.840.1.113883.6.96", "Operative report (record artifact)", "Operative report", "Operationsbericht", "Rapport d\u2019op\u00e9ration", "Rapporto operatorio"),
    PATHOLOGY_ORDER("721966001", "2.16.840.1.113883.6.96", "Pathology order (record artifact)", "Pathology order", "Pathologieauftrag", "Mandat de rapport d\u2019examen pathologique ", "Richiesta di esame istologico"),
    PATHOLOGY_REPORT("371528001", "2.16.840.1.113883.6.96", "Pathology report (record artifact)", "Pathology report", "Pathologiebericht", "Rapport d\u2019examen pathologique", "Referto istologico"),
    PROFESSIONAL_ALLIED_TO_MEDICINE_CLINICAL_REPORT("445418005", "2.16.840.1.113883.6.96", "Professional allied to medicine clinical report (record artifact)", "Professional allied to medicine clinical report", "Dokument ausserhalb des Behandlungskontextes", "Document hors contexte de traitement", "Documento al di fuori del contesto trattato"),
    PROGRESS_NOTE("371532007", "2.16.840.1.113883.6.96", "Progress report (record artifact)", "Progress note", "Verlaufsbericht", "Rapport d\u2019historique", "Rapporto sul decorso"),
    RECORD_ARTIFACT("419891008", "2.16.840.1.113883.6.96", "Record artifact (record artifact)", "Record artifact", "Nicht n\u00e4her bezeichnetes Dokument", "Document non pr\u00e9cis\u00e9", "Documento non meglio specificato"),
    REHABILITATION_CARE_PLAN("736055001", "2.16.840.1.113883.6.96", "Rehabilitation care plan (record artifact)", "Rehabilitation care plan", "Rehabilitationsplan", "Plan de r\u00e9habilitation", "Piano di riabilitazione"),
    TRANSFER_SUMMARY_REPORT("371535009", "2.16.840.1.113883.6.96", "Transfer summary report (record artifact)", "Transfer summary report", "\u00dcberweisungsbericht", "Rapport de transfert", "Rapporto di trasferimento");

    public static final String ALLERGY_RECORD_CODE = "722446000";
    public static final String CLINICAL_MANAGEMENT_PLAN_CODE = "737427001";
    public static final String CONSULTATION_REPORT_CODE = "371530004";
    public static final String DISCHARGE_SUMMARY_CODE = "373942005";
    public static final String EMERGENCY_DEPARTMENT_RECORD_CODE = "445300006";
    public static final String HISTORY_AND_PHYSICAL_REPORT_CODE = "371529009";
    public static final String IMAGE_CODE = "900000000000471006";
    public static final String IMAGING_ORDER_CODE = "2161000195103";
    public static final String IMAGING_REPORT_CODE = "4201000179104";
    public static final String IMMUNIZATION_RECORD_CODE = "41000179103";
    public static final String LABORATORY_ORDER_CODE = "721965002";
    public static final String LABORATORY_REPORT_CODE = "4241000179101";
    public static final String MEDICAL_CERTIFICATE_CODE = "772786005";
    public static final String MEDICAL_PRESCRIPTION_RECORD_CODE = "761938008";
    public static final String MEDICATION_SUMMARY_DOCUMENT_CODE = "721912009";
    public static final String NON_DRUG_PRESCRIPTION_CODE = "765492005";
    public static final String NURSING_CARE_PLAN_CODE = "773130005";
    public static final String OPERATIVE_REPORT_CODE = "371526002";
    public static final String PATHOLOGY_ORDER_CODE = "721966001";
    public static final String PATHOLOGY_REPORT_CODE = "371528001";
    public static final String PROFESSIONAL_ALLIED_TO_MEDICINE_CLINICAL_REPORT_CODE = "445418005";
    public static final String PROGRESS_NOTE_CODE = "371532007";
    public static final String RECORD_ARTIFACT_CODE = "419891008";
    public static final String REHABILITATION_CARE_PLAN_CODE = "736055001";
    public static final String TRANSFER_SUMMARY_REPORT_CODE = "371535009";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.3.10.1.27";
    public static final String VALUE_SET_NAME = "DocumentEntry.typeCode";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable TypeCode getEnum(@Nullable String code) {
        for (TypeCode x : TypeCode.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(TypeCode.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (TypeCode x : TypeCode.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private TypeCode(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

