/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.enums.r202104;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum EventCodeList implements ValueSetEnumInterface
{
    AUTOREFRACTION("AR", "1.2.840.10008.2.16.4", "Autorefraction", "Autorefraction", "Autorefraktion", "Autor\u00e9fraction", "Autorifrazione"),
    BONE_MINERAL_DENSITOMETRY("BMD", "1.2.840.10008.2.16.4", "Bone Mineral Densitometry", "Bone Mineral Densitometry", "Knochenmineraldensitometrie", "Densitom\u00e9trie min\u00e9rale osseuse", "Mineralometria ossea computerizzata"),
    CARDIAC_ELECTROPHYSIOLOGY("EPS", "1.2.840.10008.2.16.4", "Cardiac Electrophysiology", "Cardiac Electrophysiology", "Herz-Elektrophysiologie", "\u00c9lectrophysiologie cardiaque", "Elettrofisiologia cardiaca"),
    COMPUTED_RADIOGRAPHY("CR", "1.2.840.10008.2.16.4", "Computed Radiography", "Computed Radiography", "Computerradiografie", "Radiographie num\u00e9rique", "Radiografia computerizzata"),
    COMPUTED_TOMOGRAPHY("CT", "1.2.840.10008.2.16.4", "Computed Tomography", "Computed Tomography", "Computertomografie", "Tomographie num\u00e9rique", "Tomografia computerizzata"),
    DIGITAL_RADIOGRAPHY("DX", "1.2.840.10008.2.16.4", "Digital Radiography", "Digital Radiography", "Digitales R\u00f6ntgen", "Radiologie num\u00e9rique", "Radiografia digitale"),
    ELECTROCARDIOGRAPHY("ECG", "1.2.840.10008.2.16.4", "Electrocardiography", "Electrocardiography", "Elektrokardiografie", "\u00c9lectrocardiographie", "Elettrocardiografia"),
    ENDOSCOPY("ES", "1.2.840.10008.2.16.4", "Endoscopy", "Endoscopy", "Endoskopie", "Endoscopie", "Endoscopia"),
    EXTERNAL_CAMERA_PHOTOGRAPHY("XC", "1.2.840.10008.2.16.4", "External-camera Photography", "External-camera Photography", "Fotografie mit externer Kamera", "Photographie par appareil externe", "Fotografia con fotocamera esterna"),
    GENERAL_MICROSCOPY("GM", "1.2.840.10008.2.16.4", "General Microscopy", "General Microscopy", "Allgemeine Mikroskopie", "Microscopie g\u00e9n\u00e9rale", "Microscopia generale"),
    HEMODYNAMIC_WAVEFORM("HD", "1.2.840.10008.2.16.4", "Hemodynamic Waveform", "Hemodynamic Waveform", "H\u00e4modynamische Druckkurve", "Courbe h\u00e9modynamique", "Monitoraggio emodinamico"),
    INTRAVASCULAR_OPTICAL_COHERENCE_TOMOGRAPHY("IVOCT", "1.2.840.10008.2.16.4", "Intravascular Optical Coherence Tomography", "Intravascular Optical Coherence Tomography", "Intravaskul\u00e4re optische Koh\u00e4renztomografie", "Tomographie en coh\u00e9rence optique intravasculaire", "Tomografia intravascolare a coerenza ottica"),
    INTRAVASCULAR_ULTRASOUND("IVUS", "1.2.840.10008.2.16.4", "Intravascular Ultrasound", "Intravascular Ultrasound", "Intravaskul\u00e4rer Ultraschall", "Ultrason intravasculaire", "Ecografia intravascolare"),
    INTRA_ORAL_RADIOGRAPHY("IO", "1.2.840.10008.2.16.4", "Intra-oral Radiography", "Intra-oral Radiography", "Intraorales R\u00f6ntgen", "Radiographie intra-orale", "Radiografia intraorale"),
    KERATOMETRY("KER", "1.2.840.10008.2.16.4", "Keratometry", "Keratometry", "Keratometrie", "K\u00e9ratom\u00e9trie", "Cheratometria"),
    LENSOMETRY("LEN", "1.2.840.10008.2.16.4", "Lensometry", "Lensometry", "Linsenmessung", "Lensom\u00e9trie", "Focometria"),
    MAGNETIC_RESONANCE("MR", "1.2.840.10008.2.16.4", "Magnetic Resonance", "Magnetic Resonance", "Magnetresonanz", "R\u00e9sonance magn\u00e9tique", "Risonanza magnetica"),
    MAMMOGRAPHY("MG", "1.2.840.10008.2.16.4", "Mammography", "Mammography", "Mammografie", "Mammographie", "Mammografia"),
    NUCLEAR_MEDICINE("NM", "1.2.840.10008.2.16.4", "Nuclear Medicine", "Nuclear Medicine", "Nuklearmedizin", "M\u00e9decine nucl\u00e9aire", "Medicina nucleare"),
    OPHTHALMIC_AXIAL_MEASUREMENTS("OAM", "1.2.840.10008.2.16.4", "Ophthalmic Axial Measurements", "Ophthalmic Axial Measurements", "Augenachsenmessungen", "Mesures axiales ophtalmiques", "Misurazioni oftalmiche assiali"),
    OPHTHALMIC_MAPPING("OPM", "1.2.840.10008.2.16.4", "Ophthalmic Mapping", "Ophthalmic Mapping", "Augenkartierung", "Cartographie ophtalmique", "Mappatura oftalmica"),
    OPHTHALMIC_PHOTOGRAPHY("OP", "1.2.840.10008.2.16.4", "Ophthalmic Photography", "Ophthalmic Photography", "Augenfotografie", "Photographie ophtalmique", "Fotografia oftalmica"),
    OPHTHALMIC_REFRACTION("OPR", "1.2.840.10008.2.16.4", "Ophthalmic Refraction", "Ophthalmic Refraction", "Augenrefraktion", "R\u00e9fraction ophtalmique", "Rifrazione oggettiva"),
    OPHTHALMIC_TOMOGRAPHY("OPT", "1.2.840.10008.2.16.4", "Ophthalmic Tomography", "Ophthalmic Tomography", "Augentomografie", "Tomographie ophtalmique", "Tomografia ottica computerizzata"),
    OPHTHALMIC_TOMOGRAPHY_B_SCAN_VOLUME_ANALYSIS("OPTBSV", "1.2.840.10008.2.16.4", "Ophthalmic Tomography B-scan Volume Analysis", "Ophthalmic Tomography B-scan Volume Analysis", "Ophthalmologische Tomographie B-Scan Volumenanalyse", "Analyse du volume de la tomographie ophtalmique B-scan", "Analisi del volume della scansione B della tomografia oftalmica"),
    OPHTHALMIC_TOMOGRAPHY_EN_FACE("OPTENF", "1.2.840.10008.2.16.4", "Ophthalmic Tomography En Face", "Ophthalmic Tomography En Face", "Ophthalmische Tomographie En Face", "Tomographie ophtalmique en face", "Tomografia oftalmica En Face"),
    OPHTHALMIC_VISUAL_FIELD("OPV", "1.2.840.10008.2.16.4", "Ophthalmic Visual Field", "Ophthalmic Visual Field", "Gesichtsfeld der Augen", "Champ visuel ophtalmique", "Perimetria computerizzata"),
    OPTICAL_COHERENCE_TOMOGRAPHY("OCT", "1.2.840.10008.2.16.4", "Optical Coherence Tomography", "Optical Coherence Tomography", "Optische Koh\u00e4renztomografie", "Tomographie en coh\u00e9rence optique", "Tomografia a coerenza ottica"),
    OPTICAL_SURFACE_SCANNER("OSS", "1.2.840.10008.2.16.4", "Optical Surface Scanner", "Optical Surface Scanner", "Optischer Oberfl\u00e4chenscanner", "Scanneur optique de surface", "Scanner ottico per superfici"),
    PANORAMIC_X_RAY("PX", "1.2.840.10008.2.16.4", "Panoramic X-Ray", "Panoramic X-Ray", "Panoramar\u00f6ntgen", "Radiographie panoramique", "Radiografia panoramica"),
    POSITRON_EMISSION_TOMOGRAPHY("PT", "1.2.840.10008.2.16.4", "Positron emission tomography", "Positron emission tomography", "Positronen-Emissions-Tomografie", "Tomographie par \u00e9mission de positons", "Tomografia a emissione di positroni"),
    RADIOFLUOROSCOPY("RF", "1.2.840.10008.2.16.4", "Radiofluoroscopy", "Radiofluoroscopy", "Radio-Fluoroskopie", "Radio-fluoroscopie", "Radiofluoroscopia"),
    RADIOGRAPHIC_IMAGING("RG", "1.2.840.10008.2.16.4", "Radiographic imaging", "Radiographic imaging", "R\u00f6ntgenbildgebung", "Imagerie radiographique", "Imaging radiografico"),
    SLIDE_MICROSCOPY("SM", "1.2.840.10008.2.16.4", "Slide Microscopy", "Slide Microscopy", "Objekttr\u00e4ger Mikroskopie", "Microscopie avec lamelles", "Microscopia a vetrini"),
    SUBJECTIVE_REFRACTION("SRF", "1.2.840.10008.2.16.4", "Subjective Refraction", "Subjective Refraction", "Subjektive Refraktion", "R\u00e9fraction subjective", "Rifrazione soggettiva"),
    ULTRASOUND("US", "1.2.840.10008.2.16.4", "Ultrasound", "Ultrasound", "Ultraschall", "Ultrason", "Ecografia"),
    ULTRASOUND_BONE_DENSITOMETRY("BDUS", "1.2.840.10008.2.16.4", "Ultrasound Bone Densitometry", "Ultrasound Bone Densitometry", "Ultraschall-Knochendichtemessung", "Densitom\u00e9trie osseuse par ultrasons", "Densitometria ossea a ultrasuoni"),
    VISUAL_ACUITY("VA", "1.2.840.10008.2.16.4", "Visual Acuity", "Visual Acuity", "Sehsch\u00e4rfe", "Acuit\u00e9 visuelle", "Acutezza visiva"),
    X_RAY_ANGIOGRAPHY("XA", "1.2.840.10008.2.16.4", "X-Ray Angiography", "X-Ray Angiography", "R\u00f6ntgen-Angiografie", "Angiographie par rayons X", "Angiografia a raggi X");

    public static final String AUTOREFRACTION_CODE = "AR";
    public static final String BONE_MINERAL_DENSITOMETRY_CODE = "BMD";
    public static final String CARDIAC_ELECTROPHYSIOLOGY_CODE = "EPS";
    public static final String COMPUTED_RADIOGRAPHY_CODE = "CR";
    public static final String COMPUTED_TOMOGRAPHY_CODE = "CT";
    public static final String DIGITAL_RADIOGRAPHY_CODE = "DX";
    public static final String ELECTROCARDIOGRAPHY_CODE = "ECG";
    public static final String ENDOSCOPY_CODE = "ES";
    public static final String EXTERNAL_CAMERA_PHOTOGRAPHY_CODE = "XC";
    public static final String GENERAL_MICROSCOPY_CODE = "GM";
    public static final String HEMODYNAMIC_WAVEFORM_CODE = "HD";
    public static final String INTRAVASCULAR_OPTICAL_COHERENCE_TOMOGRAPHY_CODE = "IVOCT";
    public static final String INTRAVASCULAR_ULTRASOUND_CODE = "IVUS";
    public static final String INTRA_ORAL_RADIOGRAPHY_CODE = "IO";
    public static final String KERATOMETRY_CODE = "KER";
    public static final String LENSOMETRY_CODE = "LEN";
    public static final String MAGNETIC_RESONANCE_CODE = "MR";
    public static final String MAMMOGRAPHY_CODE = "MG";
    public static final String NUCLEAR_MEDICINE_CODE = "NM";
    public static final String OPHTHALMIC_AXIAL_MEASUREMENTS_CODE = "OAM";
    public static final String OPHTHALMIC_MAPPING_CODE = "OPM";
    public static final String OPHTHALMIC_PHOTOGRAPHY_CODE = "OP";
    public static final String OPHTHALMIC_REFRACTION_CODE = "OPR";
    public static final String OPHTHALMIC_TOMOGRAPHY_CODE = "OPT";
    public static final String OPHTHALMIC_TOMOGRAPHY_B_SCAN_VOLUME_ANALYSIS_CODE = "OPTBSV";
    public static final String OPHTHALMIC_TOMOGRAPHY_EN_FACE_CODE = "OPTENF";
    public static final String OPHTHALMIC_VISUAL_FIELD_CODE = "OPV";
    public static final String OPTICAL_COHERENCE_TOMOGRAPHY_CODE = "OCT";
    public static final String OPTICAL_SURFACE_SCANNER_CODE = "OSS";
    public static final String PANORAMIC_X_RAY_CODE = "PX";
    public static final String POSITRON_EMISSION_TOMOGRAPHY_CODE = "PT";
    public static final String RADIOFLUOROSCOPY_CODE = "RF";
    public static final String RADIOGRAPHIC_IMAGING_CODE = "RG";
    public static final String SLIDE_MICROSCOPY_CODE = "SM";
    public static final String SUBJECTIVE_REFRACTION_CODE = "SRF";
    public static final String ULTRASOUND_CODE = "US";
    public static final String ULTRASOUND_BONE_DENSITOMETRY_CODE = "BDUS";
    public static final String VISUAL_ACUITY_CODE = "VA";
    public static final String X_RAY_ANGIOGRAPHY_CODE = "XA";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.3.10.1.8";
    public static final String VALUE_SET_NAME = "DocumentEntry.eventCodeList";
    public static final String CODE_SYSTEM_ID = "1.2.840.10008.2.16.4";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable EventCodeList getEnum(@Nullable String code) {
        for (EventCodeList x : EventCodeList.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(EventCodeList.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (EventCodeList x : EventCodeList.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private EventCodeList(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

