/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.enums.beta;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum DeletionStatus implements ValueSetEnumInterface
{
    DELETION_NOT_REQUESTED("urn:e-health-suisse:2019:deletionStatus:deletionNotRequested", "2.16.756.5.30.1.127.3.10.18", "Deletion not Requested", "Deletion not Requested", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    DELETION_PROHIBITED("urn:e-health-suisse:2019:deletionStatus:deletionProhibited", "2.16.756.5.30.1.127.3.10.18", "Deletion prohibited", "Deletion prohibited", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    DELETION_REQUESTED("urn:e-health-suisse:2019:deletionStatus:deletionRequested", "2.16.756.5.30.1.127.3.10.18", "Deletion requested", "Deletion requested", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String DELETION_NOT_REQUESTED_CODE = "urn:e-health-suisse:2019:deletionStatus:deletionNotRequested";
    public static final String DELETION_PROHIBITED_CODE = "urn:e-health-suisse:2019:deletionStatus:deletionProhibited";
    public static final String DELETION_REQUESTED_CODE = "urn:e-health-suisse:2019:deletionStatus:deletionRequested";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.3.10.15.3";
    public static final String VALUE_SET_NAME = "EprDeletionStatus";
    public static final String CODE_SYSTEM_ID = "2.16.756.5.30.1.127.3.10.18";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable DeletionStatus getEnum(@Nullable String code) {
        for (DeletionStatus x : DeletionStatus.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(DeletionStatus.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (DeletionStatus x : DeletionStatus.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private DeletionStatus(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

