/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.enums.beta;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ClassCode implements ValueSetEnumInterface
{
    ADMINISTRATIVE_DOCUMENTATION("405624007", "2.16.840.1.113883.6.96", "Administrative documentation (record artifact)", "Administrative documentation", "Administratives Dokument", "Document administratif", "Documento amministrativo"),
    ADVANCE_DIRECTIVE_REPORT("371538006", "2.16.840.1.113883.6.96", "Advance directive report (record artifact)", "Advance directive report", "Patientenverf\u00fcgung", "Directives anticip\u00e9es", "Direttive del paziente"),
    AUDIT_TRAIL_REPORT("722160009", "2.16.840.1.113883.6.96", "Audit trail report (record artifact)", "Audit trail report", "R\u00fcckverfolgung der EPD Zugriffe", "Tra\u00e7abilit\u00e9 des acc\u00e8s aux DEP", "Cronologia degli accessi alla CIP"),
    CARE_PLAN("734163000", "2.16.840.1.113883.6.96", "Care Plan (record artifact)", "Care Plan", "Behandlungsplan", "Plan de traitement", "Piano di trattamento"),
    CLINICAL_PROCEDURE_REPORT("371525003", "2.16.840.1.113883.6.96", "Clinical procedure report (record artifact)", "Clinical procedure report", "Interventionsbericht / Untersuchungsresultat", "Rapport d\u2019intervention / r\u00e9sultat de l\u2019analyse", "Rapporto operatorio / Referto di analisi"),
    CONSENT_REPORT("371537001", "2.16.840.1.113883.6.96", "Consent report (record artifact)", "Consent report", "Einwilligung zur Behandlung", "Consentement au traitement", "Consenso al trattamento"),
    EMERGENCY_MEDICAL_IDENTIFICATION_RECORD("722216001", "2.16.840.1.113883.6.96", "Emergency medical identification record (record artifact)", "Emergency medical identification record", "Notfall-ID / Ausweis", "ID d\u2019urgence / carte d\u2019urgence", "Identificativo d'emergenza / scheda d'emergenza"),
    OBSTETRICAL_RECORD("2171000195109", "2.16.756.5.30.1.127.3.4", "Obstetrical Record (record artifact)", "Obstetrical Record", "Schwangerschafts-/ Geburtsbericht", "Rapport de grossesse / de naissance", "Referto della gravidanza / del parto"),
    ORDER("721963009", "2.16.840.1.113883.6.96", "Order (record artifact)", "Order", "Untersuchungsauftrag", "Mandat d\u2019analyse", "Prescrizione di analisi"),
    ORGAN_DONOR_CARD("772790007", "2.16.840.1.113883.6.96", "Organ donor card (record artifact)", "Organ donor card", "Organspendeausweis", "Carte de donneur d\u2019organes", "Tessera di donatore di organi"),
    PATIENT_RECORD_TYPE("184216000", "2.16.840.1.113883.6.96", "Patient record type (record artifact)", "Patient record type", "Langzeitdokumentation", "Documentation \u00e0 long terme", "Documentazione a lungo termine"),
    PRESCRIPTION_RECORD("440545006", "2.16.840.1.113883.6.96", "Prescription record (record artifact)", "Prescription record", "Verschreibung / Rezept", "Prescription / ordonnance", "Prescrizione medica"),
    RECORD_ARTIFACT("419891008", "2.16.840.1.113883.6.96", "Record artifact (record artifact)", "Record artifact", "Nicht n\u00e4her bezeichnetes Dokument", "Document non pr\u00e9cis\u00e9", "Documento non meglio specificato"),
    RECORD_OF_HEALTH_EVENT("417319006", "2.16.840.1.113883.6.96", "Record of health event (record artifact)", "Record of health event", "Dokument zu gesundheitsrelevantem Ereignis", "Document sur l\u2019\u00e9v\u00e9nement sanitaire", "Documento concernente un evento rilevante per la salute"),
    REFERRAL_NOTE("721927009", "2.16.840.1.113883.6.96", "Referral note (record artifact)", "Referral note", "Zuweisungsschreiben", "Lettre de r\u00e9f\u00e9rence", "Lettera d'invio"),
    REPORT_OF_CLINICAL_ENCOUNTER("371531000", "2.16.840.1.113883.6.96", "Report of clinical encounter (record artifact)", "Report of clinical encounter", "Bericht aufgrund einer Konsultation", "Rapport suite \u00e0 une consultation", "Rapporto di visita medica"),
    SUMMARY_CLINICAL_DOCUMENT("422735006", "2.16.840.1.113883.6.96", "Summary clinical document (record artifact)", "Summary clinical document", "Zusammenfassender Bericht", "Rapport de synth\u00e8se", "Rapporto riassuntivo");

    public static final String ADMINISTRATIVE_DOCUMENTATION_CODE = "405624007";
    public static final String ADVANCE_DIRECTIVE_REPORT_CODE = "371538006";
    public static final String AUDIT_TRAIL_REPORT_CODE = "722160009";
    public static final String CARE_PLAN_CODE = "734163000";
    public static final String CLINICAL_PROCEDURE_REPORT_CODE = "371525003";
    public static final String CONSENT_REPORT_CODE = "371537001";
    public static final String EMERGENCY_MEDICAL_IDENTIFICATION_RECORD_CODE = "722216001";
    public static final String OBSTETRICAL_RECORD_CODE = "2171000195109";
    public static final String ORDER_CODE = "721963009";
    public static final String ORGAN_DONOR_CARD_CODE = "772790007";
    public static final String PATIENT_RECORD_TYPE_CODE = "184216000";
    public static final String PRESCRIPTION_RECORD_CODE = "440545006";
    public static final String RECORD_ARTIFACT_CODE = "419891008";
    public static final String RECORD_OF_HEALTH_EVENT_CODE = "417319006";
    public static final String REFERRAL_NOTE_CODE = "721927009";
    public static final String REPORT_OF_CLINICAL_ENCOUNTER_CODE = "371531000";
    public static final String SUMMARY_CLINICAL_DOCUMENT_CODE = "422735006";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.3.10.1.3";
    public static final String VALUE_SET_NAME = "DocumentEntry.classCode";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable ClassCode getEnum(@Nullable String code) {
        for (ClassCode x : ClassCode.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ClassCode.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (ClassCode x : ClassCode.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ClassCode(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

