/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.enums;

import java.util.HashMap;
import java.util.Map;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum AvailabilityStatus implements ValueSetEnumInterface
{
    APPROVED("urn:oasis:names:tc:ebxml-regrep:StatusType:Approved", "2.16.756.5.30.1.127.77.10.5.1", "Approved", "Approved", "genehmigt", "approuv\u00e9", "approvato"),
    DEPRECATED("urn:oasis:names:tc:ebxml-regrep:StatusType:Deprecated", "2.16.756.5.30.1.127.77.10.5.1", "Deprecated", "Deprecated", "veraltet", "caduc", "obsoleto");

    public static final String APPROVED_CODE = "urn:oasis:names:tc:ebxml-regrep:StatusType:Approved";
    public static final String DEPRECATED_CODE = "urn:oasis:names:tc:ebxml-regrep:StatusType:Deprecated";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.3.10.1.2";
    public static final String VALUE_SET_NAME = "xds-avStat";
    private String code;
    private String codeSystem;
    private Map<LanguageCode, String> displayNames;

    public static AvailabilityStatus getEnum(String code) {
        for (AvailabilityStatus x : AvailabilityStatus.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(AvailabilityStatus.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(String codeValue) {
        for (AvailabilityStatus x : AvailabilityStatus.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private AvailabilityStatus(String code, String codeSystem, String displayName, String displayNameEn, String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = code;
        this.codeSystem = codeSystem;
        this.displayNames = new HashMap<LanguageCode, String>();
        this.displayNames.put(null, displayName);
        this.displayNames.put(LanguageCode.ENGLISH, displayNameEn);
        this.displayNames.put(LanguageCode.GERMAN, displayNameDe);
        this.displayNames.put(LanguageCode.FRENCH, displayNameFr);
        this.displayNames.put(LanguageCode.ITALIAN, displayNameIt);
    }

    public String getCodeSystemId() {
        return this.codeSystem;
    }

    public String getCodeSystemName() {
        String retVal = "";
        CodeSystems cs = CodeSystems.getEnum((String)this.codeSystem);
        if (cs != null) {
            retVal = cs.getCodeSystemName();
        }
        return retVal;
    }

    public String getCodeValue() {
        return this.code;
    }

    public String getDisplayName(LanguageCode languageCode) {
        String displayName = this.displayNames.get(languageCode);
        if (displayName == null && languageCode == LanguageCode.ENGLISH) {
            return this.displayNames.get(null);
        }
        return displayName;
    }

    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

