/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.communication.ch.camel.validate;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Code;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.CodeValidation;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public class CodeEnumValidation
extends CodeValidation {
    private final QueryParameter queryParam;
    private final EnumSet<? extends ValueSetEnumInterface> authorizedValues;

    public CodeEnumValidation(QueryParameter param, boolean optional, EnumSet<? extends ValueSetEnumInterface> authorizedValues) {
        super(param, optional);
        Objects.requireNonNull(authorizedValues, "authorizedValues shall not be null in CodeEnumValidator()");
        this.authorizedValues = authorizedValues;
        this.queryParam = param;
    }

    public void validate(EbXMLAdhocQueryRequest request) throws XDSMetaDataException {
        super.validate(request);
        QuerySlotHelper slots = new QuerySlotHelper(request);
        List codes = slots.toCodeList(this.queryParam);
        if (codes != null) {
            for (Code code : codes) {
                boolean authorized = false;
                for (Enum enum_ : this.authorizedValues) {
                    if (!((ValueSetEnumInterface)enum_).isEqualTo(code)) continue;
                    authorized = true;
                    break;
                }
                ValidatorAssertions.metaDataAssert((boolean)authorized, (ValidationMessage)ValidationMessage.INVALID_QUERY_PARAMETER_VALUE, (Object[])new Object[]{this.queryParam});
            }
        }
    }
}

